/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.eventsapi;

import com.dynatrace.android.agent.events.eventsapi.EnrichmentAttribute;
import com.dynatrace.android.agent.events.eventsapi.EventMetrics;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONException;
import org.json.JSONObject;

public class EnrichmentAttributesGenerator {
    public static final long SEND_NOW_PLACEHOLDER = 1000000000000000000L;
    private static final String EVENT_TYPE_KEY = "event.type";
    private EventMetrics eventMetrics;
    private long timeStampNanos;

    public EnrichmentAttributesGenerator withEventMetrics(EventMetrics eventMetrics) {
        this.eventMetrics = eventMetrics;
        return this;
    }

    public EnrichmentAttributesGenerator withTimeStamp(long timeStampNanos) {
        this.timeStampNanos = timeStampNanos;
        return this;
    }

    public Set<EnrichmentAttribute> generateEventAttributes(String name) {
        TreeSet<EnrichmentAttribute> enrichmentAttributes = new TreeSet<EnrichmentAttribute>();
        enrichmentAttributes.add(EnrichmentAttribute.overridableEnrichmentAttribute("timestamp", this.timeStampNanos));
        enrichmentAttributes.add(EnrichmentAttribute.mandatoryEnrichmentAttribute("event.name", name));
        enrichmentAttributes.add(EnrichmentAttribute.overridableEnrichmentAttribute("event.kind", "RUM_EVENT"));
        enrichmentAttributes.add(EnrichmentAttribute.overridableEnrichmentAttribute("event.provider", this.eventMetrics.getAppBundle()));
        return this.insertEventMetricsToAttributes(enrichmentAttributes, this.eventMetrics);
    }

    public Set<EnrichmentAttribute> generateBizEventAttributes(String type, JSONObject rawCustomerPayload) {
        TreeSet<EnrichmentAttribute> enrichmentAttributes = new TreeSet<EnrichmentAttribute>();
        enrichmentAttributes.add(EnrichmentAttribute.overridableEnrichmentAttribute("timestamp", this.timeStampNanos));
        enrichmentAttributes.add(EnrichmentAttribute.overridableEnrichmentAttribute("event.provider", this.eventMetrics.getAppBundle()));
        enrichmentAttributes.add(EnrichmentAttribute.mandatoryEnrichmentAttribute(EVENT_TYPE_KEY, type));
        enrichmentAttributes.add(EnrichmentAttribute.mandatoryEnrichmentAttribute("event.kind", "BIZ_EVENT"));
        enrichmentAttributes.add(EnrichmentAttribute.mandatoryEnrichmentAttribute("dt.rum.custom_attributes_size", this.calculateAttributesSize(type, rawCustomerPayload)));
        return this.insertEventMetricsToAttributes(enrichmentAttributes, this.eventMetrics);
    }

    long calculateAttributesSize(String eventTypeValue, JSONObject rawCustomerPayload) {
        int payloadItems = rawCustomerPayload.length();
        long sizeOfExistingEventType = 0L;
        if (rawCustomerPayload.has(EVENT_TYPE_KEY)) {
            String existingEventType;
            sizeOfExistingEventType = payloadItems > 1 ? 1L : 0L;
            sizeOfExistingEventType += (long)"\"event.type\":".length();
            --payloadItems;
            try {
                existingEventType = rawCustomerPayload.getString(EVENT_TYPE_KEY);
                sizeOfExistingEventType += (long)("\"" + existingEventType + "\"").getBytes(StandardCharsets.UTF_8).length;
            }
            catch (JSONException e) {
                try {
                    existingEventType = rawCustomerPayload.get(EVENT_TYPE_KEY).toString();
                    sizeOfExistingEventType += (long)existingEventType.getBytes(StandardCharsets.UTF_8).length;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        long customerPayload = (long)rawCustomerPayload.toString().getBytes(StandardCharsets.UTF_8).length - sizeOfExistingEventType;
        int delimiter = payloadItems > 0 ? 1 : 0;
        long eventType = ("\"event.type\":\"" + eventTypeValue + "\"").getBytes(StandardCharsets.UTF_8).length;
        return eventType + (long)delimiter + customerPayload;
    }

    Set<EnrichmentAttribute> insertEventMetricsToAttributes(Set<EnrichmentAttribute> attributes, EventMetrics eventMetrics) {
        if (eventMetrics == null) {
            return attributes;
        }
        attributes.add(EnrichmentAttribute.mandatoryEnrichmentAttribute("dt.rum.application.id", eventMetrics.getApplicationId()));
        attributes.add(EnrichmentAttribute.mandatoryEnrichmentAttribute("dt.rum.instance.id", eventMetrics.getInstanceId()));
        attributes.add(EnrichmentAttribute.mandatoryEnrichmentAttribute("dt.rum.sid", eventMetrics.getSessionId()));
        attributes.add(EnrichmentAttribute.mandatoryEnrichmentAttribute("dt.rum.schema_version", eventMetrics.getSchemaVersion()));
        attributes.add(EnrichmentAttribute.overridableEnrichmentAttribute("device.manufacturer", eventMetrics.getDeviceManufacturer()));
        attributes.add(EnrichmentAttribute.overridableEnrichmentAttribute("device.model.identifier", eventMetrics.getDeviceModelIdentifier()));
        attributes.add(EnrichmentAttribute.overridableEnrichmentAttribute("device.is_rooted", eventMetrics.isDeviceRooted()));
        attributes.add(EnrichmentAttribute.overridableEnrichmentAttribute("os.name", eventMetrics.getOsName()));
        attributes.add(EnrichmentAttribute.overridableEnrichmentAttribute("os.version", eventMetrics.getOsVersion()));
        attributes.add(EnrichmentAttribute.overridableEnrichmentAttribute("app.version", eventMetrics.getAppVersion()));
        attributes.add(EnrichmentAttribute.overridableEnrichmentAttribute("app.short_version", eventMetrics.getAppShortVersion()));
        attributes.add(EnrichmentAttribute.overridableEnrichmentAttribute("app.bundle", eventMetrics.getAppBundle()));
        return attributes;
    }
}

