/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.compose;

import androidx.compose.ui.semantics.Role;
import com.dynatrace.android.compose.ClickableInfo;
import com.dynatrace.android.compose.SwipeableInfo;
import com.dynatrace.android.compose.ToggleableInfo;
import com.dynatrace.android.compose.pager.PagerInfo;
import com.dynatrace.android.compose.pullrefresh.PullRefreshInfo;
import com.dynatrace.android.compose.slider.RangeSliderInfo;
import com.dynatrace.android.compose.slider.SliderInfo;
import com.dynatrace.android.useraction.ActionNameGenerator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tB!\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB\u0019\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0011B!\b\u0016\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0014B!\b\u0016\u0012\u0006\u0010\u0012\u001a\u00020\u0015\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0016B!\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0017\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\b\u0010\u001c\u001a\u00020\u0005H\u0016R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/dynatrace/android/compose/ClassBasedActionNameGenerator;", "Lcom/dynatrace/android/useraction/ActionNameGenerator;", "clickableInfo", "Lcom/dynatrace/android/compose/ClickableInfo;", "semanticsName", "", "(Lcom/dynatrace/android/compose/ClickableInfo;Ljava/lang/String;)V", "toggleableInfo", "Lcom/dynatrace/android/compose/ToggleableInfo;", "(Lcom/dynatrace/android/compose/ToggleableInfo;Ljava/lang/String;)V", "swipeableInfo", "Lcom/dynatrace/android/compose/SwipeableInfo;", "maskingEnabled", "", "(Lcom/dynatrace/android/compose/SwipeableInfo;Ljava/lang/String;Z)V", "info", "Lcom/dynatrace/android/compose/pullrefresh/PullRefreshInfo;", "(Lcom/dynatrace/android/compose/pullrefresh/PullRefreshInfo;Ljava/lang/String;)V", "sliderInfo", "Lcom/dynatrace/android/compose/slider/SliderInfo;", "(Lcom/dynatrace/android/compose/slider/SliderInfo;Ljava/lang/String;Z)V", "Lcom/dynatrace/android/compose/slider/RangeSliderInfo;", "(Lcom/dynatrace/android/compose/slider/RangeSliderInfo;Ljava/lang/String;Z)V", "Lcom/dynatrace/android/compose/pager/PagerInfo;", "(Lcom/dynatrace/android/compose/pager/PagerInfo;Ljava/lang/String;Z)V", "actionName", "classNameWithoutPackage", "className", "generateActionName", "agent.instrumentorAPI.compose_release"})
public final class ClassBasedActionNameGenerator
implements ActionNameGenerator {
    @NotNull
    private final String actionName;

    public ClassBasedActionNameGenerator(@NotNull ClickableInfo clickableInfo, @Nullable String semanticsName) {
        String string;
        Object component;
        Intrinsics.checkNotNullParameter((Object)clickableInfo, (String)"clickableInfo");
        Object object = clickableInfo.getRole-RLKlGQI();
        if (object == null || (object = Role.toString-impl((int)object.unbox-impl())) == null) {
            object = component = "component";
        }
        if (semanticsName != null) {
            string = "Touch on " + semanticsName;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("Touch on ").append((String)component).append(" with function ");
            String string2 = clickableInfo.getFunction().getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"clickableInfo.function.javaClass.name");
            string = stringBuilder.append(this.classNameWithoutPackage(string2)).toString();
        }
        this.actionName = string;
    }

    public ClassBasedActionNameGenerator(@NotNull ToggleableInfo toggleableInfo, @Nullable String semanticsName) {
        Intrinsics.checkNotNullParameter((Object)toggleableInfo, (String)"toggleableInfo");
        Object object = toggleableInfo.getRole-RLKlGQI();
        if (object == null || (object = Role.toString-impl((int)object.unbox-impl())) == null) {
            object = "component";
        }
        Object component = object;
        this.actionName = semanticsName != null ? "Touch on " + semanticsName : "Touch on " + (String)component + " with function " + this.classNameWithoutPackage(toggleableInfo.getSourceName());
    }

    public ClassBasedActionNameGenerator(@NotNull SwipeableInfo swipeableInfo, @Nullable String semanticsName, boolean maskingEnabled) {
        String string;
        Intrinsics.checkNotNullParameter((Object)swipeableInfo, (String)"swipeableInfo");
        if (!maskingEnabled) {
            StringBuilder stringBuilder = new StringBuilder().append("Swipe component with ");
            String string2 = swipeableInfo.getSourceName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"swipeableInfo.sourceName");
            string = stringBuilder.append(this.classNameWithoutPackage(string2)).toString();
        } else if (semanticsName != null) {
            StringBuilder stringBuilder = new StringBuilder().append("Swipe ").append(semanticsName).append(" to ");
            String string3 = swipeableInfo.getSourceName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"swipeableInfo.sourceName");
            string = stringBuilder.append(this.classNameWithoutPackage(string3)).append(' ').append(swipeableInfo.getToState()).toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("Swipe to ");
            String string4 = swipeableInfo.getSourceName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"swipeableInfo.sourceName");
            string = stringBuilder.append(this.classNameWithoutPackage(string4)).append(' ').append(swipeableInfo.getToState()).toString();
        }
        this.actionName = string;
    }

    public ClassBasedActionNameGenerator(@NotNull PullRefreshInfo info, @Nullable String semanticsName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (semanticsName != null) {
            string = "Swipe to refresh " + semanticsName;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("Swipe to refresh component with function ");
            String string2 = info.getOnRefresh().getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"info.onRefresh.javaClass.name");
            string = stringBuilder.append(this.classNameWithoutPackage(string2)).toString();
        }
        this.actionName = string;
    }

    public ClassBasedActionNameGenerator(@NotNull SliderInfo sliderInfo, @Nullable String semanticsName, boolean maskingEnabled) {
        String string;
        Intrinsics.checkNotNullParameter((Object)sliderInfo, (String)"sliderInfo");
        if (semanticsName != null && maskingEnabled) {
            string = "Slide to select " + semanticsName;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("Slide component with function ");
            String string2 = sliderInfo.getSource().getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sliderInfo.source.javaClass.name");
            string = stringBuilder.append(this.classNameWithoutPackage(string2)).toString();
        }
        this.actionName = string;
    }

    public ClassBasedActionNameGenerator(@NotNull RangeSliderInfo sliderInfo, @Nullable String semanticsName, boolean maskingEnabled) {
        String string;
        Intrinsics.checkNotNullParameter((Object)sliderInfo, (String)"sliderInfo");
        if (semanticsName != null && maskingEnabled) {
            string = "Slide to select " + semanticsName;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("Slide component with function ");
            String string2 = sliderInfo.getSource().getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sliderInfo.source.javaClass.name");
            string = stringBuilder.append(this.classNameWithoutPackage(string2)).toString();
        }
        this.actionName = string;
    }

    public ClassBasedActionNameGenerator(@NotNull PagerInfo info, @Nullable String semanticsName, boolean maskingEnabled) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.actionName = semanticsName != null && maskingEnabled ? "Swipe " + semanticsName + " to page index " + info.getCurrentPage() : "Swipe to page index " + info.getCurrentPage();
    }

    private final String classNameWithoutPackage(String className) {
        return StringsKt.substringAfterLast$default((String)className, (char)'.', null, (int)2, null);
    }

    @NotNull
    public String generateActionName() {
        return this.actionName;
    }
}

