/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.DTXActionImpl;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import java.util.NoSuchElementException;
import java.util.Vector;

public final class ActionThreadLocal {
    private static final String LOGTAG = Global.LOG_PREFIX + "ActionThreadLocal";
    private static final ThreadLocal<Vector<DTXActionImpl>> tlVector = new ThreadLocal<Vector<DTXActionImpl>>(){

        @Override
        protected Vector<DTXActionImpl> initialValue() {
            return new Vector<DTXActionImpl>();
        }
    };

    static final boolean addAction(DTXActionImpl action) {
        ActionThreadLocal.trim();
        if (action != null && !action.isFinalized()) {
            return tlVector.get().add(action);
        }
        return false;
    }

    static final synchronized void trim() {
        Vector copy = new Vector(tlVector.get());
        for (int i = 0; i < copy.size(); ++i) {
            DTXActionImpl a = null;
            try {
                a = tlVector.get().get(i);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
            if (a == null || !a.isFinalized()) continue;
            tlVector.get().remove(a);
        }
        copy.clear();
        copy = null;
    }

    static final boolean removeAction(DTXActionImpl action) {
        boolean rc = tlVector.get().remove(action);
        ActionThreadLocal.trim();
        return rc;
    }

    public static final DTXActionImpl getCurrentAction() {
        ActionThreadLocal.trim();
        try {
            return tlVector.get().lastElement();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized void closeAll() {
        block6: {
            try {
                Vector copy;
                ThreadLocal<Vector<DTXActionImpl>> threadLocal = tlVector;
                synchronized (threadLocal) {
                    copy = new Vector(tlVector.get());
                }
                for (int i = 0; i < copy.size(); ++i) {
                    DTXActionImpl a = (DTXActionImpl)copy.get(i);
                    if (a == null || a.isFinalized()) continue;
                    a.leaveAction();
                }
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block6;
                Utility.zlogD(LOGTAG, "Expected exception? It depends on what you expect!", e);
            }
        }
    }
}

