/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.comm.ssl;

import com.dynatrace.android.agent.comm.ssl.SimpleX509TrustManager;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.X509TrustManager;

public class LocalX509TrustManager
implements X509TrustManager {
    private X509TrustManager localTrustMgr = null;
    private X509TrustManager defTrustMgr = null;
    private X509Certificate[] acceptedCertIssuers;
    private boolean allowAnyCert = false;

    public LocalX509TrustManager(KeyStore keyStore, boolean useAnyCert) throws NoSuchAlgorithmException, KeyStoreException {
        this.allowAnyCert = useAnyCert;
        ArrayList<X509Certificate> issuers = new ArrayList<X509Certificate>();
        this.defTrustMgr = new SimpleX509TrustManager(null);
        if (this.defTrustMgr != null) {
            for (X509Certificate cert : this.defTrustMgr.getAcceptedIssuers()) {
                issuers.add(cert);
            }
        } else {
            throw new NoSuchAlgorithmException("No global trust manager found");
        }
        if (keyStore != null) {
            this.localTrustMgr = new SimpleX509TrustManager(keyStore);
            if (this.localTrustMgr != null) {
                for (X509Certificate cert : this.localTrustMgr.getAcceptedIssuers()) {
                    issuers.add(cert);
                }
            } else {
                throw new NoSuchAlgorithmException("No local trust manager found");
            }
        }
        this.acceptedCertIssuers = issuers.toArray(new X509Certificate[issuers.size()]);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkTrusted(chain, authType, false);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkTrusted(chain, authType, true);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.acceptedCertIssuers;
    }

    private void checkTrusted(X509Certificate[] chain, String authType, boolean chkServerTrusted) throws CertificateException {
        if (this.allowAnyCert) {
            return;
        }
        if (chkServerTrusted) {
            try {
                this.defTrustMgr.checkServerTrusted(chain, authType);
            }
            catch (CertificateException e) {
                if (this.localTrustMgr == null) {
                    throw e;
                }
                this.localTrustMgr.checkServerTrusted(chain, authType);
            }
        } else {
            try {
                this.defTrustMgr.checkClientTrusted(chain, authType);
            }
            catch (CertificateException e) {
                if (this.localTrustMgr == null) {
                    throw e;
                }
                this.localTrustMgr.checkClientTrusted(chain, authType);
            }
        }
    }
}

