/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;

public class ParmDbHelper
extends SQLiteOpenHelper {
    static final String COLUMN_ROW_ID = "_id";
    static final String COLUMN_VISITOR_ID = "visitorid";
    static final String COLUMN_SESSION_ID = "sessionid";
    static final String DB_NAME = "DTXDbP";
    static final String TABLE_PARM = "parm";
    static final int DB_VERSION = 1;
    private static final String TAG = Global.LOG_PREFIX + "ParmDbHelper";
    private static final int INITIAL_VISITOR_ID = 0;
    private static final int INITIAL_SESSION_ID = 0;
    private static final String DATABASE_CREATE = String.format("create table %s (%s integer primary key autoincrement,%s integer not null,%s integer not null);", "parm", "_id", "visitorid", "sessionid");
    private static final String MAIN_ROW_WHERE_CLAUSE = "_id=1";

    public ParmDbHelper(Context context) {
        super(context, DB_NAME, null, 1);
    }

    public void onCreate(SQLiteDatabase db) {
        if (Global.DEBUG) {
            Utility.zlogD(TAG, String.format("Creating Db.Table(%s.%s)", DB_NAME, TABLE_PARM));
        }
        db.execSQL(DATABASE_CREATE);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.recreate(db, oldVersion, newVersion, "Upgrading");
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.recreate(db, oldVersion, newVersion, "Downgrading");
    }

    private void recreate(SQLiteDatabase db, int oldVersion, int newVersion, String label) {
        if (Global.DEBUG) {
            Utility.zlogD(TAG, String.format("%s Db.Table(%s.%s) from version %s to %s.", label, DB_NAME, TABLE_PARM, oldVersion, newVersion));
        }
        this.dropTable(db, TABLE_PARM);
        this.onCreate(db);
    }

    private void dropTable(SQLiteDatabase db, String tableName) {
        block2: {
            try {
                db.execSQL("DROP TABLE IF EXISTS " + tableName);
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block2;
                Utility.zlogE(TAG, "could not delete table " + tableName, e);
            }
        }
    }

    public long createMainRow() {
        ContentValues initialValues = new ContentValues();
        initialValues.put(COLUMN_VISITOR_ID, Integer.valueOf(0));
        initialValues.put(COLUMN_SESSION_ID, Integer.valueOf(0));
        return this.getWritableDatabase().insert(TABLE_PARM, null, initialValues);
    }

    public boolean resetMainRow() {
        ContentValues cvArgs = new ContentValues();
        cvArgs.put(COLUMN_VISITOR_ID, Integer.valueOf(0));
        cvArgs.put(COLUMN_SESSION_ID, Integer.valueOf(0));
        return this.getWritableDatabase().update(TABLE_PARM, cvArgs, MAIN_ROW_WHERE_CLAUSE, null) > 0;
    }

    public Long fetchSessionId() {
        return this.fetchColumnValue(COLUMN_SESSION_ID);
    }

    public boolean updateSessionId(long newSessionId) {
        ContentValues cvArgs = new ContentValues();
        cvArgs.put(COLUMN_SESSION_ID, Long.valueOf(newSessionId));
        return this.getWritableDatabase().update(TABLE_PARM, cvArgs, MAIN_ROW_WHERE_CLAUSE, null) > 0;
    }

    public boolean updateVisitorId(long newVisitorId) {
        ContentValues cvArgs = new ContentValues();
        cvArgs.put(COLUMN_VISITOR_ID, Long.valueOf(newVisitorId));
        return this.getWritableDatabase().update(TABLE_PARM, cvArgs, MAIN_ROW_WHERE_CLAUSE, null) > 0;
    }

    public Long fetchVisitorId() {
        return this.fetchColumnValue(COLUMN_VISITOR_ID);
    }

    private Long fetchColumnValue(String columnName) {
        Cursor cursor = this.getReadableDatabase().query(true, TABLE_PARM, new String[]{columnName}, MAIN_ROW_WHERE_CLAUSE, null, null, null, null, null);
        if (cursor == null) {
            return null;
        }
        Long value = null;
        if (cursor.moveToFirst()) {
            int dataColumnIndex = cursor.getColumnIndexOrThrow(columnName);
            value = cursor.getLong(dataColumnIndex);
        }
        cursor.close();
        return value;
    }
}

