/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.eventsapi;

import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.events.eventsapi.AttributeFilter;
import com.dynatrace.android.agent.events.eventsapi.EnrichmentAttribute;
import com.dynatrace.android.agent.util.Utility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventPayloadGenerator {
    private static final String LOGTAG = Global.LOG_PREFIX + "EventPayloadGenerator";
    private static final int PAYLOAD_SIZE_LIMIT = 16384;
    public static final String DT_OVERRIDDEN_KEYS = "dt.overridden_keys";
    private final AttributeFilter copyFilter;

    public EventPayloadGenerator(AttributeFilter copyFilter) {
        this.copyFilter = copyFilter;
    }

    public String generatePayload(Set<EnrichmentAttribute> enrichmentAttributes, JSONObject payloadAttributes, boolean useOverriddenKeys) {
        JSONObject payloadCopy = this.shallowJsonCopy(payloadAttributes);
        String json = (payloadCopy = this.enrichPayload(enrichmentAttributes, payloadCopy, useOverriddenKeys)).toString();
        if (json == null) {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, "JSON serialization failed.");
            }
            return null;
        }
        if (json.length() > 16384) {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, "Event payload size (" + json.length() + " bytes) exceeds the size limit of " + 16384 + " bytes");
            }
            return null;
        }
        return json;
    }

    JSONObject shallowJsonCopy(JSONObject original) {
        JSONObject copy = new JSONObject();
        Iterator it = original.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            try {
                if (this.copyFilter.keepAttribute(key)) {
                    copy.put(key, original.get(key));
                    continue;
                }
                if (!Global.DEBUG) continue;
                Utility.zlogD(LOGTAG, "Found reserved attribute \"" + key + "\" in the JSON payload. This attribute is removed from the JSON payload.");
            }
            catch (JSONException e) {
                if (!Global.DEBUG) continue;
                Utility.zlogD(LOGTAG, "Unexpected JSON error", e);
            }
        }
        return copy;
    }

    JSONObject enrichPayload(Set<EnrichmentAttribute> enrichmentAttributes, JSONObject payloadAttributes, boolean useOverriddenKeys) {
        block14: {
            ArrayList<String> overriddenKeys = new ArrayList<String>();
            for (EnrichmentAttribute attribute : enrichmentAttributes) {
                boolean attributeInPayload = payloadAttributes.has(attribute.getKey());
                boolean insertEnrichmentAttribute = true;
                if (attributeInPayload) {
                    Object payloadValue = null;
                    try {
                        payloadValue = payloadAttributes.get(attribute.getKey());
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    if (attribute.isOverridableBy(payloadValue)) {
                        if (attribute.shouldBeAddedToOverridableKeys()) {
                            overriddenKeys.add(attribute.getKey());
                        }
                        insertEnrichmentAttribute = false;
                    } else if (Global.DEBUG) {
                        Utility.zlogD(LOGTAG, "Event payload already contains a reserved or invalid value for key \"" + attribute.getKey() + "\". This value will be overwritten.");
                    }
                }
                if (!insertEnrichmentAttribute) continue;
                try {
                    if (attribute.getValue() != null) {
                        payloadAttributes.put(attribute.getKey(), attribute.getValue());
                        continue;
                    }
                    payloadAttributes.remove(attribute.getKey());
                    if (!Global.DEBUG) continue;
                    Utility.zlogD(LOGTAG, "Value for attribute \"" + attribute.getKey() + "\" is invalid. Therefore this attribute is omitted.");
                }
                catch (JSONException e) {
                    if (!Global.DEBUG) continue;
                    Utility.zlogD(LOGTAG, "Unsupported value type for enrichment attribute \"" + attribute.getKey() + "\"", e);
                }
            }
            if (overriddenKeys.size() > 0 && useOverriddenKeys) {
                try {
                    payloadAttributes.put(DT_OVERRIDDEN_KEYS, (Object)new JSONArray(overriddenKeys));
                }
                catch (JSONException e) {
                    if (!Global.DEBUG) break block14;
                    Utility.zlogD(LOGTAG, "Adding 'dt.overridden_keys' failed", e);
                }
            }
        }
        return payloadAttributes;
    }
}

