/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.lifecycle;

import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.events.lifecycle.AppStartEventWriter;
import com.dynatrace.android.agent.measurement.MeasurementPoint;
import com.dynatrace.android.agent.util.Utility;

public class AppStartSegment
extends CustomSegment {
    private final MeasurementPoint startPoint;
    private final MeasurementPoint endPoint;
    private final String activityName;
    private final boolean forwardToGrail;

    private AppStartSegment(Builder builder) {
        super(builder.activityName, 15, builder.session, builder.serverId, builder.forwardToGrail);
        this.activityName = Utility.truncateString(builder.activityName, 250);
        this.eventType = builder.eventType;
        this.lcSeqNum = builder.startPoint.getSequenceNumber();
        this.mEventStartTime = builder.startPoint.getTimestamp();
        this.mParentTagId = builder.parentActionId;
        this.startPoint = builder.startPoint;
        this.endPoint = builder.endPoint;
        this.mFinalized = true;
        this.forwardToGrail = builder.forwardToGrail;
    }

    public MeasurementPoint getStartPoint() {
        return this.startPoint;
    }

    public MeasurementPoint getEndPoint() {
        return this.endPoint;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public boolean getForwardToGrail() {
        return this.forwardToGrail;
    }

    @Override
    public StringBuilder createEventData() {
        return new AppStartEventWriter().toBeaconString(this);
    }

    public static class Builder {
        private String activityName;
        private Session session;
        private int serverId;
        private long parentActionId;
        private EventType eventType;
        private MeasurementPoint startPoint;
        private MeasurementPoint endPoint;
        private boolean forwardToGrail;

        public Builder withActivityName(String name) {
            this.activityName = name;
            return this;
        }

        public Builder withSession(Session session) {
            this.session = session;
            return this;
        }

        public Builder withServerId(int serverId) {
            this.serverId = serverId;
            return this;
        }

        public Builder withStartPoint(MeasurementPoint startPoint) {
            this.startPoint = startPoint;
            return this;
        }

        public Builder withEndPoint(MeasurementPoint endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        public Builder withParentActionId(long parentActionId) {
            this.parentActionId = parentActionId;
            return this;
        }

        public Builder withEventType(EventType eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder withForwardToGrail(boolean forwardToGrail) {
            this.forwardToGrail = forwardToGrail;
            return this;
        }

        public AppStartSegment build() {
            return new AppStartSegment(this);
        }
    }
}

