/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.internal.api;

import android.app.Application;
import android.os.Build;
import java.lang.reflect.Method;

public class ProcessAnalyzer {
    private static final String WORKER_PROCESS_NAME = ":dynatrace_replay_service";

    public boolean isInternalProcess() {
        String name = this.getProcessNameOrNull();
        if (name == null) {
            return false;
        }
        return name.contains(WORKER_PROCESS_NAME);
    }

    String getProcessNameOrNull() {
        if (Build.VERSION.SDK_INT >= 28) {
            return Application.getProcessName();
        }
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Method currentProcessNameMethod = activityThreadClass.getMethod("currentProcessName", new Class[0]);
            return (String)currentProcessNameMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }
}

