/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.comm;

import android.os.Build;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.comm.HttpConstants;
import com.dynatrace.android.agent.comm.HttpResponse;
import com.dynatrace.android.agent.comm.ssl.LocalX509TrustManager;
import com.dynatrace.android.agent.events.eventsapi.EventPayloadUtility;
import com.dynatrace.android.agent.util.Utility;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class CommHandler {
    private static final String TAG = Global.LOG_PREFIX + "CommHandler";
    private static int CONN_TIMEOUT = 10000;
    private static int READ_TIMEOUT = 30000;

    private static boolean isGZIPStream(byte[] content) {
        return content.length >= 2 && content[0] == 31 && content[1] == -117;
    }

    private static byte[] decompress(byte[] content) throws IOException {
        GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(content));
        return Utility.readStream(gzip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpResponse executeRequest(String url, String messageData, boolean keepConnectionAlive) throws Exception {
        HttpURLConnection conn = null;
        BufferedInputStream bis = null;
        try {
            byte[] content;
            String respMsg;
            int respCode;
            block21: {
                Map<String, String> localHeaders;
                conn = this.openConnection(new URL(url));
                conn.setConnectTimeout(CONN_TIMEOUT);
                conn.setReadTimeout(READ_TIMEOUT);
                if (!keepConnectionAlive) {
                    conn.setRequestProperty("Connection", "close");
                }
                if ((localHeaders = HttpConstants.customBeaconHeaders) != null) {
                    for (Map.Entry<String, String> entry : localHeaders.entrySet()) {
                        conn.setRequestProperty(entry.getKey(), entry.getValue());
                    }
                }
                conn.addRequestProperty("Accept-Encoding", "identity, gzip");
                if (messageData != null) {
                    conn.setRequestProperty("Content-Type", "text/plain; charset=utf-8");
                    conn.setRequestProperty("Content-Encoding", "gzip");
                    conn.setDoOutput(true);
                    if (Global.DEBUG) {
                        Utility.zlogD(TAG, String.format("aPOST url[%s] data[%s]", url, messageData));
                    }
                    String data = messageData.replace("__tsNow__", String.valueOf(TimeLineProvider.getSystemTime()));
                    data = EventPayloadUtility.replaceMacroWithTime(data, TimeLineProvider.getSystemTimeNanos());
                    GZIPOutputStream os = new GZIPOutputStream(conn.getOutputStream());
                    ((OutputStream)os).write(data.getBytes("utf-8"));
                    ((OutputStream)os).close();
                } else if (Global.DEBUG) {
                    Utility.zlogD(TAG, String.format("Send status request ... %s", url));
                }
                respCode = conn.getResponseCode();
                respMsg = conn.getResponseMessage();
                content = null;
                try {
                    bis = new BufferedInputStream(conn.getInputStream());
                    content = Utility.readStream(bis);
                }
                catch (IOException e) {
                    InputStream errorStream;
                    if (!Global.DEBUG || (errorStream = conn.getErrorStream()) == null) break block21;
                    bis = new BufferedInputStream(errorStream);
                    content = Utility.readStream(bis);
                }
            }
            String body = null;
            if (content != null) {
                if (CommHandler.isGZIPStream(content)) {
                    content = CommHandler.decompress(content);
                }
                body = new String(content);
            }
            if (Global.DEBUG) {
                Utility.zlogD(TAG, String.format("Response code: %s, msg: %s, body: %s", respCode, respMsg, body));
            }
            HttpResponse httpResponse = new HttpResponse(respCode, respMsg, body, conn.getHeaderFields());
            return httpResponse;
        }
        finally {
            block22: {
                if (conn != null) {
                    conn.disconnect();
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        if (!Global.DEBUG) break block22;
                        Utility.zlogE(TAG, "execution of Http-Request fails", e);
                    }
                }
            }
        }
    }

    private HttpURLConnection openConnection(URL url) throws IOException, GeneralSecurityException {
        if (!HttpConstants.bGHttps) {
            return (HttpURLConnection)url.openConnection();
        }
        HttpsURLConnection sconn = (HttpsURLConnection)url.openConnection();
        if (Build.VERSION.SDK_INT < 24 || HttpConstants.keyStore != null || HttpConstants.bGHttpsAnyCert) {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(HttpConstants.keyMgrs, new TrustManager[]{new LocalX509TrustManager(HttpConstants.keyStore, HttpConstants.bGHttpsAnyCert)}, new SecureRandom());
            sconn.setSSLSocketFactory(context.getSocketFactory());
        }
        return sconn;
    }
}

