/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.metrics;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Point;
import android.hardware.display.DisplayManager;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.Display;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.RootDetector;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.metrics.AppVersion;
import com.dynatrace.android.agent.metrics.AppVersionTracker;
import com.dynatrace.android.agent.metrics.BatteryTracker;
import com.dynatrace.android.agent.metrics.ConnectionType;
import com.dynatrace.android.agent.util.SdkVersionProviderImpl;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.lifecycle.activitytracking.metrics.ScreenMetrics;
import com.dynatrace.android.lifecycle.activitytracking.metrics.ScreenMetricsUtility;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;

public class AndroidMetrics {
    private static final String LOGTAG = Global.LOG_PREFIX + "AndroidMetrics";
    private static volatile AndroidMetrics theInstance = null;
    private final Context context;
    private final BatteryTracker batteryTracker;
    private final AppVersionTracker appVersionTracker;
    public Long deviceMemorySize;
    public String manufacturer;
    public String userLang;
    public boolean deviceRooted;
    public String deviceCarrier;
    public volatile ConnectionType connectionType = ConnectionType.OFFLINE;
    public String networkProtocol = null;
    public int deviceOrientation = 0;
    public String osVersion;
    public String operatingSystem;
    public String cpuInformation;
    public int batteryLevel = Integer.MIN_VALUE;
    public Long deviceMemoryFree;
    public String modelId;
    public Location mockDeviceLocation = null;
    ScreenMetrics screenMetrics = null;
    private String currentActivityName;
    private AppVersion appVersion;

    public AndroidMetrics(Context ctx) {
        this.context = ctx;
        if (this.context == null) {
            this.appVersionTracker = null;
            this.batteryTracker = null;
        } else {
            this.appVersionTracker = new AppVersionTracker(ctx, new SdkVersionProviderImpl());
            this.batteryTracker = BatteryTracker.generateBatteryTracker(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AndroidMetrics getInstance() {
        if (theInstance != null) return theInstance;
        Class<AndroidMetrics> clazz = AndroidMetrics.class;
        synchronized (AndroidMetrics.class) {
            if (theInstance != null) return theInstance;
            theInstance = new AndroidMetrics(AdkSettings.getInstance().getContext());
            theInstance.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return theInstance;
        }
    }

    public static String formatUserLanguage(Locale locale) {
        String userLang = locale.getLanguage();
        if (locale.getCountry().length() > 0) {
            userLang = userLang + "_" + locale.getCountry();
        }
        return userLang;
    }

    private void init() {
        this.manufacturer = Build.MANUFACTURER;
        this.deviceRooted = RootDetector.isDeviceRooted();
        this.osVersion = Build.VERSION.RELEASE;
        this.operatingSystem = "Android " + this.osVersion;
        this.cpuInformation = Utility.getCPUInfo();
        this.modelId = Build.MODEL;
        this.userLang = AndroidMetrics.formatUserLanguage(Locale.getDefault());
        this.updateVerboseMetrics();
        this.updateBasicMetrics();
        this.updateCommonMetrics();
        this.screenMetrics = this.getInitialScreenMetrics();
    }

    ScreenMetrics getInitialScreenMetrics() {
        if (this.context == null) {
            return null;
        }
        DisplayManager manager = (DisplayManager)this.context.getSystemService("display");
        Display display = manager.getDisplay(0);
        if (display == null) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)"Could not find a default Display");
            }
            return null;
        }
        ScreenMetrics.Builder metricsBuilder = new ScreenMetrics.Builder();
        DisplayMetrics metrics = ScreenMetricsUtility.getDisplayMetricsFromDisplay(display);
        metricsBuilder.withScreenDensityFactor(metrics.density);
        metricsBuilder.withScreenDensityDpi(metrics.densityDpi);
        Point displayMeasures = ScreenMetricsUtility.getDimensionsFromDisplay(display);
        metricsBuilder.withScreenWidth(displayMeasures.x);
        metricsBuilder.withScreenHeight(displayMeasures.y);
        return metricsBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVerboseMetrics() {
        Long updateStartTime = 0L;
        if (Global.DEBUG) {
            updateStartTime = TimeLineProvider.getSystemTime();
        }
        if (this.deviceMemorySize == null) {
            long memTotal = 0L;
            FileReader localFileReader = null;
            BufferedReader localBufferedReader = null;
            try {
                localFileReader = new FileReader("/proc/meminfo");
                localBufferedReader = new BufferedReader(localFileReader, 8192);
                String str1 = localBufferedReader.readLine();
                String[] arrayOfString = str1.split("\\s+");
                memTotal = Long.valueOf(arrayOfString[1]);
                localBufferedReader.close();
                localFileReader.close();
            }
            catch (IOException e) {
                if (Global.DEBUG) {
                    Utility.zlogD((String)LOGTAG, (String)"Unable to measure total memory", (Throwable)e);
                }
            }
            finally {
                block25: {
                    block24: {
                        if (localFileReader != null) {
                            try {
                                localFileReader.close();
                            }
                            catch (IOException e) {
                                if (!Global.DEBUG) break block24;
                                Utility.zlogD((String)LOGTAG, (String)"Could not close input stream", (Throwable)e);
                            }
                        }
                    }
                    if (localBufferedReader != null) {
                        try {
                            localBufferedReader.close();
                        }
                        catch (IOException e) {
                            if (!Global.DEBUG) break block25;
                            Utility.zlogD((String)LOGTAG, (String)"Could not close input stream", (Throwable)e);
                        }
                    }
                }
            }
            this.deviceMemorySize = memTotal / 1024L;
        }
        if (Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)String.format("Verbose metrics updated in %s ms", TimeLineProvider.getSystemTime() - updateStartTime));
        }
    }

    public void updateBasicMetrics() {
        Long updateStartTime = 0L;
        if (Global.DEBUG) {
            updateStartTime = TimeLineProvider.getSystemTime();
        }
        this.updateCarrier();
        if (Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)String.format("Basic metrics updated in %s ms", TimeLineProvider.getSystemTime() - updateStartTime));
        }
    }

    public void updateCommonMetrics() {
        Long updateStartTime = 0L;
        if (Global.DEBUG) {
            updateStartTime = TimeLineProvider.getSystemTime();
        }
        this.updateConnInfo();
        if (this.context != null) {
            this.deviceOrientation = this.context.getResources().getConfiguration().orientation;
        }
        this.updateBatteryStrength();
        this.updateMemoryInfo();
        if (this.appVersionTracker != null) {
            this.appVersion = this.appVersionTracker.determineAppVersion();
        }
        if (Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)String.format("Common metrics updated in %s ms", TimeLineProvider.getSystemTime() - updateStartTime));
        }
    }

    private void updateCarrier() {
        block4: {
            if (this.context == null) {
                return;
            }
            this.deviceCarrier = null;
            try {
                TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
                String carrier = telephonyManager.getNetworkOperatorName();
                if (carrier != null) {
                    this.deviceCarrier = Utility.truncateString((String)(carrier != null ? carrier : "unknown"), (int)250);
                }
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block4;
                Utility.zlogW((String)LOGTAG, (String)e.toString());
            }
        }
    }

    private void updateConnInfo() {
        NetworkInfo nwInfo = this.getNetworkInfo();
        this.connectionType = this.getConnType(nwInfo);
        switch (this.connectionType) {
            case WIFI: {
                this.networkProtocol = "802.11x";
                break;
            }
            case MOBILE: {
                this.networkProtocol = this.getMobileNetworkProtocol(nwInfo);
                break;
            }
            case LAN: {
                this.networkProtocol = "Ethernet";
                break;
            }
            default: {
                this.networkProtocol = null;
            }
        }
    }

    private String getMobileNetworkProtocol(NetworkInfo nwInfo) {
        switch (nwInfo.getSubtype()) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                return "2G";
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                return "3G";
            }
            case 13: 
            case 18: 
            case 19: {
                return "4G";
            }
            case 20: {
                return "5G";
            }
        }
        return nwInfo.getSubtypeName();
    }

    private void updateBatteryStrength() {
        if (this.batteryTracker != null) {
            this.batteryLevel = this.batteryTracker.captureBatteryLevel();
        }
    }

    private void updateMemoryInfo() {
        ActivityManager aM = this.getActivityMgr();
        if (aM == null) {
            this.deviceMemoryFree = null;
            return;
        }
        ActivityManager.MemoryInfo mI = new ActivityManager.MemoryInfo();
        aM.getMemoryInfo(mI);
        this.deviceMemoryFree = mI.availMem / 0x100000L;
    }

    private ActivityManager getActivityMgr() {
        ActivityManager aM;
        block2: {
            aM = null;
            try {
                aM = (ActivityManager)this.context.getSystemService("activity");
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block2;
                Utility.zlogW((String)LOGTAG, (String)e.toString());
            }
        }
        return aM;
    }

    private NetworkInfo getNetworkInfo() {
        NetworkInfo nI;
        block3: {
            nI = null;
            if (this.context == null) {
                return nI;
            }
            try {
                ConnectivityManager cMgr = (ConnectivityManager)this.context.getSystemService("connectivity");
                nI = cMgr.getActiveNetworkInfo();
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block3;
                Utility.zlogW((String)LOGTAG, (String)e.toString());
            }
        }
        return nI;
    }

    public boolean isNetworkAvailable() {
        boolean available;
        NetworkInfo nwInfo = this.getNetworkInfo();
        boolean bl = available = nwInfo != null && (nwInfo.isAvailable() || nwInfo.isConnected());
        if (!available && Global.DEBUG) {
            Utility.zlogI((String)LOGTAG, (String)"Network connection is not available");
        }
        return available;
    }

    public ConnectionType getConnType() {
        return this.getConnType(this.getNetworkInfo());
    }

    public ConnectionType getConnType(NetworkInfo knownNwInfo) {
        if (knownNwInfo == null || !knownNwInfo.isAvailable() || !knownNwInfo.isConnected()) {
            return ConnectionType.OFFLINE;
        }
        switch (knownNwInfo.getType()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                return ConnectionType.MOBILE;
            }
            case 1: 
            case 13: {
                return ConnectionType.WIFI;
            }
            case 9: {
                return ConnectionType.LAN;
            }
        }
        return ConnectionType.OTHER;
    }

    public String getCurrentActivityName() {
        return this.currentActivityName;
    }

    public void setCurrentActivityName(String currentActivityName) {
        this.currentActivityName = currentActivityName;
    }

    public ScreenMetrics getScreenMetrics() {
        return this.screenMetrics;
    }

    public void updateScreenMetrics(ScreenMetrics screenMetrics) {
        if (!this.screenMetricsAreValid(screenMetrics)) {
            if (Global.DEBUG) {
                Utility.zlogW((String)LOGTAG, (String)("Rejecting invalid screen metrics: " + screenMetrics));
            }
            this.screenMetrics = null;
        } else {
            this.screenMetrics = screenMetrics;
        }
    }

    boolean screenMetricsAreValid(ScreenMetrics screenMetrics) {
        if (screenMetrics == null) {
            return false;
        }
        return screenMetrics.getScreenHeight() > 0 && screenMetrics.getScreenWidth() > 0 && screenMetrics.getScreenDensityDpi() > 0 && screenMetrics.getScreenDensityFactor() != Float.POSITIVE_INFINITY && screenMetrics.getScreenDensityFactor() > 0.0f;
    }

    public AppVersion getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(AppVersion appVersion) {
        this.appVersion = appVersion;
    }

    public void setGpsLocation(Location location) {
        this.mockDeviceLocation = location;
        if (Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)("GPS/Network getLastKnownLocation mockDeviceLocation:" + this.mockDeviceLocation));
        }
    }
}

