/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.mixed;

import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.mixed.BaseRequestData;
import com.dynatrace.android.agent.util.Utility;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class AutoWebRequestEventGenerator {
    private static final String LOG_TAG = Global.LOG_PREFIX + "AutoWebRequestEventGenerator";
    private BaseRequestData baseData;
    private String networkProtocolName;
    private String httpRequestMethod;
    private int statusCode = -1;
    private String reasonPhrase;
    private Throwable exception;
    private Map<String, List<String>> requestHeaders = null;
    private Map<String, List<String>> responseHeaders = null;

    public AutoWebRequestEventGenerator setBaseRequestData(BaseRequestData baseData) {
        this.baseData = baseData;
        return this;
    }

    public AutoWebRequestEventGenerator setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public AutoWebRequestEventGenerator setNetworkProtocolName(String networkProtocolName) {
        this.networkProtocolName = networkProtocolName;
        return this;
    }

    public AutoWebRequestEventGenerator setHttpRequestMethod(String httpRequestMethod) {
        this.httpRequestMethod = httpRequestMethod;
        return this;
    }

    public AutoWebRequestEventGenerator setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
        return this;
    }

    public AutoWebRequestEventGenerator setException(Throwable exception) {
        this.exception = exception;
        return this;
    }

    public AutoWebRequestEventGenerator setHttpResponseHeaders(Map<String, List<String>> headers) {
        this.responseHeaders = headers;
        return this;
    }

    public AutoWebRequestEventGenerator setHttpRequestHeaders(Map<String, List<String>> headers) {
        this.requestHeaders = headers;
        return this;
    }

    public JSONObject generateRumRequestEvent() {
        if (this.baseData == null || this.networkProtocolName == null || this.networkProtocolName.isEmpty()) {
            return null;
        }
        try {
            List<String> headerValues;
            String headerName;
            JSONObject jsonObject = this.baseData.generateEventWithBaseData(this.statusCode);
            if (jsonObject == null) {
                return null;
            }
            jsonObject.put("http.request.method", (Object)this.httpRequestMethod);
            if (this.networkProtocolName != null && this.networkProtocolName.startsWith("http")) {
                jsonObject.put("network.protocol.name", (Object)"http");
            } else {
                jsonObject.put("network.protocol.name", (Object)this.networkProtocolName);
            }
            if (this.reasonPhrase != null && !this.reasonPhrase.isEmpty()) {
                jsonObject.put("http.response.reason_phrase", (Object)this.reasonPhrase);
            }
            if (this.exception != null) {
                jsonObject.put("has_exception", true);
                StringWriter stacktraceWriter = new StringWriter();
                this.exception.printStackTrace(new PrintWriter(stacktraceWriter));
                jsonObject.put("exception.stack_trace", (Object)stacktraceWriter.toString());
                jsonObject.put("exception.type", (Object)this.exception.getClass().getName());
                jsonObject.put("exception.message", (Object)this.exception.getMessage());
                jsonObject.put("has_error", true);
                jsonObject.put("has_failed_request", true);
            }
            if (this.responseHeaders != null) {
                for (Map.Entry<String, List<String>> entry : this.responseHeaders.entrySet()) {
                    headerName = entry.getKey();
                    if (headerName == null) continue;
                    headerValues = entry.getValue();
                    jsonObject.put("http.response.header." + headerName.toLowerCase(), (Object)String.join((CharSequence)", ", headerValues));
                }
            }
            if (this.requestHeaders != null) {
                for (Map.Entry<String, List<String>> entry : this.requestHeaders.entrySet()) {
                    headerName = entry.getKey();
                    if (headerName == null) continue;
                    headerValues = entry.getValue();
                    jsonObject.put("http.request.header." + headerName.toLowerCase(), (Object)String.join((CharSequence)", ", headerValues));
                }
            }
            return jsonObject;
        }
        catch (JSONException e) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOG_TAG, (String)e.getMessage());
            }
            return null;
        }
    }
}

