/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.mixed;

import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import org.json.JSONException;
import org.json.JSONObject;

public class BaseRequestData {
    private static final String LOG_TAG = Global.LOG_PREFIX + "BaseRequestData";
    private final String urlFull;

    public BaseRequestData(String urlFull) {
        this.urlFull = urlFull;
    }

    public JSONObject generateEventWithBaseData(int statusCode) {
        if (this.urlFull == null) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("has_request", true);
            jsonObject.put("url.full", (Object)this.urlFull);
            if (statusCode > 0) {
                jsonObject.put("http.response.status_code", statusCode);
            }
            if (statusCode >= 400 && statusCode <= 599) {
                jsonObject.put("has_error", true);
                jsonObject.put("has_failed_request", true);
            }
            return jsonObject;
        }
        catch (JSONException e) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOG_TAG, (String)e.getMessage());
            }
            return null;
        }
    }
}

