/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.callback;

import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.callback.CallbackCore;
import com.dynatrace.android.callback.CbConstants;
import com.dynatrace.android.callback.CbWebReqTracker;
import com.dynatrace.android.callback.OkHeaderInterceptor;
import com.dynatrace.android.callback.OkInterceptor;
import com.dynatrace.android.callback.OkRequestStateParms;
import com.dynatrace.android.callback.WebReqStateParms;
import java.io.IOException;
import java.util.List;
import java.util.WeakHashMap;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OkCallback {
    private static final String LOGTAG = Global.LOG_PREFIX + "OkCallback";
    public static boolean useRequestHeaders = false;
    public static boolean useResponseHeaders = false;

    public static void newInstance_start(OkHttpClient.Builder builder) {
        try {
            List interceptors = builder.interceptors();
            interceptors.remove(OkInterceptor.theInterceptor);
            interceptors.add(0, OkInterceptor.theInterceptor);
            List networkInterceptors = builder.networkInterceptors();
            networkInterceptors.remove(OkHeaderInterceptor.theInterceptor);
            builder.addNetworkInterceptor((Interceptor)OkHeaderInterceptor.theInterceptor);
        }
        catch (Exception e) {
            Utility.zlogE((String)LOGTAG, (String)e.getMessage(), (Throwable)e);
        }
    }

    public static Response execute(Call call) throws Exception {
        if (!Global.isAlive.get()) {
            return call.execute();
        }
        Response resp = null;
        if (call == null) {
            return resp;
        }
        OkRequestStateParms parm = new OkRequestStateParms(call.request(), CbConstants.WrMethod.execute, CbConstants.WrStates.PRE_EXEC, 0, useResponseHeaders, useRequestHeaders);
        try {
            OkCallback.updateRequest(parm);
            resp = call.execute();
            parm.parseHeaders();
            parm.calcHttpMessageBytes(resp);
            parm.evaluateServerTiming(resp.headers("Server-Timing"));
            OkCallback.updateRequest(parm, resp.code(), resp.message(), CbConstants.WrStates.POST_EXEC_OK);
        }
        catch (Exception e) {
            parm.exception = e;
            OkCallback.updateRequest(parm, 0, e.toString(), CbConstants.WrStates.POST_EXEC_ERR);
            throw e;
        }
        return resp;
    }

    public static void enqueue(Call call, Callback cb) {
        if (!Global.isAlive.get()) {
            call.enqueue(cb);
            return;
        }
        if (call == null) {
            return;
        }
        OkRequestStateParms parm = new OkRequestStateParms(call.request(), CbConstants.WrMethod.enqueue, CbConstants.WrStates.PRE_EXEC, 0, useResponseHeaders, useRequestHeaders);
        OkCallback.updateRequest(parm);
        try {
            call.enqueue(cb);
        }
        catch (RuntimeException e) {
            parm.exception = e;
            OkCallback.updateRequest(parm, 0, e.toString(), CbConstants.WrStates.POST_EXEC_ERR);
            throw e;
        }
    }

    public static void onResponse_enter(Call call, Response resp) {
        if (!Global.isAlive.get()) {
            return;
        }
        if (call == null) {
            return;
        }
        CbWebReqTracker webReqState = OkInterceptor.reqTracker.get(call.request());
        if (webReqState != null) {
            ((OkRequestStateParms)webReqState.stateParm).calcHttpMessageBytes(resp);
            ((OkRequestStateParms)webReqState.stateParm).parseHeaders();
            webReqState.stateParm.evaluateServerTiming(resp.headers("Server-Timing"));
            OkCallback.updateRequest(webReqState.stateParm, resp.code(), resp.message(), CbConstants.WrStates.POST_EXEC_OK);
        }
    }

    public static void onResponse_exit() {
    }

    public static void onFailure_enter(Call call, IOException t) {
        if (!Global.isAlive.get()) {
            return;
        }
        if (call == null) {
            return;
        }
        CbWebReqTracker webReqState = OkInterceptor.reqTracker.get(call.request());
        if (webReqState != null) {
            webReqState.stateParm.exception = t;
            OkCallback.updateRequest(webReqState.stateParm, 0, t.toString(), CbConstants.WrStates.POST_EXEC_ERR);
        }
    }

    public static void onFailure_exit() {
    }

    private static void updateRequest(WebReqStateParms parm, int respCode, String respMsg, CbConstants.WrStates state) {
        if (parm != null) {
            parm.respCode = respCode;
            parm.reason = respMsg;
            parm.state = state;
            OkCallback.updateRequest((OkRequestStateParms)parm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateRequest(OkRequestStateParms parm) {
        if (parm.request != null && CallbackCore.configuration.webRequestTiming) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)String.format("%s of %s of %s to %s (%d)", parm.state, parm.trackingMethod, parm.request.getClass().getName(), parm.getRequestDesc(), parm.request.hashCode()));
            }
        } else {
            return;
        }
        CbWebReqTracker webReqState = OkInterceptor.reqTracker.get(parm.request);
        if (webReqState == null && CbConstants.WrStates.PRE_EXEC == parm.state) {
            webReqState = OkInterceptor.theInterceptor.addRequest(parm.request, parm);
        }
        if (webReqState == null) {
            return;
        }
        webReqState.procNewState((WebReqStateParms)parm);
        if (webReqState.canFinalize) {
            WeakHashMap<Request, CbWebReqTracker> weakHashMap = OkInterceptor.reqTracker;
            synchronized (weakHashMap) {
                OkInterceptor.reqTracker.remove(parm.request);
            }
            webReqState.sendEvents((WebReqStateParms)parm);
        }
    }
}

