/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.mixed;

import android.location.Location;
import com.dynatrace.agent.metrics.DynamicBasicMetrics;

class DynamicBasicMetricsImpl
implements DynamicBasicMetrics {
    private final int deviceScreenWidth;
    private final int deviceScreenHeight;
    private final int deviceScreenOrientation;
    private final int deviceBatteryLevel;
    private final Location geoLocation;

    private DynamicBasicMetricsImpl(Builder builder) {
        this.deviceScreenWidth = builder.deviceScreenWidth;
        this.deviceScreenHeight = builder.deviceScreenHeight;
        this.deviceScreenOrientation = builder.deviceScreenOrientation;
        this.deviceBatteryLevel = builder.deviceBatteryLevel;
        this.geoLocation = builder.geoLocation;
    }

    public int getDeviceScreenWidth() {
        return this.deviceScreenWidth;
    }

    public int getDeviceScreenHeight() {
        return this.deviceScreenHeight;
    }

    public int getDeviceOrientation() {
        return this.deviceScreenOrientation;
    }

    public int getDeviceBatteryLevel() {
        return this.deviceBatteryLevel;
    }

    public Location getGeoLocation() {
        return this.geoLocation;
    }

    public static class Builder {
        private int deviceScreenWidth;
        private int deviceScreenHeight;
        private int deviceScreenOrientation;
        private int deviceBatteryLevel;
        private Location geoLocation;

        public Builder withDeviceScreenWidth(int deviceScreenWidth) {
            this.deviceScreenWidth = deviceScreenWidth;
            return this;
        }

        public Builder withDeviceScreenHeight(int deviceScreenHeight) {
            this.deviceScreenHeight = deviceScreenHeight;
            return this;
        }

        public Builder withDeviceScreenOrientation(int deviceScreenOrientation) {
            this.deviceScreenOrientation = deviceScreenOrientation;
            return this;
        }

        public Builder withDeviceBatteryLevel(int deviceBatteryLevel) {
            this.deviceBatteryLevel = deviceBatteryLevel;
            return this;
        }

        public Builder withGeoLocation(Location geoLocation) {
            this.geoLocation = geoLocation;
            return this;
        }

        public DynamicBasicMetrics build() {
            return new DynamicBasicMetricsImpl(this);
        }
    }
}

