/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.lifecycle.event;

import com.dynatrace.android.agent.measurement.MeasurementPoint;

public class LifecycleEvent<T extends Enum<T>> {
    private final T eventType;
    private final long timestamp;
    private final int sequenceNumber;

    public LifecycleEvent(T eventType, MeasurementPoint pointOfCreation) {
        this.eventType = eventType;
        this.timestamp = pointOfCreation.getTimestamp();
        this.sequenceNumber = pointOfCreation.getSequenceNumber();
    }

    public T getEventType() {
        return this.eventType;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LifecycleEvent that = (LifecycleEvent)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.sequenceNumber != that.sequenceNumber) {
            return false;
        }
        return this.eventType == that.eventType;
    }

    public int hashCode() {
        int result = ((Enum)this.eventType).hashCode();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.sequenceNumber;
        return result;
    }

    public String toString() {
        return "LifecycleEvent{eventType=" + this.eventType + ", timestamp=" + this.timestamp + ", sequenceNumber=" + this.sequenceNumber + '}';
    }
}

