/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.agent.RumEventDispatcher;
import com.dynatrace.agent.events.EventModifier;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;

public class GuardedEventDispatcher {
    private static final String LOGTAG = Global.LOG_PREFIX + "GuardedEventDispatcher";
    private RumEventDispatcher eventDispatcher = null;

    public void initEventDispatcher(RumEventDispatcher rumEventDispatcher) {
        this.eventDispatcher = rumEventDispatcher;
    }

    public void resetEventDispatcher() {
        this.eventDispatcher = null;
    }

    public boolean addEventModifier(EventModifier eventModifier) {
        if (this.eventDispatcher != null) {
            return this.eventDispatcher.addEventModifier(eventModifier);
        }
        return false;
    }

    public boolean removeEventModifier(EventModifier eventModifier) {
        if (this.eventDispatcher != null) {
            return this.eventDispatcher.removeEventModifier(eventModifier);
        }
        return false;
    }

    public void executeWithVerification(Session session, GuardedOperation guardedOperation) {
        if (this.eventDispatcher == null) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)"RumEventDispatcher is not available");
            }
            return;
        }
        if (!session.isGrailEventsShouldBeCaptured()) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)"Grail is disabled for current session");
            }
            return;
        }
        if (!session.isActive()) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)"Cannot use event dispatcher when session is inactive");
            }
            return;
        }
        guardedOperation.execute(this.eventDispatcher);
    }

    public static interface GuardedOperation {
        public void execute(RumEventDispatcher var1);
    }
}

