/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.mixed;

import com.dynatrace.android.agent.mixed.BaseRequestData;
import com.dynatrace.android.agent.util.Utility;
import org.json.JSONException;
import org.json.JSONObject;

public class ManualWebRequestEventGenerator {
    private BaseRequestData baseData;
    private String networkProtocolName;
    private int statusCode = -1;
    private String reasonPhrase;

    public ManualWebRequestEventGenerator setBaseRequestData(BaseRequestData baseData) {
        this.baseData = baseData;
        return this;
    }

    public ManualWebRequestEventGenerator setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public ManualWebRequestEventGenerator setNetworkProtocolName(String networkProtocolName) {
        this.networkProtocolName = networkProtocolName;
        return this;
    }

    public ManualWebRequestEventGenerator setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
        return this;
    }

    public JSONObject generateRumRequestEvent() {
        if (this.baseData == null || this.networkProtocolName == null || this.networkProtocolName.isEmpty()) {
            Utility.devLog((String)"dtxEventGeneration", (String)("manual generateRumRequestEvent failed, baseData: " + this.baseData + ", networkProtocolName: " + this.networkProtocolName));
            return null;
        }
        try {
            JSONObject jsonObject = this.baseData.generateEventWithBaseData(this.statusCode, this.networkProtocolName);
            if (jsonObject == null) {
                return null;
            }
            if (this.networkProtocolName.startsWith("http")) {
                jsonObject.put("network.protocol.name", (Object)"http");
            } else if (this.networkProtocolName.startsWith("ws")) {
                jsonObject.put("network.protocol.name", (Object)"ws");
            } else {
                jsonObject.put("network.protocol.name", (Object)this.networkProtocolName);
            }
            if (this.statusCode < 0) {
                jsonObject.put("has_failed_request", true);
                jsonObject.put("has_error", true);
                if (this.reasonPhrase != null && !this.reasonPhrase.isEmpty()) {
                    jsonObject.put("has_exception", true);
                    jsonObject.put("exception.message", (Object)this.reasonPhrase);
                }
            } else if (this.reasonPhrase != null && !this.reasonPhrase.isEmpty() && !this.networkProtocolName.startsWith("ws")) {
                jsonObject.put("http.response.reason_phrase", (Object)this.reasonPhrase);
            }
            return jsonObject;
        }
        catch (JSONException e) {
            Utility.devLog((String)"dtxEventGeneration", (String)"manual generateRumRequestEvent failed with exception", (Throwable)e);
            return null;
        }
    }
}

