/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.callback;

import android.app.Application;
import android.content.Context;
import android.view.MenuItem;
import android.view.View;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.conf.ConfigurationFactory;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.callback.CallbackCore;
import com.dynatrace.android.callback.CbConstants;
import com.dynatrace.android.callback.ConnStateParms;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;

public final class Callback {
    private static final String LOGTAG = Global.LOG_PREFIX + "Callback";
    public static boolean useRequestHeaders = false;
    public static boolean useResponseHeaders = false;

    private Callback() {
    }

    public static void onCreate(Application application) {
        CallbackCore.init((Context)application, ConfigurationFactory.getConfiguration());
    }

    public static void newInstance(HttpURLConnection conn) {
        if (!Global.isAlive.get()) {
            return;
        }
        CallbackCore.addConnection(conn, false);
    }

    public static void openConnection(URLConnection conn) {
        if (!Global.isAlive.get()) {
            return;
        }
        if (conn instanceof HttpURLConnection) {
            CallbackCore.addConnection((HttpURLConnection)conn, true);
        }
    }

    public static InputStream getInputStream(URLConnection conn) throws Exception {
        if (conn instanceof HttpURLConnection) {
            return Callback.getInputStream((HttpURLConnection)conn);
        }
        return conn.getInputStream();
    }

    public static InputStream getInputStream(HttpURLConnection conn) throws Exception {
        if (!Global.isAlive.get()) {
            return conn.getInputStream();
        }
        InputStream is = null;
        ConnStateParms parm = new ConnStateParms(conn, CbConstants.WrMethod.getInputStream, CbConstants.WrStates.PRE_EXEC, 0, useResponseHeaders, useRequestHeaders);
        try {
            Callback.updateConnection(parm);
            is = conn.getInputStream();
            Callback.getRespCodeFromConn(conn, parm);
            parm.state = CbConstants.WrStates.POST_EXEC_OK;
            Callback.updateConnection(parm);
        }
        catch (Exception e) {
            Utility.devLog((String)"dtxEventGeneration", (String)"httpUrlConnection getInputStream is failed", (Throwable)e);
            parm.reason = e.toString();
            parm.exception = e;
            throw e;
        }
        finally {
            Callback.getRespCodeFromConn(conn, parm);
            parm.state = CbConstants.WrStates.POST_EXEC_ERR;
            Callback.updateConnection(parm);
        }
        return is;
    }

    public static OutputStream getOutputStream(URLConnection conn) throws Exception {
        if (conn instanceof HttpURLConnection) {
            return Callback.getOutputStream((HttpURLConnection)conn);
        }
        return conn.getOutputStream();
    }

    public static OutputStream getOutputStream(HttpURLConnection conn) throws Exception {
        if (!Global.isAlive.get()) {
            return conn.getOutputStream();
        }
        OutputStream os = null;
        ConnStateParms parm = new ConnStateParms(conn, CbConstants.WrMethod.getOutputStream, CbConstants.WrStates.PRE_EXEC, 0, useResponseHeaders, useRequestHeaders);
        try {
            Callback.updateConnection(parm);
            os = conn.getOutputStream();
            parm.state = CbConstants.WrStates.POST_EXEC_OK;
            Callback.updateConnection(parm);
        }
        catch (Exception e) {
            Utility.devLog((String)"dtxEventGeneration", (String)"httpUrlConnection getOutputStream is failed", (Throwable)e);
            parm.reason = e.toString();
            parm.exception = e;
            throw e;
        }
        finally {
            parm.state = CbConstants.WrStates.POST_EXEC_ERR;
            Callback.updateConnection(parm);
        }
        return os;
    }

    public static int getResponseCode(HttpURLConnection conn) throws Exception {
        if (!Global.isAlive.get()) {
            return conn.getResponseCode();
        }
        int rc = -1;
        ConnStateParms parm = new ConnStateParms(conn, CbConstants.WrMethod.getResponseCode, CbConstants.WrStates.PRE_EXEC, 0, useResponseHeaders, useRequestHeaders);
        try {
            Callback.updateConnection(parm);
            rc = conn.getResponseCode();
            Callback.getRespCodeFromConn(conn, parm);
            parm.state = CbConstants.WrStates.POST_EXEC_OK;
            Callback.updateConnection(parm);
        }
        catch (Exception e) {
            Utility.devLog((String)"dtxEventGeneration", (String)"httpUrlConnection getResponseCode is failed", (Throwable)e);
            parm.reason = e.toString();
            parm.exception = e;
            throw e;
        }
        finally {
            parm.respCode = rc;
            parm.state = CbConstants.WrStates.POST_EXEC_ERR;
            Callback.updateConnection(parm);
        }
        return rc;
    }

    private static int getRespCodeFromConn(HttpURLConnection conn, ConnStateParms wrsp) {
        int respCode;
        block2: {
            respCode = -1;
            try {
                respCode = conn.getResponseCode();
                wrsp.reason = conn.getResponseMessage();
            }
            catch (Exception e) {
                if (wrsp.reason != null) break block2;
                wrsp.reason = e.getMessage();
            }
        }
        wrsp.respCode = respCode;
        return respCode;
    }

    private static void updateConnection(ConnStateParms parm) {
        block2: {
            try {
                CallbackCore.updateConnection(parm);
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block2;
                Utility.zlogD((String)LOGTAG, (String)parm.toString(), (Throwable)e);
            }
        }
    }

    public static void onClick_enter(View view) {
        if (!Global.isAlive.get()) {
            return;
        }
        CallbackCore.onUserActionEnter(CallbackCore.ListenerActionType.Clicked, view);
    }

    public static void onClick_exit() {
        CallbackCore.onUserActionExit(CallbackCore.ListenerActionType.Clicked);
    }

    public static void onItemClick_enter(View view, int pos) {
        if (!Global.isAlive.get()) {
            return;
        }
        CallbackCore.onUserActionEnter(CallbackCore.ListenerActionType.ItemClicked, view);
    }

    public static void onItemClick_exit() {
        CallbackCore.onUserActionExit(CallbackCore.ListenerActionType.ItemClicked);
    }

    public static void onPageSelected_enter(int pos) {
        if (!Global.isAlive.get()) {
            return;
        }
        CallbackCore.onUserActionEnter(CallbackCore.ListenerActionType.PageSelected);
    }

    public static void onPageSelected_exit() {
        CallbackCore.onUserActionExit(CallbackCore.ListenerActionType.PageSelected);
    }

    public static void onItemSelected_enter(View view, int pos) {
        if (!Global.isAlive.get()) {
            return;
        }
        CallbackCore.onUserActionEnter(CallbackCore.ListenerActionType.ItemSelected, view);
    }

    public static void onItemSelected_exit() {
        CallbackCore.onUserActionExit(CallbackCore.ListenerActionType.ItemSelected);
    }

    public static void onMenuItemClick_enter(MenuItem menuItem) {
        if (!Global.isAlive.get()) {
            return;
        }
        CallbackCore.onUserActionEnter(CallbackCore.ListenerActionType.MenuItemClick, menuItem);
    }

    public static void onMenuItemClick_exit() {
        CallbackCore.onUserActionExit(CallbackCore.ListenerActionType.MenuItemClick);
    }

    public static void onOptionsItemSelected_enter(MenuItem menuItem) {
        if (!Global.isAlive.get()) {
            return;
        }
        CallbackCore.onUserActionEnter(CallbackCore.ListenerActionType.OptionsItemSelected, menuItem);
    }

    public static void onOptionsItemSelected_exit() {
        CallbackCore.onUserActionExit(CallbackCore.ListenerActionType.OptionsItemSelected);
    }

    public static void onRefresh_enter() {
        if (!Global.isAlive.get()) {
            return;
        }
        CallbackCore.onUserActionEnter(CallbackCore.ListenerActionType.SwipeToRefresh, CallbackCore.ListenerActionType.SwipeToRefresh.toString());
    }

    public static void onRefresh_exit() {
        CallbackCore.onUserActionExit(CallbackCore.ListenerActionType.SwipeToRefresh);
    }
}

