/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.mixed;

import com.dynatrace.android.agent.mixed.BaseWebRequestEventGenerator;
import com.dynatrace.android.agent.mixed.WebRequestTraceContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class AutoWebRequestEventGenerator
extends BaseWebRequestEventGenerator {
    private String httpRequestMethod;
    private Throwable exception;
    private Map<String, List<String>> requestHeaders = null;
    private Map<String, List<String>> responseHeaders = null;
    private WebRequestTraceContext traceContext = null;

    public AutoWebRequestEventGenerator() {
        super("auto");
    }

    public void setHttpRequestMethod(String httpRequestMethod) {
        this.httpRequestMethod = httpRequestMethod;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public void setHttpResponseHeaders(Map<String, List<String>> headers) {
        this.responseHeaders = headers;
    }

    public void setHttpRequestHeaders(Map<String, List<String>> headers) {
        this.requestHeaders = headers;
    }

    public void setWebRequestTraceContext(WebRequestTraceContext traceContext) {
        this.traceContext = traceContext;
    }

    @Override
    public JSONObject generateRumRequestEvent() {
        return super.generateRumRequestEvent();
    }

    @Override
    protected JSONObject populateJson(JSONObject jsonObject) throws JSONException {
        List<String> headerValues;
        String headerName;
        jsonObject.put("http.request.method", (Object)this.httpRequestMethod);
        if (this.networkProtocolName.startsWith("http")) {
            jsonObject.put("network.protocol.name", (Object)"http");
        } else {
            jsonObject.put("network.protocol.name", (Object)this.networkProtocolName);
        }
        if (this.statusCode > 0) {
            jsonObject.put("http.response.status_code", this.statusCode);
        }
        if (this.statusCode >= 400 && this.statusCode <= 599) {
            jsonObject.put("has_error", true);
            jsonObject.put("has_failed_request", true);
        }
        if (this.reasonPhrase != null && !this.reasonPhrase.isEmpty()) {
            jsonObject.put("http.response.reason_phrase", (Object)this.reasonPhrase);
        }
        if (this.exception != null) {
            jsonObject.put("has_exception", true);
            StringWriter stacktraceWriter = new StringWriter();
            this.exception.printStackTrace(new PrintWriter(stacktraceWriter));
            jsonObject.put("exception.stack_trace", (Object)stacktraceWriter.toString());
            jsonObject.put("exception.type", (Object)this.exception.getClass().getName());
            jsonObject.put("exception.message", (Object)this.exception.getMessage());
            jsonObject.put("has_error", true);
            jsonObject.put("has_failed_request", true);
        }
        if (this.responseHeaders != null) {
            for (Map.Entry<String, List<String>> entry : this.responseHeaders.entrySet()) {
                headerName = entry.getKey();
                if (headerName == null) continue;
                headerValues = entry.getValue();
                jsonObject.put("http.response.header." + headerName.toLowerCase(), (Object)String.join((CharSequence)", ", headerValues));
            }
        }
        if (this.requestHeaders != null) {
            for (Map.Entry<String, List<String>> entry : this.requestHeaders.entrySet()) {
                headerName = entry.getKey();
                if (headerName == null) continue;
                headerValues = entry.getValue();
                jsonObject.put("http.request.header." + headerName.toLowerCase(), (Object)String.join((CharSequence)", ", headerValues));
            }
        }
        if (this.traceContext != null) {
            jsonObject.put("trace.id", (Object)this.traceContext.getTraceId());
            jsonObject.put("span.id", (Object)this.traceContext.getSpanId());
        }
        return jsonObject;
    }
}

