/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.useraction;

import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.DTXAutoAction;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.measurement.MeasurementPoint;
import com.dynatrace.android.agent.util.Utility;

public final class UserActionUtil {
    private static final String LOGTAG = Global.LOG_PREFIX + "UserActionSupplier";

    private UserActionUtil() {
    }

    public static DTXAutoAction determineAutoUserAction(String actionName, MeasurementPoint startPoint) {
        DTXAutoAction gaua = DTXAutoAction.getAutoAction();
        if (gaua != null && gaua.getNumberOfParentActions() >= 9) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)("Maximum depth of actions reached (10). Do not attach lifecycle action to user action '" + gaua.getName() + "'"));
            }
            gaua = null;
        }
        if (gaua == null) {
            Session session = Session.determineActiveSession(false, startPoint.getTimestamp());
            int serverId = AdkSettings.getInstance().serverId;
            gaua = DTXAutoAction.createAutoAction(actionName, session, serverId);
            gaua.setStartTime(startPoint.getTimestamp() - gaua.getSession().getSessionStartTime());
            gaua.setLcSeqNum(startPoint.getSequenceNumber());
        }
        gaua.cancelTimer();
        gaua.getSession().updateLastInteractionTime(TimeLineProvider.getSystemTime());
        return gaua;
    }

    public static DTXAutoAction createNewAutoUserAction(String actionName, MeasurementPoint startPoint) {
        Session session = Session.determineActiveSession(false, startPoint.getTimestamp());
        int serverId = AdkSettings.getInstance().serverId;
        DTXAutoAction gaua = DTXAutoAction.createAutoAction(actionName, session, serverId);
        gaua.setStartTime(startPoint.getTimestamp() - gaua.getSession().getSessionStartTime());
        gaua.setLcSeqNum(startPoint.getSequenceNumber());
        return gaua;
    }
}

