/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.db;

import android.content.Context;
import android.database.Cursor;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.BasicSegment;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.comm.MonitoringDataPacket;
import com.dynatrace.android.agent.conf.ServerConfiguration;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.db.DatabaseWriteQueue;
import com.dynatrace.android.agent.db.EventsDbHelper;
import com.dynatrace.android.agent.db.MonitoringDataEntity;
import com.dynatrace.android.agent.db.ParmDbHelper;
import com.dynatrace.android.agent.util.Utility;
import java.util.ArrayList;
import java.util.LinkedList;

public class DataAccessObject {
    private static final String TAG = Global.LOG_PREFIX + "DataAccessObject";
    private final ParmDbHelper parmHelper;
    private final EventsDbHelper eventsHelper;

    public DataAccessObject(Context context) {
        this(new EventsDbHelper(context), new ParmDbHelper(context));
    }

    public DataAccessObject(EventsDbHelper eventsHelper, ParmDbHelper parmHelper) {
        this.eventsHelper = eventsHelper;
        this.parmHelper = parmHelper;
    }

    public synchronized void insertBatchEvents(LinkedList<DatabaseWriteQueue.DatabaseRecord> writeQueue, ServerConfiguration configuration) {
        block5: {
            this.eventsHelper.insertBatch(writeQueue);
            if (configuration.isCachingCrashes()) {
                boolean containsCrashes = false;
                for (int ii = 0; ii < writeQueue.size(); ++ii) {
                    if (writeQueue.get((int)ii).eventId != EventsDbHelper.CRASH_EVENT_ID) continue;
                    containsCrashes = true;
                    break;
                }
                if (containsCrashes) {
                    try {
                        this.eventsHelper.deleteEventsByEventId(EventsDbHelper.CRASH_EVENT_ID, configuration.getMaxCachedCrashesCount());
                    }
                    catch (Exception e) {
                        if (!Global.DEBUG) break block5;
                        Utility.zlogD((String)TAG, (String)"Database error.", (Throwable)e);
                    }
                }
            }
        }
    }

    public synchronized void deleteEventsFromVisit(long visitorId, long sessionId) {
        block2: {
            try {
                this.eventsHelper.deleteEventsFromVisit(visitorId, sessionId);
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block2;
                Utility.zlogD((String)TAG, (String)"Database error.", (Throwable)e);
            }
        }
    }

    public synchronized void deleteEventsWithMismatchAppId(String appId) {
        block2: {
            try {
                this.eventsHelper.deleteEventsWithMismatchAppId(appId);
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block2;
                Utility.zlogD((String)TAG, (String)"Database error.", (Throwable)e);
            }
        }
    }

    public synchronized void deleteSentEvents(MonitoringDataEntity entity) {
        block2: {
            try {
                this.eventsHelper.deleteSentEvents(entity.visitorId, entity.sessionId, entity.sequenceNumber, entity.serverId, entity.lastRowId);
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block2;
                Utility.zlogD((String)TAG, (String)"Database error.", (Throwable)e);
            }
        }
    }

    public synchronized void deleteOldEvents(long now, boolean keepCrashes) {
        block2: {
            long dateExp = now - 540000L;
            try {
                this.eventsHelper.deleteEventsByDate(dateExp, keepCrashes);
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block2;
                Utility.zlogE((String)TAG, (String)"Database error.", (Throwable)e);
            }
        }
    }

    public synchronized void deleteOldCrashes(int limit) {
        block2: {
            try {
                this.eventsHelper.deleteEventsByEventId(EventsDbHelper.CRASH_EVENT_ID, limit);
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block2;
                Utility.zlogE((String)TAG, (String)"Database error.", (Throwable)e);
            }
        }
    }

    public boolean deleteAllEvents() {
        boolean deleted;
        block2: {
            deleted = false;
            try {
                deleted = this.eventsHelper.deleteAllEvents();
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block2;
                Utility.zlogE((String)TAG, (String)"Database error.", (Throwable)e);
            }
        }
        return deleted;
    }

    public MonitoringDataEntity fetchEvents(long maxSendLength, BasicSegment.UpdatableDataGenerator generator, long now) {
        long dateExp = now - 540000L;
        Cursor cursor = this.eventsHelper.fetchEvents();
        if (cursor == null) {
            if (Global.DEBUG) {
                Utility.zlogD((String)TAG, (String)"null cursor for fetchEvents");
            }
            return null;
        }
        if (!cursor.moveToFirst()) {
            cursor.close();
            return null;
        }
        int idColumnIndex = cursor.getColumnIndexOrThrow("id");
        int iVisitorId = cursor.getColumnIndexOrThrow("visitor_id");
        int iSessionId = cursor.getColumnIndexOrThrow("session_id");
        int iSequenceNr = cursor.getColumnIndexOrThrow("sequence_nr");
        int iObcv = cursor.getColumnIndexOrThrow("basic_segment");
        int iOa = cursor.getColumnIndexOrThrow("event_segment");
        int iEventId = cursor.getColumnIndexOrThrow("event_id");
        int iSessionStart = cursor.getColumnIndexOrThrow("session_start");
        int iEventStart = cursor.getColumnIndexOrThrow("event_start");
        int iMultiplicity = cursor.getColumnIndexOrThrow("multiplicity");
        int iServerId = cursor.getColumnIndexOrThrow("server_id");
        int iSrParam = cursor.getColumnIndexOrThrow("sr_param");
        long visitorId = 0L;
        long sessionId = 0L;
        int sequenceNumber = 0;
        int serverId = 0;
        long lastRowId = -1L;
        String basicData = null;
        ArrayList<String> events = new ArrayList<String>();
        int bodySize = 0;
        int delimiterSize = "&".length();
        boolean finished = true;
        do {
            long curVisitorId = cursor.getLong(iVisitorId);
            long curSessionId = cursor.getLong(iSessionId);
            int curSequenceNumber = cursor.getInt(iSequenceNr);
            String eventData = cursor.getString(iOa);
            int eventId = cursor.getInt(iEventId);
            int curServerId = cursor.getInt(iServerId);
            if (basicData == null) {
                visitorId = curVisitorId;
                sessionId = curSessionId;
                sequenceNumber = curSequenceNumber;
                serverId = curServerId;
                basicData = cursor.getString(iObcv) + generator.generateUpdatableData(cursor.getLong(iSessionStart), cursor.getInt(iMultiplicity), cursor.isNull(iSrParam) ? null : cursor.getString(iSrParam));
                events.add(eventData);
                bodySize = basicData.length() + delimiterSize + eventData.length();
                lastRowId = cursor.getLong(idColumnIndex);
                continue;
            }
            int bodySizeNew = bodySize + delimiterSize + eventData.length();
            if (visitorId == curVisitorId && sessionId == curSessionId && sequenceNumber == curSequenceNumber && serverId == curServerId && (long)bodySizeNew <= maxSendLength) {
                events.add(eventData);
                bodySize = bodySizeNew;
                lastRowId = cursor.getLong(idColumnIndex);
                continue;
            }
            finished = false;
            break;
        } while (cursor.moveToNext());
        cursor.close();
        return new MonitoringDataEntity(visitorId, sessionId, sequenceNumber, serverId, lastRowId, new MonitoringDataPacket(basicData, events), finished);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateSessionId() {
        try {
            ParmDbHelper parmDbHelper = this.parmHelper;
            synchronized (parmDbHelper) {
                Long sessionId = this.parmHelper.fetchSessionId();
                if (sessionId == null) {
                    return -1L;
                }
                long newSessionId = sessionId + 1L;
                this.parmHelper.updateSessionId(newSessionId);
                return newSessionId;
            }
        }
        catch (Exception e) {
            if (Global.DEBUG) {
                Utility.zlogE((String)TAG, (String)"Database error.", (Throwable)e);
            }
            return -1L;
        }
    }

    public long getVisitorId() {
        long newVisitorId;
        block8: {
            block7: {
                try {
                    Long visitorId = this.parmHelper.fetchVisitorId();
                    if (visitorId == null) {
                        this.parmHelper.createMainRow();
                    } else if (visitorId != 0L) {
                        return visitorId;
                    }
                }
                catch (Exception e) {
                    if (!Global.DEBUG) break block7;
                    Utility.zlogE((String)TAG, (String)"Database error.", (Throwable)e);
                }
            }
            newVisitorId = this.generateVisitorId();
            try {
                AdkSettings.getInstance().setNewVisitorSent(false);
                this.parmHelper.updateVisitorId(newVisitorId);
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block8;
                Utility.zlogE((String)TAG, (String)"Database error.", (Throwable)e);
            }
        }
        return newVisitorId;
    }

    public long generateVisitorId() {
        long lV = 0L;
        for (int i = 0; i < 3; ++i) {
            Double dW = Math.random();
            dW = dW * 65536.0;
            long lW = dW.longValue();
            lV += lW << 8 * i;
        }
        return lV;
    }

    public void deleteVisitorInformation() {
        block2: {
            try {
                this.parmHelper.resetMainRow();
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block2;
                Utility.zlogE((String)TAG, (String)"Database error.", (Throwable)e);
            }
        }
    }

    public synchronized boolean updateSessionProperties(Session session) {
        try {
            return this.eventsHelper.updateSrAndMultiplicity(session);
        }
        catch (Exception e) {
            if (Global.DEBUG) {
                Utility.zlogE((String)TAG, (String)"can't update multiplicity", (Throwable)e);
            }
            return false;
        }
    }
}

