/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.mixed;

import com.dynatrace.agent.metrics.AppVersion;
import com.dynatrace.agent.metrics.StaticBasicMetrics;

class StaticBasicMetricsImpl
implements StaticBasicMetrics {
    private final String deviceManufacturer;
    private final String deviceModelIdentifier;
    private final boolean deviceIsRooted;
    private final String osName;
    private final String osVersion;
    private final AppVersion appVersion;
    private final String bundle;

    private StaticBasicMetricsImpl(Builder builder) {
        this.deviceManufacturer = builder.deviceManufacturer;
        this.deviceModelIdentifier = builder.deviceModelIdentifier;
        this.deviceIsRooted = builder.deviceIsRooted;
        this.osName = builder.osName;
        this.osVersion = builder.osVersion;
        this.appVersion = builder.appVersion;
        this.bundle = builder.bundle;
    }

    public String getDeviceManufacturer() {
        return this.deviceManufacturer;
    }

    public String getDeviceModelIdentifier() {
        return this.deviceModelIdentifier;
    }

    public boolean getDeviceIsRooted() {
        return this.deviceIsRooted;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public AppVersion getAppVersion() {
        return this.appVersion;
    }

    public String getBundle() {
        return this.bundle;
    }

    public static class Builder {
        private String deviceManufacturer;
        private String deviceModelIdentifier;
        private boolean deviceIsRooted;
        private String osName;
        private String osVersion;
        private AppVersion appVersion;
        private String bundle;

        public Builder withDeviceManufacturer(String deviceManufacturer) {
            this.deviceManufacturer = deviceManufacturer;
            return this;
        }

        public Builder withDeviceModelIdentifier(String deviceModelIdentifier) {
            this.deviceModelIdentifier = deviceModelIdentifier;
            return this;
        }

        public Builder withDeviceIsRooted(boolean deviceIsRooted) {
            this.deviceIsRooted = deviceIsRooted;
            return this;
        }

        public Builder withOsName(String osName) {
            this.osName = osName;
            return this;
        }

        public Builder withOsVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public Builder withAppVersion(AppVersion appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public Builder withBundle(String bundle) {
            this.bundle = bundle;
            return this;
        }

        public StaticBasicMetrics build() {
            return new StaticBasicMetricsImpl(this);
        }
    }
}

