/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.crash;

import android.os.Process;
import com.dynatrace.android.agent.CrashReporter;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.crash.CrashListener;
import com.dynatrace.android.agent.util.Utility;
import java.util.ArrayList;
import java.util.List;

public class CrashCatcher {
    private static final String LOGTAG = Global.LOG_PREFIX + "CrashCatcher";
    public static volatile boolean registered = false;
    private static List<CrashListener> listeners = new ArrayList<CrashListener>();
    private static Thread.UncaughtExceptionHandler uncotExHandlers = null;
    private static Throwable theLastEx = null;

    public static void registerUncaughtExceptionListener(CrashListener listener) {
        if (listener != null) {
            listeners.add(listener);
        }
    }

    public static void unregisterUncaughtExceptionListener(CrashListener listener) {
        if (listener != null) {
            listeners.remove(listener);
        }
    }

    public static void notifyListeners(Thread thread, Throwable ex) {
        CrashReporter.hasCrashed = true;
        if (!Dynatrace.getCaptureStatus()) {
            if (Global.DEBUG) {
                Utility.zlogI((String)LOGTAG, (String)"Not reporting uncaught exception due to capturing state is off");
            }
            return;
        }
        for (CrashListener listener : listeners) {
            try {
                listener.notifyJavaCrash(thread, ex);
            }
            catch (Throwable listenerCrash) {
                if (!Global.DEBUG) continue;
                Utility.zlogE((String)LOGTAG, (String)("Failed to process an uncaught exception by " + listener.toString()), (Throwable)listenerCrash);
            }
        }
    }

    public static void notifyListeners(String platformType, String crashName, String reason, String stacktrace) {
        if (!Dynatrace.getCaptureStatus()) {
            if (Global.DEBUG) {
                Utility.zlogI((String)LOGTAG, (String)"Not reporting uncaught exception due to capturing state is off");
            }
            return;
        }
        for (CrashListener listener : listeners) {
            try {
                listener.notifyCustomCrash(platformType, crashName, reason, stacktrace);
            }
            catch (Throwable listenerCrash) {
                if (!Global.DEBUG) continue;
                Utility.zlogE((String)LOGTAG, (String)("Failed to process an uncaught exception by " + listener.toString()), (Throwable)listenerCrash);
            }
        }
    }

    public static void uninstallUncaughtExceptionHandler() {
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentHandler != null && currentHandler instanceof DTXAgentUncaughtExceptionHandler) {
            Thread.UncaughtExceptionHandler formerExHandler = uncotExHandlers;
            Thread.setDefaultUncaughtExceptionHandler(formerExHandler);
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)"Unregistered agent crash handler");
            }
        } else if (Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)"There is no agent crash handler to be unregistered.");
        }
        registered = false;
    }

    public static void installUncaughtExceptionHandler() {
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentHandler != null && currentHandler instanceof DTXAgentUncaughtExceptionHandler) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)"The agent crash handler is already registered.");
            }
            return;
        }
        uncotExHandlers = currentHandler;
        Thread.setDefaultUncaughtExceptionHandler(DTXAgentUncaughtExceptionHandler.getInstance());
        if (Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)"Registered agent crash handler");
        }
        registered = true;
    }

    private static class DTXAgentUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private static DTXAgentUncaughtExceptionHandler theInstance = new DTXAgentUncaughtExceptionHandler();

        private DTXAgentUncaughtExceptionHandler() {
        }

        static DTXAgentUncaughtExceptionHandler getInstance() {
            return theInstance;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable ex) {
            if (Global.DEBUG) {
                String msg = String.format("Uncaught exception occurred in %s[name=%s, id=%d, pid=%d]", thread.getClass().getName(), thread.getName(), thread.getId(), Process.myPid());
                Utility.zlogI((String)LOGTAG, (String)msg);
            }
            if (theLastEx != ex) {
                theLastEx = ex;
                CrashCatcher.notifyListeners(thread, ex);
            }
            if (uncotExHandlers != null) {
                Thread.UncaughtExceptionHandler handler = uncotExHandlers;
                if (Global.DEBUG) {
                    Utility.zlogI((String)LOGTAG, (String)("Passing exception to " + handler.getClass().getName()));
                }
                handler.uncaughtException(thread, ex);
            }
        }
    }
}

