/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.mixed;

import android.content.Context;
import com.dynatrace.agent.OneAgentStartup;
import com.dynatrace.agent.RumEventDispatcher;
import com.dynatrace.agent.SetupConfiguration;
import com.dynatrace.agent.communication.api.AgentState;
import com.dynatrace.agent.di.CoreComponent;
import com.dynatrace.agent.metrics.BasicMetricsProvider;
import com.dynatrace.agent.view.ViewContextStorage;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.communication.CommunicationManagerBridge;
import com.dynatrace.android.agent.communication.ServerConfigurationListener;
import com.dynatrace.android.agent.conf.ServerConfiguration;
import com.dynatrace.android.agent.lifecycle.OneAgentLifecycleManagerBridge;
import com.dynatrace.android.agent.mixed.AgentServiceLocator;
import com.dynatrace.android.agent.mixed.TimeProviderFactory;
import com.dynatrace.android.agent.useraction.OneAgentUserInteractionManagerBridge;
import com.dynatrace.android.agent.util.Utility;
import okhttp3.Call;

public class AgentServiceLocatorImpl
implements AgentServiceLocator {
    private final String version;
    private final String applicationId;
    private final String beaconUrl;
    private final Context context;
    private final BasicMetricsProvider basicMetricsProvider;
    private final Call.Factory httpFactory;

    public AgentServiceLocatorImpl(String version, String applicationId, String beaconUrl, Context context, BasicMetricsProvider basicMetricsProvider, Call.Factory httpFactory) {
        this.version = version;
        this.applicationId = applicationId;
        this.beaconUrl = beaconUrl;
        this.context = context;
        this.basicMetricsProvider = basicMetricsProvider;
        this.httpFactory = httpFactory;
    }

    @Override
    public void init() {
        Utility.devLog((String)"dtxStartStop", (String)("initialize OneAgent, applicationId: " + this.applicationId + " beaconUrl: " + this.beaconUrl + " version: " + this.version + " httpFactory: " + this.httpFactory));
        CoreComponent.Holder.initComponent(new SetupConfiguration(this.applicationId, this.beaconUrl, new TimeProviderFactory().createTimelineProvider(), this.version), new ServerConfigurationListener(){

            public void onServerConfigurationChanged(ServerConfiguration configurationV3) {
                Core.applyConfigurationFromOneAgent(configurationV3);
            }

            public void onAgentStateChanged(AgentState state) {
                Core.applyAgentStateFromOneAgent(state);
            }
        }, this.httpFactory, this.context, this.basicMetricsProvider);
    }

    @Override
    public CommunicationManagerBridge provideCommunicationManagerBridge() {
        return CoreComponent.Holder.getInstance().getCommunicationManagerBridge();
    }

    @Override
    public OneAgentLifecycleManagerBridge provideOneAgentLifecycleManagerBridge() {
        return CoreComponent.Holder.getInstance().getOneAgentLifecycleManagerBridge();
    }

    @Override
    public OneAgentUserInteractionManagerBridge provideOneAgentUserInteractionManagerBridge() {
        return CoreComponent.Holder.getInstance().getOneAgentUserInteractionManagerBridge();
    }

    @Override
    public OneAgentStartup provideOneAgentStartup() {
        return CoreComponent.Holder.getInstance().getOneAgentStartup();
    }

    @Override
    public RumEventDispatcher provideRumEventDispatcher() {
        return CoreComponent.Holder.getInstance().getRumEventDispatcher();
    }

    @Override
    public ViewContextStorage provideViewContextStorage() {
        return CoreComponent.Holder.getInstance().getViewContextStorage();
    }

    @Override
    public void shutdown() {
        CoreComponent.Holder.tearDown();
    }
}

