/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.mixed;

import android.content.Context;
import android.os.Build;
import com.dynatrace.agent.metrics.AppVersion;
import com.dynatrace.agent.metrics.BasicMetricsProvider;
import com.dynatrace.agent.metrics.DynamicBasicMetrics;
import com.dynatrace.agent.metrics.SessionInformationMetrics;
import com.dynatrace.agent.metrics.StaticBasicMetrics;
import com.dynatrace.agent.util.RootDetector;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.metrics.AndroidMetrics;
import com.dynatrace.android.agent.metrics.AppVersionTracker;
import com.dynatrace.android.agent.mixed.DynamicBasicMetricsImpl;
import com.dynatrace.android.agent.mixed.SessionInformationGenerator;
import com.dynatrace.android.agent.mixed.StaticBasicMetricsImpl;
import com.dynatrace.android.agent.util.SdkVersionProviderImpl;
import com.dynatrace.android.lifecycle.activitytracking.metrics.ScreenMetrics;

public class BasicMetricsProviderImpl
implements BasicMetricsProvider {
    private static final long COMMON_METRICS_MAX_AGE = 5000L;
    private final Context applicationContext;
    private StaticBasicMetrics staticMetricsProvider = null;

    public BasicMetricsProviderImpl(Context applicationContext) {
        this.applicationContext = applicationContext;
    }

    public DynamicBasicMetrics obtainDynamicBasicMetrics() {
        AndroidMetrics androidMetrics = AndroidMetrics.getInstance();
        if (androidMetrics.getCommonMetricsAge() > 5000L) {
            androidMetrics.updateCommonMetrics();
        }
        ScreenMetrics screenMetrics = androidMetrics.getScreenMetrics();
        return new DynamicBasicMetricsImpl.Builder().withDeviceScreenWidth(screenMetrics == null ? -1 : screenMetrics.getScreenWidth()).withDeviceScreenHeight(screenMetrics == null ? -1 : screenMetrics.getScreenHeight()).withDeviceScreenOrientation(androidMetrics.deviceOrientation).withDeviceBatteryLevel(androidMetrics.batteryLevel).withGeoLocation(androidMetrics.mockDeviceLocation).build();
    }

    public StaticBasicMetrics obtainStaticBasicMetrics() {
        if (this.staticMetricsProvider == null) {
            this.staticMetricsProvider = this.collectStaticMetrics();
        }
        return this.staticMetricsProvider;
    }

    public SessionInformationMetrics getSessionForInternalEvent() {
        Session session = Session.determineActiveSessionForInternalEvent();
        return SessionInformationGenerator.generate(session);
    }

    private StaticBasicMetrics collectStaticMetrics() {
        AppVersionTracker versionTracker = new AppVersionTracker(this.applicationContext, new SdkVersionProviderImpl());
        AppVersion appVersion = versionTracker.determineAppVersion();
        return new StaticBasicMetricsImpl.Builder().withDeviceManufacturer(Build.MANUFACTURER).withDeviceModelIdentifier(Build.MODEL).withDeviceIsRooted(RootDetector.INSTANCE.isDeviceRooted(this.applicationContext)).withOsName("Android").withOsVersion(Build.VERSION.RELEASE).withBundle(this.applicationContext.getPackageName()).withAppVersion(appVersion).build();
    }
}

