/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.mixed;

import com.dynatrace.android.agent.mixed.BaseWebRequestEventGenerator;
import org.json.JSONException;
import org.json.JSONObject;

public class ManualWebRequestEventGenerator
extends BaseWebRequestEventGenerator {
    public ManualWebRequestEventGenerator() {
        super("manual");
    }

    @Override
    public JSONObject generateRumRequestEvent() {
        return super.generateRumRequestEvent();
    }

    @Override
    protected JSONObject populateJson(JSONObject jsonObject) throws JSONException {
        if (this.networkProtocolName.startsWith("http")) {
            this.handleHttp(jsonObject);
        } else if (this.networkProtocolName.startsWith("ws")) {
            this.handleWs(jsonObject);
        } else {
            this.handleGeneric(jsonObject);
        }
        return jsonObject;
    }

    private void handleHttp(JSONObject jsonObject) throws JSONException {
        jsonObject.put("network.protocol.name", (Object)"http");
        if (this.statusCode >= 100 && this.statusCode <= 399) {
            jsonObject.put("http.response.status_code", this.statusCode);
            if (this.reasonPhrase != null && !this.reasonPhrase.isEmpty()) {
                jsonObject.put("http.response.reason_phrase", (Object)this.reasonPhrase);
            }
        } else if (this.statusCode >= 400 && this.statusCode <= 599) {
            jsonObject.put("http.response.status_code", this.statusCode);
            jsonObject.put("characteristics.has_error", true);
            jsonObject.put("characteristics.has_failed_request", true);
            if (this.reasonPhrase != null && !this.reasonPhrase.isEmpty()) {
                jsonObject.put("http.response.reason_phrase", (Object)this.reasonPhrase);
            }
        } else {
            jsonObject.put("characteristics.has_error", true);
            jsonObject.put("characteristics.has_failed_request", true);
            if (this.reasonPhrase != null && !this.reasonPhrase.isEmpty()) {
                jsonObject.put("characteristics.has_exception", true);
                jsonObject.put("exception.message", (Object)this.reasonPhrase);
            }
        }
    }

    private void handleWs(JSONObject jsonObject) throws JSONException {
        jsonObject.put("network.protocol.name", (Object)"ws");
        if (this.statusCode == 1000 || this.statusCode == 1001) {
            jsonObject.put("websocket.response.status_code", this.statusCode);
        } else if (this.statusCode >= 1002 && this.statusCode <= 4999) {
            jsonObject.put("websocket.response.status_code", this.statusCode);
            jsonObject.put("characteristics.has_error", true);
            jsonObject.put("characteristics.has_failed_request", true);
        } else {
            jsonObject.put("characteristics.has_error", true);
            jsonObject.put("characteristics.has_failed_request", true);
        }
    }

    private void handleGeneric(JSONObject jsonObject) throws JSONException {
        jsonObject.put("network.protocol.name", (Object)this.networkProtocolName);
    }
}

