/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.view.View;
import android.view.Window;
import com.dynatrace.agent.OneAgentStartup;
import com.dynatrace.agent.api.OneAgentFacade;
import com.dynatrace.agent.communication.api.AgentState;
import com.dynatrace.agent.events.EventThrottler;
import com.dynatrace.agent.metrics.SessionInformationMetrics;
import com.dynatrace.android.agent.ActionThreadLocal;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.AgentStateListener;
import com.dynatrace.android.agent.BasicSegment;
import com.dynatrace.android.agent.CalloutTable;
import com.dynatrace.android.agent.CommunicationManager;
import com.dynatrace.android.agent.CrashReporter;
import com.dynatrace.android.agent.CrashSegment;
import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.DTXActionImpl;
import com.dynatrace.android.agent.DTXAutoAction;
import com.dynatrace.android.agent.ErrorSegment;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.ExposedUserAction;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.GuardedEventDispatcher;
import com.dynatrace.android.agent.SrBeaconParamListener;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.UserActionModifier;
import com.dynatrace.android.agent.Version;
import com.dynatrace.android.agent.VisitSegment;
import com.dynatrace.android.agent.WebReqTag;
import com.dynatrace.android.agent.communication.CommunicationManagerBridge;
import com.dynatrace.android.agent.conf.AgentMode;
import com.dynatrace.android.agent.conf.Configuration;
import com.dynatrace.android.agent.conf.ConfigurationFactory;
import com.dynatrace.android.agent.conf.InitialServerIdProvider;
import com.dynatrace.android.agent.conf.PrivacyRules;
import com.dynatrace.android.agent.conf.ServerConfiguration;
import com.dynatrace.android.agent.cookie.CookieHandler;
import com.dynatrace.android.agent.crash.CrashCatcher;
import com.dynatrace.android.agent.crash.CrashListener;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.data.SessionParameterStore;
import com.dynatrace.android.agent.data.SessionParameterUtil;
import com.dynatrace.android.agent.db.DataAccessObject;
import com.dynatrace.android.agent.db.DatabaseWriteQueue;
import com.dynatrace.android.agent.events.eventsapi.BizEventSegment;
import com.dynatrace.android.agent.events.eventsapi.CopyAttributeFilter;
import com.dynatrace.android.agent.events.eventsapi.EnrichmentAttribute;
import com.dynatrace.android.agent.events.eventsapi.EnrichmentAttributesGenerator;
import com.dynatrace.android.agent.events.eventsapi.EventMetrics;
import com.dynatrace.android.agent.events.eventsapi.EventMetricsAggregator;
import com.dynatrace.android.agent.events.eventsapi.EventMetricsAggregatorFactory;
import com.dynatrace.android.agent.events.eventsapi.EventPayloadGenerator;
import com.dynatrace.android.agent.events.eventsapi.EventPayloadUtility;
import com.dynatrace.android.agent.events.ragetap.RageTapObserver;
import com.dynatrace.android.agent.lifecycle.OneAgentLifecycleManagerBridge;
import com.dynatrace.android.agent.metrics.AndroidMetrics;
import com.dynatrace.android.agent.mixed.AgentServiceLocator;
import com.dynatrace.android.agent.mixed.SessionInformationGenerator;
import com.dynatrace.android.agent.mixed.TimeProviderFactory;
import com.dynatrace.android.agent.useraction.OneAgentUserInteractionManagerBridge;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.internal.api.SelfMonitoring;
import com.dynatrace.android.lifecycle.ActivityLifecycleMonitor;
import com.dynatrace.android.lifecycle.activitytracking.ActiveActivityMonitor;
import com.dynatrace.android.lifecycle.appstart.ApplicationStartMonitor;
import com.dynatrace.android.lifecycle.appstate.ApplicationStateMonitor;
import com.dynatrace.android.ragetap.detection.RageTapDetector;
import com.dynatrace.android.ragetap.detection.RageTapListener;
import com.dynatrace.android.ragetap.measure.TapMonitorFactory;
import com.dynatrace.android.window.OnKeyEventListener;
import com.dynatrace.android.window.OnTouchEventListener;
import com.dynatrace.android.window.WindowCallbackMonitor;
import com.dynatrace.android.window.WindowListenerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Unit;
import org.json.JSONException;
import org.json.JSONObject;

public final class Core {
    public static final int DEFAULT_PURGE_DATA_TIMEOUT_MS = 540000;
    static final int FLUSH_WAIT_TIME_MS = 5000;
    static final int SECONDS_PER_TICK = 10;
    private static final int DEFAULT_SEND_EVENT_TIMEOUT_TICKS = 12;
    private static final String TAG = Global.LOG_PREFIX + "Core";
    private static final ActivityLifecycleMonitor ACTIVITY_LIFECYCLE_MONITOR = new ActivityLifecycleMonitor();
    private static final ApplicationStartMonitor APPLICATION_START_MONITOR = new ApplicationStartMonitor();
    private static final ApplicationStateMonitor APPLICATION_STATE_MONITOR = new ApplicationStateMonitor();
    private static final ActiveActivityMonitor ACTIVE_ACTIVITY_MONITOR = new ActiveActivityMonitor();
    private static final WindowCallbackMonitor WINDOW_CALLBACK_MONITOR = new WindowCallbackMonitor();
    public static final GuardedEventDispatcher GUARDED_EVENT_DISPATCHER = new GuardedEventDispatcher();
    public static DataAccessObject dao;
    private static BasicSegment basicSegment;
    private static long mSendEventTimeoutTicks;
    private static CalloutTable mCalloutTable;
    static CommunicationManager communicationManager;
    static OneAgentFacade oneAgentFacade;
    private static AtomicBoolean isFirstStartup;
    private static AdkSettings adk;
    private static CrashReporter crashReporter;
    private static CookieHandler cookieHandler;
    private static RageTapDetector rageTapDetector;
    private static CommunicationManagerBridge communicationManagerBridge;
    private static OneAgentLifecycleManagerBridge oneAgentLifecycleManagerBridge;
    private static OneAgentUserInteractionManagerBridge oneAgentUserInteractionManagerBridge;
    private static OneAgentStartup oneAgentStartup;
    private static AgentServiceLocator currentLocator;
    private static EventThrottler eventThrottler;
    private static SessionParameterStore sessionParameterStore;

    public static void startNewSession(boolean forceNewSession, PrivacyRules privacyRules) {
        Core.startNewSession(forceNewSession, privacyRules, TimeLineProvider.getSystemTime());
    }

    public static void startNewSession(boolean forceNewSession, PrivacyRules privacyRules, long sessionStartTime) {
        long newVisitorId;
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)("new session with " + privacyRules.getPrivacySettings().toString()));
        }
        int newSessionId = 1;
        if (privacyRules.keepVisitorId()) {
            boolean visitorIdChanged;
            int storedSessionId = sessionParameterStore.getSessionId();
            newSessionId = storedSessionId + 1;
            long storedVisitorId = sessionParameterStore.getVisitorId();
            boolean requireNewVisitorSent = false;
            if (storedVisitorId == 0L) {
                newVisitorId = SessionParameterUtil.generateVisitorId();
                requireNewVisitorSent = true;
            } else {
                newVisitorId = storedVisitorId;
            }
            Session currentSession = Session.currentSession();
            boolean bl = visitorIdChanged = currentSession != null && currentSession.visitorId != newVisitorId;
            if (requireNewVisitorSent || forceNewSession && visitorIdChanged) {
                AdkSettings.getInstance().setNewVisitorSent(false);
            }
            sessionParameterStore.update(newSessionId, newVisitorId);
        } else {
            newVisitorId = SessionParameterUtil.generateVisitorId();
            sessionParameterStore.update(0, 0L);
            AdkSettings.getInstance().setNewVisitorSent(true);
            Core.setGpsLocation(null);
        }
        Session currentSession = forceNewSession ? Session.startNewSession(privacyRules, sessionStartTime) : Session.startNewSessionIfNeeded(privacyRules);
        currentSession.visitorId = newVisitorId;
        currentSession.sessionId = newSessionId;
        if (!forceNewSession) {
            currentSession.internalSetPrivacyRules(privacyRules);
        }
        Core.startNewSession(currentSession, forceNewSession);
    }

    public static void startNewSession(Session currentSession, boolean forceNewSession) {
        int serverId;
        if (forceNewSession) {
            Core.resetLifecycleData();
        }
        ServerConfiguration serverConfiguration = AdkSettings.getInstance().getServerConfiguration();
        AdkSettings.getInstance().serverId = serverId = serverConfiguration.getServerId();
        if (communicationManagerBridge != null) {
            communicationManagerBridge.updateServerId(serverId);
        }
        basicSegment.update(true);
        if (AdkSettings.getInstance().hybridApp) {
            if (!forceNewSession) {
                cookieHandler.onAgentStart();
            }
            cookieHandler.onSessionStart(currentSession, AdkSettings.appIdEncoded);
        }
        if (AdkSettings.getInstance().getConfiguration().isRageTapDetectionEnabled && rageTapDetector != null) {
            rageTapDetector.onNewSession(currentSession);
        }
        if (currentSession.getPrivacyRules().shouldCollectEvent(EventType.ACTION_AUTO_LOADING_APP)) {
            DTXAutoAction loadingAction = new DTXAutoAction("Loading " + AdkSettings.applName, currentSession, serverId, true);
            loadingAction.updateEndTime();
            loadingAction.endActionSequenceNum = Utility.getEventSeqNum();
            loadingAction.eventType = EventType.ACTION_AUTO_LOADING_APP;
            Core.saveSegment(loadingAction);
        }
        communicationManager.startNewSession(currentSession);
        Core.flushEvents();
        AgentStateListener agentStateListener = adk.getAgentStateListener();
        if (agentStateListener != null) {
            SrBeaconParamListener srParamListener = new SrBeaconParamListener();
            agentStateListener.onNewSessionStarted(serverConfiguration, currentSession, serverId, srParamListener);
        }
    }

    static void flushEvents() {
        if (dao == null) {
            return;
        }
        DatabaseWriteQueue.getInstance().flushQueue();
        mCalloutTable.purge();
        communicationManager.flushEvents();
    }

    static void applyServerConfiguration(ServerConfiguration serverConfig) {
        long lX;
        adk.switchServerConfiguration(serverConfig);
        mSendEventTimeoutTicks = lX = (long)((serverConfig.getSendIntervalSec() + 10 - 1) / 10);
        mCalloutTable.changeSendEventTimeout(mSendEventTimeoutTicks);
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)String.format("Send event timeout set to: %s ticks", lX));
        }
        if (serverConfig.isSwitchServer()) {
            int serverId;
            AdkSettings.getInstance().serverId = serverId = serverConfig.getServerId();
            if (communicationManagerBridge != null) {
                communicationManagerBridge.updateServerId(serverId);
            }
        }
    }

    public static void applyConfigurationFromOneAgent(ServerConfiguration newConfiguration) {
        communicationManager.handleConfigReceivedFromOneAgent(newConfiguration);
    }

    public static void applyAgentStateFromOneAgent(AgentState state) {
        communicationManager.handleAgentStateReceivedFromOneAgent(state);
    }

    static void persistEventCmn(CustomSegment segment) {
        PrivacyRules privacyRules = segment.session.getPrivacyRules();
        if (!privacyRules.shouldCollectEvent(segment.getEventType())) {
            return;
        }
        if (eventThrottler == null || !eventThrottler.acceptEvent()) {
            if (Global.DEBUG) {
                Utility.zlogD((String)TAG, (String)"Dropped event due to throttling");
            }
            return;
        }
        String sEvtStr = segment.createEventData().toString();
        basicSegment.update(false);
        String sObcv = Core.getOcvbString(segment.session);
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)String.format("Store %dbytes", sObcv.length() + sEvtStr.length()));
        }
        DatabaseWriteQueue.getInstance().accept(new DatabaseWriteQueue.DatabaseRecord(sObcv, sEvtStr, segment.session, segment.getEventType().getProtocolId(), segment.getStartTime(), segment.getServerId(), AdkSettings.appIdEncoded));
    }

    static String getOcvbString(Session session) {
        return basicSegment.createEventData(session).toString();
    }

    static CustomSegment addEvent(String name, int type, long parentTagId, DTXActionImpl action, Session session, int serverId, String ... values) {
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)String.format("Handle event name=%s type=%s", name, type));
        }
        long effectiveParentTagId = parentTagId;
        if (parentTagId < 0L) {
            effectiveParentTagId = 0L;
        }
        CustomSegment oaSeg = null;
        switch (type) {
            case 4: {
                if (name == null || name.isEmpty()) {
                    return null;
                }
                oaSeg = new CustomSegment(name, 4, EventType.NAMED_EVENT, effectiveParentTagId, session, serverId, true);
                mCalloutTable.addOtherEvent();
                break;
            }
            case 12: {
                oaSeg = new CustomSegment(name, 12, EventType.IDENTIFY_USER, effectiveParentTagId, session, serverId, !session.isGrailEventsShouldBeCaptured());
                mCalloutTable.addOtherEvent();
                break;
            }
            case 11: {
                if (name == null || name.isEmpty()) {
                    return null;
                }
                oaSeg = new CrashSegment(name, values[0], values[1], session, serverId, values[2], !session.isGrailEventsShouldBeCaptured());
                mCalloutTable.addOtherEvent();
                CrashCatcher.notifyListeners(values[2], name, values[0], values[1]);
                break;
            }
            case 21: {
                if (name == null || name.isEmpty()) {
                    return null;
                }
                oaSeg = new CrashSegment(name, values[0], values[1], session, serverId, values[2], true);
                mCalloutTable.addOtherEvent();
                CrashCatcher.notifyListeners(values[2], name, values[0], values[1]);
                break;
            }
            case 9: {
                if (name == null || name.isEmpty()) {
                    return null;
                }
                oaSeg = new CustomSegment(name, 6, EventType.ERROR_INT, effectiveParentTagId, session, serverId, !session.isGrailEventsShouldBeCaptured());
                oaSeg.mValue = Utility.truncateString((String)values[0], (int)250);
                mCalloutTable.addOtherEvent();
                break;
            }
            case 10: {
                if (name == null || name.isEmpty()) {
                    return null;
                }
                oaSeg = new ErrorSegment(name, values[0], values[1], values[2], effectiveParentTagId, session, serverId, values[3], !session.isGrailEventsShouldBeCaptured());
                mCalloutTable.addOtherEvent();
                break;
            }
            case 20: {
                if (name == null || name.isEmpty()) {
                    return null;
                }
                oaSeg = new ErrorSegment(name, values[0], values[1], values[2], effectiveParentTagId, session, serverId, values[3], true);
                mCalloutTable.addOtherEvent();
                break;
            }
            case 6: {
                if (name == null || name.isEmpty()) {
                    return null;
                }
                oaSeg = new CustomSegment(name, 6, EventType.VALUE_INT64, effectiveParentTagId, session, serverId, true);
                oaSeg.mValue = Utility.truncateString((String)values[0], (int)250);
                mCalloutTable.addOtherEvent();
                break;
            }
            case 8: {
                if (name == null || name.isEmpty()) {
                    return null;
                }
                oaSeg = new CustomSegment(name, 6, EventType.VALUE_STRING, effectiveParentTagId, session, serverId, true);
                oaSeg.mValue = Utility.truncateString((String)values[0], (int)250);
                mCalloutTable.addOtherEvent();
                break;
            }
            case 7: {
                if (name == null || name.isEmpty()) {
                    return null;
                }
                oaSeg = new CustomSegment(name, 6, EventType.VALUE_DOUBLE, effectiveParentTagId, session, serverId, true);
                oaSeg.mValue = Utility.truncateString((String)values[0], (int)250);
                mCalloutTable.addOtherEvent();
                break;
            }
            case 1: {
                oaSeg = action;
                if (action == null) break;
                mCalloutTable.addActionEvent(action);
                break;
            }
            case 2: {
                oaSeg = action;
                if (action == null) break;
                oaSeg.updateEndTime();
                break;
            }
            default: {
                if (!Global.DEBUG) break;
                Utility.zlogD((String)TAG, (String)String.format("addEvent invalid type: %d", type));
            }
        }
        Core.saveSegment(oaSeg, type);
        return oaSeg;
    }

    public static void reportUserTag(Session session) {
        Utility.devLog((String)"dtxEventGeneration", (String)("reportUserTag, session: " + session.getUserTag()));
        int serverId = AdkSettings.getInstance().serverId;
        Core.addEvent(session.getUserTag(), 12, 0L, null, session, serverId, new String[0]);
        GUARDED_EVENT_DISPATCHER.executeWithVerification(session, eventDispatcher -> {
            JSONObject jsonObject = Core.createIdentifyUserEvent(session.getUserTag());
            if (jsonObject != null) {
                long timestamp = TimeLineProvider.getSystemTime();
                SessionInformationMetrics sessionInfo = SessionInformationGenerator.generate(session);
                eventDispatcher.dispatchEvent(jsonObject, timestamp, 0L, sessionInfo, true, null);
            }
        });
    }

    private static JSONObject createIdentifyUserEvent(String userTag) {
        if (userTag == null || userTag.isEmpty()) {
            return null;
        }
        if (userTag.length() > 250) {
            userTag = userTag.substring(0, 250);
        }
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("dt.rum.user_tag", (Object)userTag);
            Utility.devLog((String)"dtxEventGeneration", (String)("identifyUser event was generated: " + jsonObject));
            return jsonObject;
        }
        catch (JSONException e) {
            Utility.devLog((String)"dtxEventGeneration", (String)"identifyUser event can't be generated");
            return null;
        }
    }

    public static void saveSegment(CustomSegment oaSeg) {
        Core.saveSegment(oaSeg, oaSeg.getType());
    }

    private static void saveSegment(CustomSegment oaSeg, int type) {
        if (oaSeg != null && oaSeg.isFinalized() && oaSeg.isEnabled()) {
            if (basicSegment != null) {
                Core.persistEventCmn(oaSeg);
                if (CustomSegment.firstSendOccurred.get() == 0) {
                    CustomSegment.firstSendOccurred.set(1);
                }
            } else if (Global.DEBUG) {
                Utility.zlogD((String)TAG, (String)"discarded");
            }
            if (type == 2) {
                mCalloutTable.removeActionSendEvent(oaSeg);
            }
        }
    }

    static void startup(Application application, Activity activeActivity, Configuration configuration, AgentServiceLocator locator) {
        boolean isSessionReplayEnabled;
        PrivacyRules privacyRules;
        currentLocator = locator;
        if (configuration.debugLogLevel) {
            Global.DEBUG = true;
        }
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)("startup configuration: " + configuration));
            Utility.zlogI((String)TAG, (String)String.format("%s %s Target API %d Android API %d", AdkSettings.getADKName(), Version.getFullVersion(), Utility.getAppTargetSdk((Context)application), Build.VERSION.SDK_INT));
            if (activeActivity != null) {
                Utility.zlogD((String)TAG, (String)("agent started within activity '" + activeActivity.getClass().getName() + "'"));
            }
        }
        sessionParameterStore = new SessionParameterStore((Context)application);
        sessionParameterStore.preload();
        DTXAutoAction.setAutoInstrProperties(configuration);
        adk.setup(configuration, (Context)application);
        ServerConfiguration serverConfiguration = Core.adk.preferencesManager.getServerConfiguration(new InitialServerIdProvider().getDefaultServerId(configuration), configuration.startupWithGrailEnabled);
        if (serverConfiguration.isGen3Enabled()) {
            currentLocator.init();
            GUARDED_EVENT_DISPATCHER.initEventDispatcher(locator.provideRumEventDispatcher());
            oneAgentStartup = locator.provideOneAgentStartup();
            communicationManagerBridge = locator.provideCommunicationManagerBridge();
            oneAgentLifecycleManagerBridge = locator.provideOneAgentLifecycleManagerBridge();
            if (ConfigurationFactory.isUserInteractionEnabled()) {
                oneAgentUserInteractionManagerBridge = locator.provideOneAgentUserInteractionManagerBridge();
            }
            oneAgentFacade = locator.provideOneAgentFacade();
        } else {
            Utility.devLog((String)"dtxStartStop", (String)"RUM powered by Grail deactivated");
        }
        eventThrottler = new EventThrottler(new TimeProviderFactory().createTimelineProvider(), configuration.eventThrottlingLimit, droppedEvents -> {
            SelfMonitoring.reportLogEvent("EventThrottling", String.format("Dropped %d events, current limit: %d", droppedEvents, configuration.eventThrottlingLimit));
            return Unit.INSTANCE;
        });
        Core.applyServerConfiguration(serverConfiguration);
        if (configuration.userOptIn) {
            privacyRules = new PrivacyRules(Core.adk.preferencesManager.readPrivacySettings());
        } else {
            Core.adk.preferencesManager.removePrivacySettings();
            privacyRules = PrivacyRules.PRIVACY_MODE_DEACTIVATED;
        }
        AdkSettings.appIdEncoded = configuration.appIdEncoded;
        AndroidMetrics.getInstance();
        if (isFirstStartup.get()) {
            Session.startNewSessionIfNeeded(privacyRules, serverConfiguration.isGen3Enabled());
        } else {
            Utility.resetEventSeqNum();
            Session.startNewSession(privacyRules, serverConfiguration.isGen3Enabled());
        }
        dao = new DataAccessObject((Context)application);
        dao.deleteEventsWithMismatchAppId(configuration.appIdEncoded);
        AgentStateListener agentStateListener = null;
        boolean bl = isSessionReplayEnabled = configuration.sessionReplayComponentProvider != null;
        if (isSessionReplayEnabled) {
            agentStateListener = configuration.sessionReplayComponentProvider.generateAgentStateListener();
            if (Global.DEBUG) {
                Utility.zlogD((String)TAG, (String)("set new agent state listener: " + agentStateListener));
            }
            adk.setAgentStateListener(agentStateListener);
        }
        basicSegment = new BasicSegment(configuration.instrumentationFlavor);
        DatabaseWriteQueue.getInstance().start();
        mCalloutTable.changeSendEventTimeout(mSendEventTimeoutTicks);
        communicationManager.startup(dao, configuration, agentStateListener, communicationManagerBridge);
        if (configuration.crashReporting) {
            CrashCatcher.installUncaughtExceptionHandler();
            CrashCatcher.registerUncaughtExceptionListener(Core.getCrashListener());
        }
        if (agentStateListener != null) {
            agentStateListener.onAgentStarted(application, configuration, adk.getServerConfiguration(), privacyRules);
        }
        if (configuration.activityMonitoring) {
            ACTIVITY_LIFECYCLE_MONITOR.startMonitoring(application, TimeLineProvider.GLOBAL_TIME_LINE_PROVIDER);
        }
        ACTIVE_ACTIVITY_MONITOR.startMonitoring(application);
        if (configuration.applicationMonitoring) {
            APPLICATION_START_MONITOR.onAgentStart(application, TimeLineProvider.GLOBAL_TIME_LINE_PROVIDER);
        }
        APPLICATION_STATE_MONITOR.startMonitoring(application);
        if (serverConfiguration.isGen3Enabled() && oneAgentLifecycleManagerBridge != null) {
            oneAgentLifecycleManagerBridge.onAppStart();
        }
        ArrayList<WindowListenerFactory> factories = new ArrayList<WindowListenerFactory>();
        if (isSessionReplayEnabled) {
            factories.add(configuration.sessionReplayComponentProvider.generateWindowListenerFactory());
        }
        if (serverConfiguration.isGen3Enabled() && oneAgentUserInteractionManagerBridge != null) {
            factories.add(new WindowListenerFactory(){

                @Override
                public OnTouchEventListener generateOnTouchEventListener(Window window) {
                    View rootView = window.getDecorView().getRootView();
                    return event -> oneAgentUserInteractionManagerBridge.onMotionEvent(rootView, event);
                }

                @Override
                public OnKeyEventListener generateOnKeyEventListener() {
                    return null;
                }
            });
        }
        if (configuration.isRageTapDetectionEnabled) {
            ArrayList<RageTapListener> rageTapListeners = new ArrayList<RageTapListener>();
            rageTapListeners.add(new RageTapObserver());
            if (isSessionReplayEnabled) {
                rageTapListeners.add(configuration.sessionReplayComponentProvider.generateRageTapListener());
            }
            ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
            rageTapDetector = new RageTapDetector(rageTapListeners, executor, TimeLineProvider.GLOBAL_TIME_LINE_PROVIDER);
            factories.add(new TapMonitorFactory(rageTapDetector, TimeLineProvider.GLOBAL_TIME_LINE_PROVIDER));
        }
        WINDOW_CALLBACK_MONITOR.startMonitoring(application, activeActivity, factories);
        if (configuration.hybridApp) {
            HashSet<String> domains = new HashSet<String>();
            HashSet<String> httpsDomains = new HashSet<String>();
            if (configuration.monitoredDomains != null) {
                Collections.addAll(domains, configuration.monitoredDomains);
            }
            if (configuration.monitoredHttpsDomains != null) {
                Collections.addAll(httpsDomains, configuration.monitoredHttpsDomains);
            }
            if (configuration.mode == AgentMode.APP_MON) {
                if (configuration.getServerUrl().startsWith("https://")) {
                    httpsDomains.add(configuration.getServerUrl());
                } else {
                    domains.add(configuration.getServerUrl());
                }
            }
            if (configuration.fileDomainCookies) {
                domains.add("file://");
            }
            cookieHandler = new CookieHandler(domains, httpsDomains, configuration.fileDomainCookies, configuration.mode);
        }
        Core.startNewSession(false, privacyRules);
        if (oneAgentStartup != null) {
            oneAgentStartup.start(serverConfiguration);
        }
        communicationManager.startTimerLoop(true);
        Global.isAlive.set(true);
        isFirstStartup.set(false);
    }

    public static synchronized void resetLifecycleData() {
        Core.forceCloseActiveActions("resetLifecycle");
        Utility.resetEventSeqNum();
    }

    public static void forceCloseActiveActions(String reason) {
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)String.format("%s ... force closed actions due to %s", Thread.currentThread().getName(), reason));
        }
        ActionThreadLocal.closeAll();
        DTXAutoAction.closeAll();
    }

    static synchronized void shutdown(long lStopTimeLimitSec) {
        Global.isAlive.set(false);
        if (sessionParameterStore != null) {
            sessionParameterStore.flush();
        }
        Application application = (Application)AdkSettings.getInstance().getContext();
        APPLICATION_STATE_MONITOR.stopMonitoring(application);
        APPLICATION_START_MONITOR.onAgentShutdown(application);
        if (oneAgentLifecycleManagerBridge != null) {
            oneAgentLifecycleManagerBridge.onAgentShutdown();
        }
        if (currentLocator != null) {
            currentLocator.shutdown();
        }
        ACTIVITY_LIFECYCLE_MONITOR.stopMonitoring(application);
        ACTIVE_ACTIVITY_MONITOR.stopMonitoring(application);
        WINDOW_CALLBACK_MONITOR.stopMonitoring(application);
        rageTapDetector = null;
        DatabaseWriteQueue.getInstance().stopThread();
        communicationManager.shutdown(lStopTimeLimitSec);
        currentLocator = null;
        GUARDED_EVENT_DISPATCHER.resetEventDispatcher();
        oneAgentStartup = null;
        communicationManagerBridge = null;
        oneAgentLifecycleManagerBridge = null;
        oneAgentFacade = null;
    }

    static boolean getCaptureState() {
        return communicationManager.isUemActive();
    }

    static void setGpsLocation(Location lLoc) {
        if (Global.DEBUG && lLoc != null) {
            Utility.zlogD((String)TAG, (String)String.format("SetGpsCoord Lat:%s Lon:%s", lLoc.getLatitude(), lLoc.getLongitude()));
        }
        AndroidMetrics.getInstance().setGpsLocation(lLoc);
    }

    static WebReqTag getRequestTag() {
        if (!communicationManager.isUemActive()) {
            return null;
        }
        WebReqTag tag = null;
        DTXActionImpl parentAction = ActionThreadLocal.getCurrentAction();
        if (parentAction == null) {
            parentAction = DTXAutoAction.getAutoAction();
        }
        long parentTagId = 0L;
        Session session = null;
        int serverId = 0;
        if (parentAction != null) {
            parentTagId = parentAction.getTagId();
            session = parentAction.session;
            serverId = parentAction.serverId;
            tag = parentAction.getInternalRequestTag();
        }
        if (tag == null) {
            parentTagId = 0L;
            session = Session.determineActiveSession(false);
            serverId = AdkSettings.getInstance().serverId;
            tag = new WebReqTag(parentTagId, serverId, session);
        }
        if (!session.getPrivacyRules().shouldCollectEvent(EventType.WEB_REQUEST)) {
            return null;
        }
        CustomSegment event = new CustomSegment(tag.toString(), 100, EventType.PLACEHOLDER, parentTagId, session, serverId, true);
        if (parentTagId == 0L) {
            DTXActionImpl.addOrphanEvent(event);
        } else {
            parentAction.addChildEvent(event);
        }
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)String.format("Added an event %s id=%d pid=%d", event.getName(), event.getTagId(), event.getParentTagId()));
        }
        return tag;
    }

    static CrashListener getCrashListener() {
        return crashReporter;
    }

    public static void removeFromCalloutTable(CustomSegment seg) {
        mCalloutTable.removeActionSendEvent(seg);
    }

    protected static void endVisit() {
        Session session = Session.determineActiveSession(true);
        int serverId = AdkSettings.getInstance().serverId;
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)("Ending current visit of session " + session.sessionId));
        }
        VisitSegment endVisit = VisitSegment.createVisitSegment(session, serverId, true);
        Core.saveSegment(endVisit);
        Core.startNewSession(true, session.getPrivacyRules());
    }

    public static void modifyUserAction(UserActionModifier modifier) {
        DTXAutoAction autoAction = DTXAutoAction.getAutoAction();
        if (autoAction == null) {
            if (Global.DEBUG) {
                Utility.zlogD((String)TAG, (String)"Cannot modify UserAction since there is none pending");
            }
            return;
        }
        ExposedUserAction exposedAuA = new ExposedUserAction(autoAction);
        modifier.modify(exposedAuA);
    }

    static void restoreCookies() {
        if (AdkSettings.getInstance().hybridApp) {
            cookieHandler.restoreCookies();
        }
    }

    static void handleTrafficLimitationForCookies(Session session) {
        if (AdkSettings.getInstance().hybridApp) {
            cookieHandler.onTrafficControlUpdate(session);
        }
    }

    public static CalloutTable getCalloutTable() {
        return mCalloutTable;
    }

    public static ApplicationStartMonitor getApplicationStartMonitor() {
        return APPLICATION_START_MONITOR;
    }

    public static OneAgentLifecycleManagerBridge getOneAgentLifecycleManagerBridge() {
        return oneAgentLifecycleManagerBridge;
    }

    public static OneAgentUserInteractionManagerBridge getOneAgentUserInteractionManagerBridge() {
        return oneAgentUserInteractionManagerBridge;
    }

    static void sendEvent(JSONObject fields, Object[] eventContext) {
        if (fields == null) {
            Utility.devLog((String)"dtxEventGeneration", (String)"cannot use 'null' fields for sendEvent");
            return;
        }
        Session session = Session.determineActiveSessionForInternalEvent();
        GUARDED_EVENT_DISPATCHER.executeWithVerification(session, eventDispatcher -> {
            EventType eventType;
            EventType eventType2 = eventType = Core.isCrash(fields) ? EventType.CRASH : EventType.EVENT_API;
            if (session.getPrivacyRules().shouldCollectEvent(eventType)) {
                eventDispatcher.dispatchEventWithRestrictions(fields, SessionInformationGenerator.generate(session), eventContext);
            } else {
                Utility.devLog((String)"dtxEventGeneration", (String)("sendEvent eventType shouldn't be collected, because of data collection level: " + (Object)((Object)eventType)));
            }
        });
    }

    static boolean isCrash(JSONObject attributes) {
        if (attributes == null) {
            return false;
        }
        Object hasCrash = attributes.opt("characteristics.has_crash");
        if (!(hasCrash instanceof Boolean)) {
            return false;
        }
        return (Boolean)hasCrash;
    }

    static void sendBizEvent(String type, JSONObject attributes) {
        long timestamp = TimeLineProvider.getSystemTimeNanos();
        if (attributes == null) {
            if (Global.DEBUG) {
                Utility.zlogD((String)TAG, (String)"Cannot send biz event whose attributes are 'null'");
            }
            return;
        }
        if (type == null || type.isEmpty()) {
            if (Global.DEBUG) {
                Utility.zlogD((String)TAG, (String)"Cannot send biz event whose type is 'null' or empty");
            }
            return;
        }
        Session session = Session.determineActiveSessionForInternalEvent();
        EventMetricsAggregator eventMetricsAggregator = EventMetricsAggregatorFactory.createEventMetricsAggregator();
        EventMetrics eventMetrics = eventMetricsAggregator.aggregateEventMetrics(session, AdkSettings.getInstance().getConfiguration(), AndroidMetrics.getInstance());
        Set<EnrichmentAttribute> enrichmentAttributes = new EnrichmentAttributesGenerator().withTimeStamp(timestamp).withEventMetrics(eventMetrics).generateBizEventAttributes(type, attributes);
        String jsonPayload = new EventPayloadGenerator(new CopyAttributeFilter()).generatePayload(enrichmentAttributes, attributes, false);
        Core.storeBizEvent(type, session, jsonPayload);
    }

    static void storeBizEvent(String name, Session session, String jsonPayload) {
        if (jsonPayload == null) {
            if (Global.DEBUG) {
                Utility.zlogD((String)TAG, (String)("Event \"" + name + "\" has been discarded"));
            }
        } else {
            String encodedPayloadWithMacro = EventPayloadUtility.replacePlaceholderWithMacro(Utility.urlEncode((String)jsonPayload));
            BizEventSegment segment = new BizEventSegment.Builder().withSession(session).withServerId(Core.adk.serverId).withEventName(name).withUrlEncodedJsonPayload(encodedPayloadWithMacro).withForwardToGrail(true).build();
            Core.getCalloutTable().addOtherEvent();
            Core.saveSegment(segment);
        }
    }

    static void sendSessionPropertyEvent(JSONObject properties) {
        if (properties == null) {
            Utility.devLog((String)"dtxEventGeneration", (String)"cannot use 'null' properties for sendSessionPropertyEvent");
            return;
        }
        Session session = Session.determineActiveSessionForInternalEvent();
        GUARDED_EVENT_DISPATCHER.executeWithVerification(session, eventDispatcher -> {
            if (session.getPrivacyRules().shouldCollectEvent(EventType.EVENT_SESSION_PROPERTIES)) {
                eventDispatcher.dispatchSessionPropertiesWithRestrictions(properties, SessionInformationGenerator.generate(session));
            } else {
                Utility.devLog((String)"dtxEventGeneration", (String)"sendSessionPropertyEvent shouldn't be collected because of data collection level");
            }
        });
    }

    static {
        basicSegment = null;
        mSendEventTimeoutTicks = 12L;
        mCalloutTable = new CalloutTable(12);
        communicationManager = new CommunicationManager(mCalloutTable);
        oneAgentFacade = null;
        isFirstStartup = new AtomicBoolean(true);
        adk = AdkSettings.getInstance();
        crashReporter = new CrashReporter(communicationManager);
        rageTapDetector = null;
        communicationManagerBridge = null;
        oneAgentLifecycleManagerBridge = null;
        oneAgentUserInteractionManagerBridge = null;
        oneAgentStartup = null;
        currentLocator = null;
        eventThrottler = null;
        sessionParameterStore = null;
    }
}

