/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.agent.common.InstrumentationFlavor;
import com.dynatrace.agent.events.error.ErrorEvent;
import com.dynatrace.agent.metrics.SessionInformationMetrics;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.CommunicationManager;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.CrashSegment;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.crash.CrashListener;
import com.dynatrace.android.agent.crash.StacktraceData;
import com.dynatrace.android.agent.crash.StacktraceProcessorFactory;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.mixed.SessionInformationGenerator;
import com.dynatrace.android.agent.util.Utility;
import org.json.JSONObject;

public class CrashReporter
implements CrashListener {
    private static final String LOGTAG = Global.LOG_PREFIX + "CrashReporter";
    public static boolean hasCrashed = false;
    private final StacktraceProcessorFactory processorFactory;
    protected CommunicationManager communicationManager;

    public CrashReporter(CommunicationManager communicationManager) {
        this.communicationManager = communicationManager;
        this.processorFactory = new StacktraceProcessorFactory();
    }

    protected static boolean hasCrashed() {
        return hasCrashed;
    }

    @Override
    public synchronized void notifyCustomCrash(String platformType, String crashName, String reason, String stacktrace) {
    }

    @Override
    public synchronized void notifyJavaCrash(Thread thread, Throwable t) {
        Session session = Session.determineActiveSession(true);
        int serverId = AdkSettings.getInstance().serverId;
        this.communicationManager.stopTimerLoop();
        if (session.isActive()) {
            this.reportCrash(thread, t, session, serverId);
        }
        Core.shutdown(5000L);
    }

    protected void reportCrash(Thread thread, Throwable throwable, Session session, int serverId) {
        long crashInstant = TimeLineProvider.getSystemTime();
        if (Global.DEBUG) {
            Utility.zlogE((String)LOGTAG, (String)String.format("Processing exception (in thread %s) ...", thread != null ? thread.getName() : "unknown"), (Throwable)throwable);
        }
        if (!session.getPrivacyRules().shouldCollectEvent(EventType.CRASH)) {
            Core.forceCloseActiveActions("a crash");
        } else {
            InstrumentationFlavor instrMode = AdkSettings.getInstance().getConfiguration().instrumentationFlavor;
            StacktraceData stacktraceData = this.processorFactory.determineCrashProcessor(throwable, instrMode).process();
            String name = stacktraceData.getName();
            if (instrMode == InstrumentationFlavor.REACT_NATIVE && name != null && name.contains("JavascriptException")) {
                Core.forceCloseActiveActions("a crash");
                return;
            }
            Utility.devLog((String)"dtxEventGeneration", (String)("reportCrash, thread: " + thread + ", throwable: " + throwable + ", serverId: " + serverId));
            Core.GUARDED_EVENT_DISPATCHER.executeWithVerification(session, eventDispatcher -> {
                Object[] eventContext = new Object[]{throwable, thread};
                JSONObject jsonObject = ErrorEvent.crashEvent((Throwable)throwable);
                if (jsonObject != null) {
                    SessionInformationMetrics sessionInformation = SessionInformationGenerator.generate(session);
                    eventDispatcher.dispatchEvent(jsonObject, crashInstant, 0L, sessionInformation, false, eventContext);
                }
            });
            CrashSegment oaSeg = new CrashSegment(name, stacktraceData.getReason(), stacktraceData.getStacktrace(), session, serverId, stacktraceData.getType().getProtocolValue(), !session.isGrailEventsShouldBeCaptured());
            Core.forceCloseActiveActions("a crash");
            if (!this.communicationManager.sendCrashData(oaSeg, serverId, session)) {
                oaSeg.setSendImmediately(false);
                Core.saveSegment(oaSeg);
            }
        }
    }
}

