/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.agent.OneAgentStartupEventDispatcher;
import com.dynatrace.agent.di.CoreComponent;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.mixed.SessionInformationGenerator;
import com.dynatrace.android.agent.util.Utility;
import org.json.JSONObject;

final class HybridBridge {
    private HybridBridge() {
    }

    static void forwardEvent(JSONObject rumEvent) {
        Utility.devLog((String)"dtxEventGeneration", (String)"forward a JSON event to the enrichment pipeline");
        if (!Dynatrace.getCaptureStatus()) {
            Utility.devLog((String)"dtxEventGeneration", (String)"forward event not possible, capturing is disabled");
            return;
        }
        if (rumEvent == null) {
            Utility.devLog((String)"dtxEventGeneration", (String)"cannot forward a hybrid JSON event that is 'null'");
            return;
        }
        CoreComponent coreComponent = CoreComponent.Holder.getInstance();
        if (coreComponent == null) {
            Utility.devLog((String)"dtxEventGeneration", (String)"cannot forward a hybrid JSON event because agent is not set up yet");
            return;
        }
        Session session = Session.determineActiveSessionForInternalEvent();
        if (session == null || !session.isActive() || !session.isGrailEventsShouldBeCaptured()) {
            Utility.devLog((String)"dtxEventGeneration", (String)"current session is 'null' or cannot accept Grail events");
            return;
        }
        boolean isAppStartEvent = rumEvent.optBoolean("characteristics.is_app_start", false);
        OneAgentStartupEventDispatcher startupEventDispatcher = coreComponent.getOneAgentStartupEventDispatcher();
        if (isAppStartEvent && startupEventDispatcher.getRequiresMergedAppStart()) {
            startupEventDispatcher.dispatchCrossPlatformEvent(rumEvent, SessionInformationGenerator.generate(session));
        } else {
            coreComponent.getRumEventDispatcher().dispatchEvent(rumEvent, SessionInformationGenerator.generate(session), null);
        }
    }
}

