/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.mixed;

import android.content.Context;
import android.os.Build;
import com.dynatrace.agent.metrics.AppVersion;
import com.dynatrace.agent.metrics.BasicMetricsProvider;
import com.dynatrace.agent.metrics.DynamicBasicMetrics;
import com.dynatrace.agent.metrics.SessionInformationMetrics;
import com.dynatrace.agent.metrics.StaticBasicMetrics;
import com.dynatrace.agent.util.RootDetector;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.metrics.AndroidMetrics;
import com.dynatrace.android.agent.metrics.AppVersionTracker;
import com.dynatrace.android.agent.mixed.SessionInformationGenerator;
import com.dynatrace.android.agent.util.SdkVersionProviderImpl;
import com.dynatrace.android.lifecycle.activitytracking.metrics.ScreenMetrics;

public class BasicMetricsProviderImpl
implements BasicMetricsProvider {
    private static final long COMMON_METRICS_MAX_AGE = 5000L;
    private final Context applicationContext;
    private StaticBasicMetrics staticMetricsProvider = null;
    private volatile boolean metricsInvalid = false;

    public BasicMetricsProviderImpl(Context applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void invalidateMetrics() {
        this.metricsInvalid = true;
    }

    public DynamicBasicMetrics obtainDynamicBasicMetrics() {
        ScreenMetrics screenMetrics;
        AndroidMetrics androidMetrics = AndroidMetrics.getInstance();
        if (this.metricsInvalid || androidMetrics.getCommonMetricsAge() > 5000L) {
            androidMetrics.updateCommonMetrics();
            this.metricsInvalid = false;
        }
        return new DynamicBasicMetrics((screenMetrics = androidMetrics.getScreenMetrics()) == null ? -1 : screenMetrics.getScreenWidth(), screenMetrics == null ? -1 : screenMetrics.getScreenHeight(), androidMetrics.deviceOrientation, androidMetrics.batteryLevel, androidMetrics.mockDeviceLocation);
    }

    public StaticBasicMetrics obtainStaticBasicMetrics() {
        if (this.staticMetricsProvider == null) {
            this.staticMetricsProvider = this.collectStaticMetrics();
        }
        return this.staticMetricsProvider;
    }

    public SessionInformationMetrics getSessionForInternalEvent() {
        Session session = Session.determineActiveSessionForInternalEvent();
        return SessionInformationGenerator.generate(session);
    }

    private StaticBasicMetrics collectStaticMetrics() {
        AppVersionTracker versionTracker = new AppVersionTracker(this.applicationContext, new SdkVersionProviderImpl());
        AppVersion appVersion = versionTracker.determineAppVersion();
        return new StaticBasicMetrics(Build.MANUFACTURER, Build.MODEL, RootDetector.INSTANCE.isDeviceRooted(this.applicationContext), "Android", Build.VERSION.RELEASE, this.applicationContext.getPackageName(), appVersion);
    }
}

