/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.ragetap.detection;

public class TapEventData {
    private final float x;
    private final float y;
    private final long timestamp;
    private final long eventTime;

    public TapEventData(float x, float y, long timestamp, long eventTime) {
        this.x = x;
        this.y = y;
        this.timestamp = timestamp;
        this.eventTime = eventTime;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TapEventData that = (TapEventData)o;
        return Float.compare(that.x, this.x) == 0 && Float.compare(that.y, this.y) == 0 && this.timestamp == that.timestamp && this.eventTime == that.eventTime;
    }

    public int hashCode() {
        int result = this.x != 0.0f ? Float.floatToIntBits(this.x) : 0;
        result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (int)(this.eventTime ^ this.eventTime >>> 32);
        return result;
    }

    public String toString() {
        return "TapEventData{x=" + this.x + ", y=" + this.y + ", timestamp=" + this.timestamp + ", eventTime=" + this.eventTime + '}';
    }
}

