/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.agent.RumEventDispatcher;
import com.dynatrace.agent.events.EventModifier;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;

public class GuardedEventDispatcher {
    private static final String LOGTAG = Global.LOG_PREFIX + "GuardedEventDispatcher";
    private RumEventDispatcher eventDispatcher = null;

    public void initEventDispatcher(RumEventDispatcher rumEventDispatcher) {
        this.eventDispatcher = rumEventDispatcher;
    }

    public void resetEventDispatcher() {
        this.eventDispatcher = null;
    }

    public boolean addEventModifier(EventModifier eventModifier) {
        if (this.eventDispatcher != null) {
            return this.eventDispatcher.addEventModifier(eventModifier);
        }
        return false;
    }

    public boolean removeEventModifier(EventModifier eventModifier) {
        if (this.eventDispatcher != null) {
            return this.eventDispatcher.removeEventModifier(eventModifier);
        }
        return false;
    }

    public void executeWithVerification(Session session, GuardedOperation guardedOperation) {
        if (session == null) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)"Session object is null");
            }
            return;
        }
        if (!session.isGrailEventsShouldBeCaptured() || !session.isActive()) {
            return;
        }
        if (this.eventDispatcher == null) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)"event dispatcher is not available");
            }
            return;
        }
        guardedOperation.execute(this.eventDispatcher);
    }

    public static interface GuardedOperation {
        public void execute(RumEventDispatcher var1);
    }
}

