/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;
import java.net.URLConnection;

public class WebReqTag {
    private static final String TAG_PREFIX = "MT_3_";
    private int serverId;
    private Session session;
    private String applId;
    private long parentTagId;
    private long threadId;
    private int seqNumber;

    public WebReqTag(long actionTagId, int serverId, Session session) {
        this(serverId, session, AdkSettings.appIdEncoded, actionTagId, Thread.currentThread().getId(), Utility.getEventSeqNum());
    }

    public WebReqTag(int serverId, Session session, String applId, long parentTagId, long threadId, int seqNumber) {
        this.serverId = serverId;
        this.session = session;
        this.applId = applId;
        this.parentTagId = parentTagId;
        this.threadId = threadId;
        this.seqNumber = seqNumber;
    }

    public static String getTagPrefix() {
        return TAG_PREFIX;
    }

    public static WebReqTag parseTag(String wrTag, Session session) {
        if (wrTag == null || wrTag.length() < 1) {
            return null;
        }
        String[] fields = wrTag.split("_");
        if (fields.length != 9) {
            return null;
        }
        try {
            boolean sameSession;
            long visitorId = Long.parseLong(fields[3]);
            int index = fields[4].indexOf(45);
            int sessionId = Integer.parseInt(fields[4].substring(0, index));
            int sequenceNr = Integer.parseInt(fields[4].substring(index + 1));
            boolean bl = sameSession = session.visitorId == visitorId && session.sessionId == sessionId && session.sequenceNumber == sequenceNr;
            if (!sameSession) {
                return null;
            }
            int serverId = Integer.parseInt(fields[2]);
            long parentTagId = Long.parseLong(fields[6]);
            long threadId = Long.parseLong(fields[7]);
            int seqNumber = Integer.parseInt(fields[8]);
            return new WebReqTag(serverId, session, fields[5], parentTagId, threadId, seqNumber);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String fetchWebReqTag(URLConnection conn, String headerName) {
        if (conn == null) {
            return null;
        }
        try {
            return conn.getRequestProperty(headerName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String tagToString(WebReqTag tag) {
        if (tag == null) {
            return "";
        }
        return tag.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TAG_PREFIX);
        sb.append(this.serverId).append("_");
        sb.append(this.session.visitorId).append("_");
        sb.append(this.session.sessionId);
        sb.append("-").append(this.session.sequenceNumber);
        sb.append("_");
        sb.append(this.applId).append("_");
        sb.append(this.parentTagId).append("_");
        sb.append(this.threadId).append("_");
        sb.append(this.seqNumber);
        return sb.toString();
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public long getParentTagId() {
        return this.parentTagId;
    }

    public Session getSession() {
        return this.session;
    }

    public int getServerId() {
        return this.serverId;
    }

    public boolean sameAs(WebReqTag otherTag) {
        if (otherTag == null) {
            return false;
        }
        return this.sameAs(otherTag.toString());
    }

    public boolean sameAs(String otherTag) {
        if (otherTag == null) {
            return false;
        }
        return this.toString().equals(otherTag);
    }
}

