/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.eventsapi;

import com.dynatrace.android.agent.events.eventsapi.OverridingStrategy;
import java.util.Objects;

public class EnrichmentAttribute
implements Comparable<EnrichmentAttribute> {
    private static final OverridingStrategy OVERRIDABLE = new OverridingStrategy(){

        @Override
        public boolean isOverridableBy(Object object) {
            return true;
        }
    };
    private static final OverridingStrategy NOT_OVERRIDABLE = new OverridingStrategy(){

        @Override
        public boolean isOverridableBy(Object object) {
            return false;
        }
    };
    private final String key;
    private final Object value;
    private final OverridingStrategy overridingStrategy;
    private final boolean addToOverridableKeys;

    private EnrichmentAttribute(String key, Object value, OverridingStrategy overridingStrategy, boolean addToOverridableKeys) {
        this.key = key;
        this.value = value;
        this.overridingStrategy = overridingStrategy;
        this.addToOverridableKeys = addToOverridableKeys;
    }

    public static EnrichmentAttribute mandatoryEnrichmentAttribute(String key, Object value) {
        return new EnrichmentAttribute(key, value, NOT_OVERRIDABLE, true);
    }

    public static EnrichmentAttribute conditionalEnrichmentAttribute(String key, Object value, OverridingStrategy overridingStrategy, boolean addToOverridableKeys) {
        return new EnrichmentAttribute(key, value, overridingStrategy, addToOverridableKeys);
    }

    public static EnrichmentAttribute overridableEnrichmentAttribute(String key, Object value) {
        return new EnrichmentAttribute(key, value, OVERRIDABLE, true);
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isOverridableBy(Object value) {
        return this.overridingStrategy.isOverridableBy(value);
    }

    public boolean shouldBeAddedToOverridableKeys() {
        return this.addToOverridableKeys;
    }

    @Override
    public int compareTo(EnrichmentAttribute other) {
        return this.key.compareTo(other.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnrichmentAttribute attribute = (EnrichmentAttribute)o;
        return Objects.equals(this.key, attribute.key) && Objects.equals(this.value, attribute.value) && Objects.equals(this.overridingStrategy, attribute.overridingStrategy) && this.addToOverridableKeys == attribute.addToOverridableKeys;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.overridingStrategy, this.addToOverridableKeys);
    }

    public String toString() {
        return "EnrichmentAttribute{key='" + this.key + '\'' + ", value=" + this.value + ", overridingStrategy=" + this.overridingStrategy + ", addToOverridableKeys=" + this.addToOverridableKeys + '}';
    }
}

