/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.lifecycle.activitytracking;

import android.app.Application;
import com.dynatrace.agent.di.CoreComponent;
import com.dynatrace.agent.metrics.MetricsCache;
import com.dynatrace.agent.metrics.OneAgentScreenMetrics;
import com.dynatrace.android.agent.metrics.AndroidMetrics;
import com.dynatrace.android.lifecycle.activitytracking.ActiveActivityListener;
import com.dynatrace.android.lifecycle.activitytracking.ActiveActivityTracker;
import com.dynatrace.android.lifecycle.activitytracking.ActivityScreenMetricsCollector;
import com.dynatrace.android.lifecycle.activitytracking.metrics.ScreenMetrics;
import com.dynatrace.android.lifecycle.activitytracking.metrics.ScreenMetricsListener;
import com.dynatrace.android.lifecycle.callback.ActivityComponentIdentifier;

public class ActiveActivityMonitor
implements ActiveActivityListener,
ScreenMetricsListener {
    private ActiveActivityTracker activityTracker;

    public void startMonitoring(Application application) {
        this.activityTracker = new ActiveActivityTracker(new ActivityComponentIdentifier(), this, new ActivityScreenMetricsCollector(), this);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityTracker);
    }

    public void stopMonitoring(Application application) {
        if (this.activityTracker != null) {
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityTracker);
            this.activityTracker = null;
        }
    }

    @Override
    public void onActiveActivityChanged(String currentActivityName) {
        AndroidMetrics metrics = AndroidMetrics.getInstance();
        metrics.setCurrentActivityName(currentActivityName);
    }

    @Override
    public void onScreenMetrics(ScreenMetrics screenMetrics) {
        MetricsCache cache;
        AndroidMetrics metrics = AndroidMetrics.getInstance();
        metrics.updateScreenMetrics(screenMetrics);
        CoreComponent component = CoreComponent.Holder.getInstance();
        if (component != null && null != (cache = component.getMetricsCache())) {
            cache.setScreenMetrics((OneAgentScreenMetrics)screenMetrics);
        }
    }
}

