/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.cookie;

import android.webkit.CookieManager;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

class CookieWriter {
    private static final String LOG_TAG = Global.LOG_PREFIX + "CookieWriter";
    private CookieManager cookieManager;

    CookieWriter(boolean fileDomainCookiesEnabled) {
        this.init(fileDomainCookiesEnabled);
    }

    private void init(boolean fileDomainCookiesEnabled) {
        block4: {
            try {
                if (fileDomainCookiesEnabled) {
                    CookieManager.setAcceptFileSchemeCookies((boolean)true);
                }
                if (!CookieManager.getInstance().acceptCookie()) {
                    CookieManager.getInstance().setAcceptCookie(true);
                }
                this.cookieManager = CookieManager.getInstance();
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block4;
                Utility.zlogE((String)LOG_TAG, (String)"unable to access CookieManager", (Throwable)e);
            }
        }
    }

    void writeCookies(Set<String> domains, Collection<String> cookies, boolean secure) {
        if (this.cookieManager == null) {
            return;
        }
        if (Global.DEBUG) {
            Utility.zlogD((String)LOG_TAG, (String)("domains: " + domains.toString()));
            Utility.zlogD((String)LOG_TAG, (String)("cookies: " + cookies.toString()));
        }
        for (String domain : domains) {
            for (String cookie : cookies) {
                this.cookieManager.setCookie(domain, secure ? cookie + "; secure" : cookie);
            }
        }
        this.cookieManager.flush();
    }

    void removeCookies(Set<String> domains, Collection<String> cookieNames) {
        ArrayList<String> cookies = new ArrayList<String>();
        for (String domain : domains) {
            for (String cookieName : cookieNames) {
                cookies.add(cookieName + "=; Max-Age=-1");
            }
        }
        this.cookieManager.flush();
        this.writeCookies(domains, cookies, false);
    }
}

