/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.compose.pager;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.measurement.MeasurementProvider;
import com.dynatrace.android.agent.measurement.MeasurementProviderImpl;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.compose.SemanticsManager;
import com.dynatrace.android.compose.pager.PagerActionRecorder;
import com.dynatrace.android.compose.pager.PagerInfo;
import com.dynatrace.android.useraction.UserActionFactory;
import com.dynatrace.android.useraction.UserActionFactoryImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/dynatrace/android/compose/pager/PageChangedCallback;", "", "modifier", "Landroidx/compose/ui/Modifier;", "orientation", "Landroidx/compose/foundation/gestures/Orientation;", "useSemantics", "", "<init>", "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/gestures/Orientation;Z)V", "tag", "", "invoke", "", "currentPage", "", "previousPage", "agent.instrumentorAPI.compose_release"})
@StabilityInferred(parameters=1)
public final class PageChangedCallback {
    @NotNull
    private final Modifier modifier;
    @NotNull
    private final Orientation orientation;
    private final boolean useSemantics;
    @NotNull
    private final String tag;
    public static final int $stable;

    public PageChangedCallback(@NotNull Modifier modifier, @NotNull Orientation orientation, boolean useSemantics) {
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)orientation, (String)"orientation");
        this.modifier = modifier;
        this.orientation = orientation;
        this.useSemantics = useSemantics;
        this.tag = Global.LOG_PREFIX + "PageChangedCallback";
    }

    public final void invoke(int currentPage, int previousPage) {
        if (Global.isAlive.get()) {
            MeasurementProviderImpl measurementProvider = new MeasurementProviderImpl(TimeLineProvider.GLOBAL_TIME_LINE_PROVIDER);
            UserActionFactoryImpl userActionFactory = new UserActionFactoryImpl();
            PagerInfo pagerInfo = new PagerInfo(currentPage, previousPage, this.orientation);
            if (Global.DEBUG) {
                Utility.zlogD((String)this.tag, (String)("onUA: " + pagerInfo));
            }
            new PagerActionRecorder((MeasurementProvider)measurementProvider, (UserActionFactory)userActionFactory, pagerInfo, SemanticsManager.INSTANCE.fetchSemanticsNameFromModifier(this.modifier), this.useSemantics).recordAction();
        }
    }
}

