/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.internal.api;

import android.animation.Animator;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.animation.Animation;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.CompoundButton;
import android.widget.ListAdapter;
import android.widget.RadioGroup;
import com.dynatrace.android.agent.Version;
import com.dynatrace.android.internal.api.ProcessAnalyzer;
import com.dynatrace.android.internal.api.SessionReplayVersion;
import com.dynatrace.android.sessionreplay.core.manager.SessionReplayServiceManager;
import com.dynatrace.android.sessionreplay.tracking.TrackingManager;
import com.dynatrace.android.sessionreplay.tracking.model.UIContainer;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J4\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J4\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J\u0012\u0010\u0015\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\u0016\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u001c\u0010\u0017\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007J\u001c\u0010\u001a\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007J\u001c\u0010\u001a\u001a\u00020\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010\u001d\u001a\u0004\u0018\u00010!H\u0007J\u001c\u0010\"\u001a\u00020\u00042\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J\u001c\u0010'\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0007J\u0010\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.H\u0007J\u0012\u0010/\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010)H\u0007\u00a8\u00060"}, d2={"Lcom/dynatrace/android/internal/api/InstrumentorApi;", "", "()V", "fragmentViewCreated", "", "fragment", "view", "Landroid/view/View;", "bundle", "Landroid/os/Bundle;", "onCreateFragmentAnimation", "Landroid/view/animation/Animation;", "transit", "", "enter", "", "nextAnim", "context", "Landroid/content/Context;", "onCreateFragmentAnimator", "Landroid/animation/Animator;", "onNavigationDrawerClosed", "onNavigationDrawerOpened", "setAdapter", "adapter", "Landroid/widget/ListAdapter;", "setOnCheckedChangedListener", "compoundButton", "Landroid/widget/CompoundButton;", "onCheckedChangeListener", "Landroid/widget/CompoundButton$OnCheckedChangeListener;", "radioGroup", "Landroid/widget/RadioGroup;", "Landroid/widget/RadioGroup$OnCheckedChangeListener;", "setOnScrollListener", "listView", "Landroid/widget/AbsListView;", "listener", "Landroid/widget/AbsListView$OnScrollListener;", "setWebViewClient", "webView", "Landroid/webkit/WebView;", "client", "Landroid/webkit/WebViewClient;", "startReplayProcess", "application", "Landroid/app/Application;", "trackWebView", "api_release"})
public final class InstrumentorApi {
    @NotNull
    public static final InstrumentorApi INSTANCE = new InstrumentorApi();

    private InstrumentorApi() {
    }

    @JvmStatic
    public static final void startReplayProcess(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        if (!Intrinsics.areEqual((Object)Version.getFullVersion(), (Object)SessionReplayVersion.getFullVersion())) {
            Log.d((String)"dtxSessionReplay", (String)("Versions incompatible: Agent version " + Version.getFullVersion() + " with SessionReplay version " + SessionReplayVersion.getFullVersion()));
            return;
        }
        if (new ProcessAnalyzer().isInternalProcess()) {
            SessionReplayServiceManager.INSTANCE.start(application);
            return;
        }
    }

    @JvmStatic
    public static final void fragmentViewCreated(@NotNull Object fragment, @Nullable View view, @Nullable Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        if (view != null) {
            TrackingManager.INSTANCE.getInterceptionApi().instrumentFragmentView(fragment, view);
        }
    }

    @JvmStatic
    @Nullable
    public static final Animation onCreateFragmentAnimation(@NotNull Object fragment, int transit, boolean enter, int nextAnim, @Nullable Context context) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        if (context == null) {
            return null;
        }
        return TrackingManager.INSTANCE.getInterceptionApi().instrumentFragmentAnimation(fragment, transit, enter, nextAnim, context);
    }

    @JvmStatic
    @Nullable
    public static final Animator onCreateFragmentAnimator(@NotNull Object fragment, int transit, boolean enter, int nextAnim, @Nullable Context context) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        if (context == null) {
            return null;
        }
        return TrackingManager.INSTANCE.getInterceptionApi().instrumentFragmentAnimator(fragment, transit, enter, nextAnim, context);
    }

    @JvmStatic
    public static final void setOnScrollListener(@Nullable AbsListView listView, @Nullable AbsListView.OnScrollListener listener) {
        TrackingManager.INSTANCE.getInterceptionApi().instrumentScrollListener(listView, listener);
    }

    @JvmStatic
    public static final void trackWebView(@Nullable WebView webView) {
        if (webView != null) {
            TrackingManager.INSTANCE.getInterceptionApi().instrumentWebView(webView);
        }
    }

    @JvmStatic
    public static final void setWebViewClient(@Nullable WebView webView, @Nullable WebViewClient client) {
        if (webView != null && client != null) {
            TrackingManager.INSTANCE.getInterceptionApi().instrumentWebView(webView, client);
        }
    }

    @JvmStatic
    public static final void setAdapter(@Nullable View view, @Nullable ListAdapter adapter) {
        if (view != null && adapter != null) {
            TrackingManager.INSTANCE.getInterceptionApi().instrumentTableReload(view, (Adapter)adapter);
        }
    }

    @JvmStatic
    public static final void setOnCheckedChangedListener(@Nullable RadioGroup radioGroup, @Nullable RadioGroup.OnCheckedChangeListener onCheckedChangeListener) {
        TrackingManager.INSTANCE.getInterceptionApi().instrumentRadioGroupListener(radioGroup, onCheckedChangeListener);
    }

    @JvmStatic
    public static final void setOnCheckedChangedListener(@Nullable CompoundButton compoundButton, @Nullable CompoundButton.OnCheckedChangeListener onCheckedChangeListener) {
        TrackingManager.INSTANCE.getInterceptionApi().instrumentCompoundButtonListener(compoundButton, onCheckedChangeListener);
    }

    @JvmStatic
    public static final void onNavigationDrawerOpened(@Nullable View view) {
        if (view != null) {
            TrackingManager.INSTANCE.getTrackingApi().trackNavigationDrawerOpened((UIContainer)new UIView(view, null, null, 6, null));
        }
    }

    @JvmStatic
    public static final void onNavigationDrawerClosed(@Nullable View view) {
        if (view != null) {
            TrackingManager.INSTANCE.getTrackingApi().trackNavigationDrawerClosed((UIContainer)new UIView(view, null, null, 6, null));
        }
    }
}

