/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.internal.api;

import android.animation.Animator;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.animation.Animation;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.CompoundButton;
import android.widget.ListAdapter;
import android.widget.RadioGroup;
import com.dynatrace.android.agent.Version;
import com.dynatrace.android.internal.api.ProcessAnalyzer;
import com.dynatrace.android.internal.api.SessionReplayVersion;
import com.dynatrace.android.sessionreplay.core.manager.SessionReplayServiceManager;
import com.dynatrace.android.sessionreplay.tracking.TrackingManager;
import com.dynatrace.android.sessionreplay.tracking.model.UIContainer;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J$\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J4\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J4\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J\u001c\u0010\u0019\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0007J\u0012\u0010\u001e\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0007J\u001c\u0010!\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0007J\u001c\u0010$\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J\u001c\u0010'\u001a\u00020\u00052\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0007J\u001c\u0010'\u001a\u00020\u00052\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010*\u001a\u0004\u0018\u00010.H\u0007J\u0012\u0010/\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0012\u00100\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007\u00a8\u00061"}, d2={"Lcom/dynatrace/android/internal/api/InstrumentorApi;", "", "<init>", "()V", "startReplayProcess", "", "application", "Landroid/app/Application;", "fragmentViewCreated", "fragment", "view", "Landroid/view/View;", "bundle", "Landroid/os/Bundle;", "onCreateFragmentAnimation", "Landroid/view/animation/Animation;", "transit", "", "enter", "", "nextAnim", "context", "Landroid/content/Context;", "onCreateFragmentAnimator", "Landroid/animation/Animator;", "setOnScrollListener", "listView", "Landroid/widget/AbsListView;", "listener", "Landroid/widget/AbsListView$OnScrollListener;", "trackWebView", "webView", "Landroid/webkit/WebView;", "setWebViewClient", "client", "Landroid/webkit/WebViewClient;", "setAdapter", "adapter", "Landroid/widget/ListAdapter;", "setOnCheckedChangedListener", "radioGroup", "Landroid/widget/RadioGroup;", "onCheckedChangeListener", "Landroid/widget/RadioGroup$OnCheckedChangeListener;", "compoundButton", "Landroid/widget/CompoundButton;", "Landroid/widget/CompoundButton$OnCheckedChangeListener;", "onNavigationDrawerOpened", "onNavigationDrawerClosed", "api_release"})
public final class InstrumentorApi {
    @NotNull
    public static final InstrumentorApi INSTANCE = new InstrumentorApi();

    private InstrumentorApi() {
    }

    @JvmStatic
    public static final void startReplayProcess(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        if (!Intrinsics.areEqual((Object)Version.getFullVersion(), (Object)SessionReplayVersion.getFullVersion())) {
            Log.d((String)"dtxSessionReplay", (String)("Versions incompatible: Agent version " + Version.getFullVersion() + " with SessionReplay version " + SessionReplayVersion.getFullVersion()));
            return;
        }
        if (new ProcessAnalyzer().isInternalProcess()) {
            SessionReplayServiceManager.INSTANCE.start(application);
            return;
        }
    }

    @JvmStatic
    public static final void fragmentViewCreated(@NotNull Object fragment, @Nullable View view, @Nullable Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        if (view != null) {
            TrackingManager.INSTANCE.getInterceptionApi().instrumentFragmentView(fragment, view);
        }
    }

    @JvmStatic
    @Nullable
    public static final Animation onCreateFragmentAnimation(@NotNull Object fragment, int transit, boolean enter, int nextAnim, @Nullable Context context) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        if (context == null) {
            return null;
        }
        return TrackingManager.INSTANCE.getInterceptionApi().instrumentFragmentAnimation(fragment, transit, enter, nextAnim, context);
    }

    @JvmStatic
    @Nullable
    public static final Animator onCreateFragmentAnimator(@NotNull Object fragment, int transit, boolean enter, int nextAnim, @Nullable Context context) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        if (context == null) {
            return null;
        }
        return TrackingManager.INSTANCE.getInterceptionApi().instrumentFragmentAnimator(fragment, transit, enter, nextAnim, context);
    }

    @JvmStatic
    public static final void setOnScrollListener(@Nullable AbsListView listView, @Nullable AbsListView.OnScrollListener listener) {
        TrackingManager.INSTANCE.getInterceptionApi().instrumentScrollListener(listView, listener);
    }

    @JvmStatic
    public static final void trackWebView(@Nullable WebView webView) {
        if (webView != null) {
            TrackingManager.INSTANCE.getInterceptionApi().instrumentWebView(webView);
        }
    }

    @JvmStatic
    public static final void setWebViewClient(@Nullable WebView webView, @Nullable WebViewClient client) {
        if (webView != null && client != null) {
            TrackingManager.INSTANCE.getInterceptionApi().instrumentWebView(webView, client);
        }
    }

    @JvmStatic
    public static final void setAdapter(@Nullable View view, @Nullable ListAdapter adapter) {
        if (view != null && adapter != null) {
            TrackingManager.INSTANCE.getInterceptionApi().instrumentTableReload(view, (Adapter)adapter);
        }
    }

    @JvmStatic
    public static final void setOnCheckedChangedListener(@Nullable RadioGroup radioGroup, @Nullable RadioGroup.OnCheckedChangeListener onCheckedChangeListener) {
        TrackingManager.INSTANCE.getInterceptionApi().instrumentRadioGroupListener(radioGroup, onCheckedChangeListener);
    }

    @JvmStatic
    public static final void setOnCheckedChangedListener(@Nullable CompoundButton compoundButton, @Nullable CompoundButton.OnCheckedChangeListener onCheckedChangeListener) {
        TrackingManager.INSTANCE.getInterceptionApi().instrumentCompoundButtonListener(compoundButton, onCheckedChangeListener);
    }

    @JvmStatic
    public static final void onNavigationDrawerOpened(@Nullable View view) {
        if (view != null) {
            TrackingManager.INSTANCE.getTrackingApi().trackNavigationDrawerOpened((UIContainer)new UIView(view, null, null, 6, null));
        }
    }

    @JvmStatic
    public static final void onNavigationDrawerClosed(@Nullable View view) {
        if (view != null) {
            TrackingManager.INSTANCE.getTrackingApi().trackNavigationDrawerClosed((UIContainer)new UIView(view, null, null, 6, null));
        }
    }
}

