/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.internal.api.recyclerview.interceptor;

import android.view.View;
import android.view.ViewTreeObserver;
import androidx.recyclerview.widget.RecyclerView;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.utils.InterceptionCache;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\n2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\tJL\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0016\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\b2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0010H\u0002R\u001e\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/dynatrace/android/internal/api/recyclerview/interceptor/RecyclerViewReloadInterceptor;", "", "trackingHandler", "Lkotlin/Function1;", "Landroid/view/View;", "", "(Lkotlin/jvm/functions/Function1;)V", "interceptedAdapters", "Lcom/dynatrace/android/sessionreplay/tracking/utils/InterceptionCache;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView;", "intercept", "recyclerView", "adapter", "tableReloadDataChangedHandler", "Lkotlin/Function0;", "Ljava/lang/ref/WeakReference;", "RecyclerViewTableReloadDataSetObserver", "api.androidx_release"})
public final class RecyclerViewReloadInterceptor {
    @NotNull
    private final Function1<View, Unit> trackingHandler;
    @NotNull
    private final InterceptionCache<RecyclerView.Adapter<?>, RecyclerView> interceptedAdapters;

    public RecyclerViewReloadInterceptor(@NotNull Function1<? super View, Unit> trackingHandler) {
        Intrinsics.checkNotNullParameter(trackingHandler, (String)"trackingHandler");
        this.trackingHandler = trackingHandler;
        this.interceptedAdapters = new InterceptionCache();
    }

    public final void intercept(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.Adapter<?> adapter) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        if (this.interceptedAdapters.containsKey(adapter)) {
            return;
        }
        this.interceptedAdapters.set(adapter, (Object)recyclerView);
        Function0<Unit> handler = this.tableReloadDataChangedHandler(this.trackingHandler, this.interceptedAdapters, new WeakReference(adapter));
        adapter.registerAdapterDataObserver((RecyclerView.AdapterDataObserver)new RecyclerViewTableReloadDataSetObserver(handler));
        if (adapter.getItemCount() > 0) {
            DTLogger.INSTANCE.tracking("RecyclerView track: more than 0");
            handler.invoke();
        }
    }

    private final Function0<Unit> tableReloadDataChangedHandler(Function1<? super View, Unit> trackingHandler, InterceptionCache<RecyclerView.Adapter<?>, RecyclerView> interceptedAdapters, WeakReference<RecyclerView.Adapter<?>> adapter) {
        return (Function0)new Function0<Unit>(adapter, interceptedAdapters, trackingHandler){
            final /* synthetic */ WeakReference<RecyclerView.Adapter<?>> $adapter;
            final /* synthetic */ InterceptionCache<RecyclerView.Adapter<?>, RecyclerView> $interceptedAdapters;
            final /* synthetic */ Function1<View, Unit> $trackingHandler;
            {
                this.$adapter = $adapter;
                this.$interceptedAdapters = $interceptedAdapters;
                this.$trackingHandler = $trackingHandler;
                super(0);
            }

            public final void invoke() {
                block1: {
                    RecyclerView.Adapter adapter = (RecyclerView.Adapter)this.$adapter.get();
                    if (adapter == null) break block1;
                    RecyclerView.Adapter adapter2 = adapter;
                    InterceptionCache<RecyclerView.Adapter<?>, RecyclerView> interceptionCache = this.$interceptedAdapters;
                    Function1<View, Unit> function1 = this.$trackingHandler;
                    RecyclerView.Adapter adapter3 = adapter2;
                    boolean bl = false;
                    RecyclerView recyclerView = (RecyclerView)interceptionCache.get((Object)adapter3);
                    if (recyclerView != null) {
                        RecyclerView view = recyclerView;
                        boolean bl2 = false;
                        View $this$afterMeasured$iv = (View)view;
                        boolean $i$f$afterMeasured = false;
                        $this$afterMeasured$iv.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener($this$afterMeasured$iv, view, function1){
                            final /* synthetic */ View $this_afterMeasured;
                            final /* synthetic */ RecyclerView $view$inlined;
                            final /* synthetic */ Function1 $trackingHandler$inlined;
                            {
                                this.$this_afterMeasured = $receiver;
                                this.$view$inlined = recyclerView;
                                this.$trackingHandler$inlined = function1;
                            }

                            public void onGlobalLayout() {
                                if (this.$this_afterMeasured.getMeasuredWidth() > 0 && this.$this_afterMeasured.getMeasuredHeight() > 0) {
                                    this.$this_afterMeasured.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                                    View $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240 = this.$this_afterMeasured;
                                    boolean bl = false;
                                    if (this.$view$inlined.getWidth() > 0 && this.$view$inlined.getHeight() > 0) {
                                        this.$trackingHandler$inlined.invoke((Object)this.$view$inlined);
                                    }
                                }
                            }
                        });
                    }
                }
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0004H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J \u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/dynatrace/android/internal/api/recyclerview/interceptor/RecyclerViewReloadInterceptor$RecyclerViewTableReloadDataSetObserver;", "Landroidx/recyclerview/widget/RecyclerView$AdapterDataObserver;", "trackingHandler", "Lkotlin/Function0;", "", "(Lcom/dynatrace/android/internal/api/recyclerview/interceptor/RecyclerViewReloadInterceptor;Lkotlin/jvm/functions/Function0;)V", "onChanged", "onItemRangeChanged", "positionStart", "", "itemCount", "onItemRangeInserted", "onItemRangeMoved", "fromPosition", "toPosition", "onItemRangeRemoved", "api.androidx_release"})
    private final class RecyclerViewTableReloadDataSetObserver
    extends RecyclerView.AdapterDataObserver {
        @NotNull
        private final Function0<Unit> trackingHandler;

        public RecyclerViewTableReloadDataSetObserver(Function0<Unit> trackingHandler) {
            Intrinsics.checkNotNullParameter(trackingHandler, (String)"trackingHandler");
            this.trackingHandler = trackingHandler;
        }

        public void onChanged() {
            super.onChanged();
            this.trackingHandler.invoke();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            super.onItemRangeChanged(positionStart, itemCount);
            this.trackingHandler.invoke();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            super.onItemRangeInserted(positionStart, itemCount);
            this.trackingHandler.invoke();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            super.onItemRangeRemoved(positionStart, itemCount);
            this.trackingHandler.invoke();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            super.onItemRangeMoved(fromPosition, toPosition, itemCount);
            this.trackingHandler.invoke();
        }
    }
}

