/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.internal.api.compose.handler;

import android.content.Context;
import android.util.Size;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.compose.ui.layout.LayoutInfo;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import com.dynatrace.android.internal.api.compose.handler.CoroutineHandler;
import com.dynatrace.android.internal.api.compose.model.ComposeViewHolderWrapper;
import com.dynatrace.android.internal.api.compose.model.ViewHolder;
import com.dynatrace.android.internal.api.compose.util.ViewUtilsKt;
import com.dynatrace.android.sessionreplay.tracking.TrackingManager;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandlerUtilsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/dynatrace/android/internal/api/compose/handler/DisplayEventHandler;", "Lcom/dynatrace/android/internal/api/compose/handler/CoroutineHandler;", "composeViewHolderWrapper", "Lcom/dynatrace/android/internal/api/compose/model/ComposeViewHolderWrapper;", "(Lcom/dynatrace/android/internal/api/compose/model/ComposeViewHolderWrapper;)V", "lastNavigatorRoute", "", "remeasureDisplayData", "Lcom/dynatrace/android/internal/api/compose/handler/DisplayEventHandler$RemeasureDisplayData;", "onAttachedToWindow", "", "view", "Landroid/view/View;", "layoutInfo", "Landroidx/compose/ui/layout/LayoutInfo;", "onDetachedFromWindow", "onNavControllerNavigate", "navDestination", "Landroidx/navigation/NavDestination;", "onNavControllerPopBackStack", "navBackStackEntry", "Landroidx/navigation/NavBackStackEntry;", "onRequestMeasure", "isLayoutScrollable", "", "isScrolling", "Companion", "RemeasureDisplayData", "api.compose_release"})
@SourceDebugExtension(value={"SMAP\nDisplayEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayEventHandler.kt\ncom/dynatrace/android/internal/api/compose/handler/DisplayEventHandler\n+ 2 ViewExtensions.kt\ncom/dynatrace/android/sessionreplay/tracking/extensions/ViewExtensionsKt\n*L\n1#1,127:1\n29#2,9:128\n*S KotlinDebug\n*F\n+ 1 DisplayEventHandler.kt\ncom/dynatrace/android/internal/api/compose/handler/DisplayEventHandler\n*L\n23#1:128,9\n*E\n"})
public final class DisplayEventHandler
extends CoroutineHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ComposeViewHolderWrapper composeViewHolderWrapper;
    @NotNull
    private RemeasureDisplayData remeasureDisplayData;
    @NotNull
    private String lastNavigatorRoute;
    @Deprecated
    public static final long NAVIGATION_DELAY = 850L;
    @Deprecated
    public static final long MEASURE_DELAY = 200L;
    @Deprecated
    public static final double MEASURE_HEIGHT_MULTIPLIER = 0.9;

    public DisplayEventHandler(@NotNull ComposeViewHolderWrapper composeViewHolderWrapper) {
        Intrinsics.checkNotNullParameter((Object)composeViewHolderWrapper, (String)"composeViewHolderWrapper");
        this.composeViewHolderWrapper = composeViewHolderWrapper;
        this.remeasureDisplayData = new RemeasureDisplayData(false, null, 0, 0, null, 31, null);
        this.lastNavigatorRoute = "";
    }

    public final void onAttachedToWindow(@NotNull View view, @NotNull LayoutInfo layoutInfo) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        View $this$afterMeasured$iv = view;
        boolean $i$f$afterMeasured = false;
        $this$afterMeasured$iv.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener($this$afterMeasured$iv, view, this, layoutInfo){
            final /* synthetic */ View $this_afterMeasured;
            final /* synthetic */ View $view$inlined;
            final /* synthetic */ DisplayEventHandler this$0;
            final /* synthetic */ LayoutInfo $layoutInfo$inlined;
            {
                this.$this_afterMeasured = $receiver;
                this.$view$inlined = view;
                this.this$0 = displayEventHandler;
                this.$layoutInfo$inlined = layoutInfo;
            }

            public void onGlobalLayout() {
                if (this.$this_afterMeasured.getMeasuredWidth() > 0 && this.$this_afterMeasured.getMeasuredHeight() > 0) {
                    this.$this_afterMeasured.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    View $this$onAttachedToWindow_u24lambda_u241 = this.$this_afterMeasured;
                    boolean bl = false;
                    View rootView = this.$view$inlined.getRootView();
                    if (Intrinsics.areEqual((Object)rootView.getClass().getSimpleName(), (Object)"DecorView")) {
                        ComposeViewHolderWrapper composeViewHolderWrapper = DisplayEventHandler.access$getComposeViewHolderWrapper$p(this.this$0);
                        Intrinsics.checkNotNull((Object)rootView);
                        composeViewHolderWrapper.attachComposeViewHolder(rootView, ScreenshotHandlerUtilsKt.getWindow((View)this.$view$inlined), this.$layoutInfo$inlined);
                    }
                    RemeasureDisplayData $this$onAttachedToWindow_u24lambda_u241_u24lambda_u240 = DisplayEventHandler.access$getRemeasureDisplayData$p(this.this$0);
                    boolean bl2 = false;
                    $this$onAttachedToWindow_u24lambda_u241_u24lambda_u240.setAllowRemeasureDisplays(true);
                    Context context = this.$view$inlined.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                    Size resolution = ViewUtilsKt.getDeviceResolution(context);
                    $this$onAttachedToWindow_u24lambda_u241_u24lambda_u240.setSizeThreshold(new Size(resolution.getWidth(), (int)((double)resolution.getHeight() * 0.9)));
                    $this$onAttachedToWindow_u24lambda_u241_u24lambda_u240.setCurrentAndroidComposeView(this.$view$inlined.hashCode());
                }
            }
        });
    }

    public final void onDetachedFromWindow(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        View view2 = view.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getRootView(...)");
        this.composeViewHolderWrapper.detachComposeViewHolder(view2);
    }

    public final void onNavControllerNavigate(@NotNull NavDestination navDestination) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)navDestination, (String)"navDestination");
            String string = navDestination.getRoute();
            if (string == null) break block1;
            String routeName = string;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)this.lastNavigatorRoute, (Object)routeName)) {
                return;
            }
            this.remeasureDisplayData.setAllowRemeasureDisplays(false);
            this.lastNavigatorRoute = routeName;
            this.launchWithDelay(850L, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ DisplayEventHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    block0: {
                        ViewHolder viewHolder = DisplayEventHandler.access$getComposeViewHolderWrapper$p(this.this$0).getLast();
                        if (viewHolder == null) break block0;
                        ViewHolder viewHolder2 = viewHolder;
                        DisplayEventHandler displayEventHandler = this.this$0;
                        ViewHolder viewHolder3 = viewHolder2;
                        boolean bl = false;
                        TrackingManager.INSTANCE.getTrackingApi().trackComposeDisplay(viewHolder3.getView(), viewHolder3.getWindow());
                        RemeasureDisplayData $this$invoke_u24lambda_u241_u24lambda_u240 = DisplayEventHandler.access$getRemeasureDisplayData$p(displayEventHandler);
                        boolean bl2 = false;
                        $this$invoke_u24lambda_u241_u24lambda_u240.setAllowRemeasureDisplays(true);
                        $this$invoke_u24lambda_u241_u24lambda_u240.setLastKnownAndroidComposeView(DisplayEventHandler.access$getRemeasureDisplayData$p(displayEventHandler).getCurrentAndroidComposeView());
                    }
                }
            }));
        }
    }

    public final void onNavControllerPopBackStack(@NotNull NavBackStackEntry navBackStackEntry) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)navBackStackEntry, (String)"navBackStackEntry");
            Object object = navBackStackEntry.getDestination().getParent();
            if (object == null || (object = object.getStartDestinationRoute()) == null) break block1;
            Object routeName = object;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)this.lastNavigatorRoute, (Object)routeName)) {
                return;
            }
            this.remeasureDisplayData.setAllowRemeasureDisplays(false);
            this.lastNavigatorRoute = routeName;
            this.launchWithDelay(850L, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ DisplayEventHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    block0: {
                        ViewHolder viewHolder = DisplayEventHandler.access$getComposeViewHolderWrapper$p(this.this$0).getLast();
                        if (viewHolder == null) break block0;
                        ViewHolder viewHolder2 = viewHolder;
                        DisplayEventHandler displayEventHandler = this.this$0;
                        ViewHolder viewHolder3 = viewHolder2;
                        boolean bl = false;
                        TrackingManager.INSTANCE.getTrackingApi().trackComposeDisplay(viewHolder3.getView(), viewHolder3.getWindow());
                        RemeasureDisplayData $this$invoke_u24lambda_u241_u24lambda_u240 = DisplayEventHandler.access$getRemeasureDisplayData$p(displayEventHandler);
                        boolean bl2 = false;
                        $this$invoke_u24lambda_u241_u24lambda_u240.setAllowRemeasureDisplays(true);
                        $this$invoke_u24lambda_u241_u24lambda_u240.setLastKnownAndroidComposeView(DisplayEventHandler.access$getRemeasureDisplayData$p(displayEventHandler).getCurrentAndroidComposeView());
                    }
                }
            }));
        }
    }

    public final void onRequestMeasure(@NotNull LayoutInfo layoutInfo, boolean isLayoutScrollable, boolean isScrolling) {
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        if (isScrolling || isLayoutScrollable) {
            return;
        }
        RemeasureDisplayData $this$onRequestMeasure_u24lambda_u244 = this.remeasureDisplayData;
        boolean bl = false;
        if (!$this$onRequestMeasure_u24lambda_u244.getAllowRemeasureDisplays()) {
            return;
        }
        if (layoutInfo.getWidth() == $this$onRequestMeasure_u24lambda_u244.getSizeThreshold().getWidth() && layoutInfo.getHeight() >= $this$onRequestMeasure_u24lambda_u244.getSizeThreshold().getHeight()) {
            Job job = $this$onRequestMeasure_u24lambda_u244.getMeasuringJob();
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            $this$onRequestMeasure_u24lambda_u244.setMeasuringJob(this.launchWithDelay(200L, (Function0<Unit>)((Function0)new Function0<Unit>($this$onRequestMeasure_u24lambda_u244, this){
                final /* synthetic */ RemeasureDisplayData $this_with;
                final /* synthetic */ DisplayEventHandler this$0;
                {
                    this.$this_with = $receiver;
                    this.this$0 = $receiver2;
                    super(0);
                }

                public final void invoke() {
                    if (this.$this_with.getAllowRemeasureDisplays() && this.$this_with.getCurrentAndroidComposeView() == this.$this_with.getLastKnownAndroidComposeView()) {
                        ViewHolder viewHolder = DisplayEventHandler.access$getComposeViewHolderWrapper$p(this.this$0).getLast();
                        if (viewHolder != null) {
                            ViewHolder viewHolder2 = viewHolder;
                            boolean bl = false;
                            TrackingManager.INSTANCE.getTrackingApi().trackComposeDisplay(viewHolder2.getView(), viewHolder2.getWindow());
                        }
                    }
                    this.$this_with.setLastKnownAndroidComposeView(this.$this_with.getCurrentAndroidComposeView());
                }
            })));
        }
    }

    public static final /* synthetic */ ComposeViewHolderWrapper access$getComposeViewHolderWrapper$p(DisplayEventHandler $this) {
        return $this.composeViewHolderWrapper;
    }

    public static final /* synthetic */ RemeasureDisplayData access$getRemeasureDisplayData$p(DisplayEventHandler $this) {
        return $this.remeasureDisplayData;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/dynatrace/android/internal/api/compose/handler/DisplayEventHandler$Companion;", "", "()V", "MEASURE_DELAY", "", "MEASURE_HEIGHT_MULTIPLIER", "", "NAVIGATION_DELAY", "api.compose_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0002\u0018\u00002\u00020\u0001B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/dynatrace/android/internal/api/compose/handler/DisplayEventHandler$RemeasureDisplayData;", "", "allowRemeasureDisplays", "", "sizeThreshold", "Landroid/util/Size;", "currentAndroidComposeView", "", "lastKnownAndroidComposeView", "measuringJob", "Lkotlinx/coroutines/Job;", "(ZLandroid/util/Size;IILkotlinx/coroutines/Job;)V", "getAllowRemeasureDisplays", "()Z", "setAllowRemeasureDisplays", "(Z)V", "getCurrentAndroidComposeView", "()I", "setCurrentAndroidComposeView", "(I)V", "getLastKnownAndroidComposeView", "setLastKnownAndroidComposeView", "getMeasuringJob", "()Lkotlinx/coroutines/Job;", "setMeasuringJob", "(Lkotlinx/coroutines/Job;)V", "getSizeThreshold", "()Landroid/util/Size;", "setSizeThreshold", "(Landroid/util/Size;)V", "api.compose_release"})
    private static final class RemeasureDisplayData {
        private boolean allowRemeasureDisplays;
        @NotNull
        private Size sizeThreshold;
        private int currentAndroidComposeView;
        private int lastKnownAndroidComposeView;
        @Nullable
        private Job measuringJob;

        public RemeasureDisplayData(boolean allowRemeasureDisplays, @NotNull Size sizeThreshold, int currentAndroidComposeView, int lastKnownAndroidComposeView, @Nullable Job measuringJob) {
            Intrinsics.checkNotNullParameter((Object)sizeThreshold, (String)"sizeThreshold");
            this.allowRemeasureDisplays = allowRemeasureDisplays;
            this.sizeThreshold = sizeThreshold;
            this.currentAndroidComposeView = currentAndroidComposeView;
            this.lastKnownAndroidComposeView = lastKnownAndroidComposeView;
            this.measuringJob = measuringJob;
        }

        public /* synthetic */ RemeasureDisplayData(boolean bl, Size size, int n, int n2, Job job, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                bl = false;
            }
            if ((n3 & 2) != 0) {
                size = new Size(0, 0);
            }
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            if ((n3 & 0x10) != 0) {
                job = null;
            }
            this(bl, size, n, n2, job);
        }

        public final boolean getAllowRemeasureDisplays() {
            return this.allowRemeasureDisplays;
        }

        public final void setAllowRemeasureDisplays(boolean bl) {
            this.allowRemeasureDisplays = bl;
        }

        @NotNull
        public final Size getSizeThreshold() {
            return this.sizeThreshold;
        }

        public final void setSizeThreshold(@NotNull Size size) {
            Intrinsics.checkNotNullParameter((Object)size, (String)"<set-?>");
            this.sizeThreshold = size;
        }

        public final int getCurrentAndroidComposeView() {
            return this.currentAndroidComposeView;
        }

        public final void setCurrentAndroidComposeView(int n) {
            this.currentAndroidComposeView = n;
        }

        public final int getLastKnownAndroidComposeView() {
            return this.lastKnownAndroidComposeView;
        }

        public final void setLastKnownAndroidComposeView(int n) {
            this.lastKnownAndroidComposeView = n;
        }

        @Nullable
        public final Job getMeasuringJob() {
            return this.measuringJob;
        }

        public final void setMeasuringJob(@Nullable Job job) {
            this.measuringJob = job;
        }

        public RemeasureDisplayData() {
            this(false, null, 0, 0, null, 31, null);
        }
    }
}

