/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.internal.api.compose17.handler;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutInfo;
import androidx.compose.ui.layout.ModifierInfo;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.input.TextFieldValue;
import com.dynatrace.android.internal.api.compose.InstrumentorComposeApi;
import com.dynatrace.android.internal.api.compose.model.ViewHolder;
import com.dynatrace.android.internal.api.compose17.model.DTInputTextModifier;
import com.dynatrace.android.internal.api.compose17.model.DTLayoutInfoNode;
import com.dynatrace.android.sessionreplay.tracking.TrackingManager;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\"\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/dynatrace/android/internal/api/compose17/handler/InputTextHandler;", "", "()V", "textInputValuesMap", "", "", "", "onAttach", "", "layoutInfo", "Landroidx/compose/ui/layout/LayoutInfo;", "onDetach", "onTextFieldStateFocus", "coordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "annotatedString", "Landroidx/compose/ui/text/AnnotatedString;", "focused", "", "onTextFieldValueChange", "input", "Landroidx/compose/ui/text/input/TextFieldValue;", "modifier", "Landroidx/compose/ui/Modifier;", "api.compose17_release"})
@SourceDebugExtension(value={"SMAP\nInputTextHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputTextHandler.kt\ncom/dynatrace/android/internal/api/compose17/handler/InputTextHandler\n+ 2 ComposeUtils.kt\ncom/dynatrace/android/internal/api/compose/util/ComposeUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n14#2,2:72\n16#2:75\n1#3:74\n*S KotlinDebug\n*F\n+ 1 InputTextHandler.kt\ncom/dynatrace/android/internal/api/compose17/handler/InputTextHandler\n*L\n18#1:72,2\n18#1:75\n18#1:74\n*E\n"})
public final class InputTextHandler {
    @NotNull
    private Map<Integer, String> textInputValuesMap = new LinkedHashMap();

    public final void onAttach(@NotNull LayoutInfo layoutInfo) {
        block6: {
            DTInputTextModifier dTInputTextModifier;
            Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
            LayoutInfo $this$getModifierOrNull$iv = layoutInfo;
            boolean $i$f$getModifierOrNull = false;
            try {
                Object v0;
                block5: {
                    for (Object t : (Iterable)$this$getModifierOrNull$iv.getModifierInfo()) {
                        ModifierInfo it$iv = (ModifierInfo)t;
                        boolean bl = false;
                        if (!(it$iv.getModifier() instanceof DTInputTextModifier)) continue;
                        v0 = t;
                        break block5;
                    }
                    v0 = null;
                }
                ModifierInfo modifierInfo = v0;
                Object object = modifierInfo != null ? modifierInfo.getModifier() : null;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.dynatrace.android.internal.api.compose17.model.DTInputTextModifier");
                }
                dTInputTextModifier = (DTInputTextModifier)((Object)object);
            }
            catch (Exception e$iv) {
                dTInputTextModifier = null;
            }
            DTInputTextModifier dTInputTextModifier2 = dTInputTextModifier;
            if (dTInputTextModifier2 == null) break block6;
            DTInputTextModifier modifier = dTInputTextModifier2;
            boolean bl = false;
            DTLayoutInfoNode dTLayoutInfoNode = modifier.getCompoundNode();
            if (dTLayoutInfoNode != null) {
                dTLayoutInfoNode.setLayoutInfo(layoutInfo);
            }
        }
    }

    public final void onDetach(@NotNull LayoutInfo layoutInfo) {
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        if (this.textInputValuesMap.keySet().contains(layoutInfo.getSemanticsId())) {
            this.textInputValuesMap.remove(layoutInfo.getSemanticsId());
        }
    }

    public final void onTextFieldValueChange(@NotNull TextFieldValue input, @NotNull Modifier modifier) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        ViewHolder viewHolder = InstrumentorComposeApi.INSTANCE.getComposeViewHolder();
        if (viewHolder == null) {
            return;
        }
        ViewHolder viewHolder2 = viewHolder;
        String inputText = input.getText();
        modifier.foldIn((Object)Unit.INSTANCE, (Function2)new Function2<Unit, Modifier.Element, Unit>(this, inputText, viewHolder2){
            final /* synthetic */ InputTextHandler this$0;
            final /* synthetic */ String $inputText;
            final /* synthetic */ ViewHolder $viewHolder;
            {
                this.this$0 = $receiver;
                this.$inputText = $inputText;
                this.$viewHolder = $viewHolder;
                super(2);
            }

            public final void invoke(@NotNull Unit unit, @NotNull Modifier.Element element) {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)unit, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (!(element instanceof DTInputTextModifier)) break block3;
                    DTLayoutInfoNode dTLayoutInfoNode = ((DTInputTextModifier)element).getCompoundNode();
                    if (dTLayoutInfoNode != null && (dTLayoutInfoNode = dTLayoutInfoNode.getLayoutInfo()) != null) {
                        LayoutCoordinates layoutCoordinates;
                        DTLayoutInfoNode dTLayoutInfoNode2 = dTLayoutInfoNode;
                        InputTextHandler inputTextHandler = this.this$0;
                        String string = this.$inputText;
                        ViewHolder viewHolder = this.$viewHolder;
                        DTLayoutInfoNode layoutInfo = dTLayoutInfoNode2;
                        boolean bl = false;
                        String storedValue = (String)InputTextHandler.access$getTextInputValuesMap$p(inputTextHandler).get(layoutInfo.getSemanticsId());
                        InputTextHandler.access$getTextInputValuesMap$p(inputTextHandler).put(layoutInfo.getSemanticsId(), string);
                        if (storedValue == null || Intrinsics.areEqual((Object)storedValue, (Object)string)) {
                            return;
                        }
                        LayoutCoordinates it = layoutCoordinates = layoutInfo.getCoordinates();
                        boolean bl2 = false;
                        Object object = it.isAttached() ? layoutCoordinates : null;
                        if (object != null) {
                            LayoutCoordinates coordinates = object;
                            boolean bl3 = false;
                            TrackingManager.INSTANCE.getTrackingApi().trackInputKeystroke(string, coordinates, viewHolder.getView(), viewHolder.getWindow());
                        }
                    }
                }
            }
        });
    }

    public final void onTextFieldStateFocus(@Nullable LayoutCoordinates coordinates, @Nullable AnnotatedString annotatedString, boolean focused) {
        Object object = annotatedString;
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        Object text = object;
        ViewHolder viewHolder = InstrumentorComposeApi.INSTANCE.getComposeViewHolder();
        if (viewHolder == null) {
            return;
        }
        ViewHolder viewHolder2 = viewHolder;
        TrackingManager.INSTANCE.getTrackingApi().trackInputFocus((String)text, coordinates, viewHolder2.getView(), viewHolder2.getWindow(), focused);
    }

    public static final /* synthetic */ Map access$getTextInputValuesMap$p(InputTextHandler $this) {
        return $this.textInputValuesMap;
    }
}

