/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.internal.api.compose.util;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Size;
import android.view.Display;
import android.view.WindowManager;
import android.view.WindowMetrics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"getDeviceResolution", "Landroid/util/Size;", "context", "Landroid/content/Context;", "api.compose_release"})
public final class ViewUtilsKt {
    @NotNull
    public static final Size getDeviceResolution(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        WindowManager windowManager = (WindowManager)object;
        if (Build.VERSION.SDK_INT <= 29) {
            Display display = windowManager.getDefaultDisplay();
            DisplayMetrics displayMetrics = new DisplayMetrics();
            display.getRealMetrics(displayMetrics);
            return new Size(displayMetrics.widthPixels, displayMetrics.heightPixels);
        }
        WindowMetrics windowMetrics = windowManager.getCurrentWindowMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"getCurrentWindowMetrics(...)");
        WindowMetrics windowMetrics2 = windowMetrics;
        return new Size(windowMetrics2.getBounds().width(), windowMetrics2.getBounds().height());
    }
}

