/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.internal.api.compose15.handler;

import androidx.compose.ui.layout.LayoutInfo;
import androidx.compose.ui.layout.ModifierInfo;
import com.dynatrace.android.internal.api.compose.InstrumentorComposeApi;
import com.dynatrace.android.internal.api.compose.handler.CoroutineHandler;
import com.dynatrace.android.internal.api.compose.model.ViewHolder;
import com.dynatrace.android.internal.api.compose.util.ComposeUtilsKt;
import com.dynatrace.android.internal.api.compose15.handler.ScrollStatusProvider;
import com.dynatrace.android.internal.api.compose15.model.DTLayoutInfoNode;
import com.dynatrace.android.internal.api.compose15.model.DTTableModifier;
import com.dynatrace.android.sessionreplay.tracking.TrackingManager;
import com.dynatrace.android.sessionreplay.tracking.model.UIComposeView;
import com.dynatrace.android.sessionreplay.tracking.model.UIContainer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0010*\u00020\u0010H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0010H\u0002R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/dynatrace/android/internal/api/compose15/handler/TableReloadHandler;", "Lcom/dynatrace/android/internal/api/compose/handler/CoroutineHandler;", "scrollStatusProvider", "Lcom/dynatrace/android/internal/api/compose15/handler/ScrollStatusProvider;", "(Lcom/dynatrace/android/internal/api/compose15/handler/ScrollStatusProvider;)V", "pendingTableTracking", "", "", "Lcom/dynatrace/android/internal/api/compose/util/ScrollableId;", "recomposedTablesTimestamps", "", "", "tableIds", "dispatchOnPositionedCallbacks", "", "layoutInfo", "Landroidx/compose/ui/layout/LayoutInfo;", "getRecentlyMeasuredTables", "onAttach", "onDetach", "onRecomposedTable", "getRecomposedLayout", "isTracking", "", "Companion", "api.compose15_release"})
@SourceDebugExtension(value={"SMAP\nTableReloadHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableReloadHandler.kt\ncom/dynatrace/android/internal/api/compose15/handler/TableReloadHandler\n+ 2 ComposeUtils.kt\ncom/dynatrace/android/internal/api/compose/util/ComposeUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,104:1\n14#2,2:105\n16#2:108\n1#3:107\n526#4:109\n511#4,6:110\n*S KotlinDebug\n*F\n+ 1 TableReloadHandler.kt\ncom/dynatrace/android/internal/api/compose15/handler/TableReloadHandler\n*L\n28#1:105,2\n28#1:108\n28#1:107\n93#1:109\n93#1:110,6\n*E\n"})
public final class TableReloadHandler
extends CoroutineHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ScrollStatusProvider scrollStatusProvider;
    @NotNull
    private final Set<Integer> tableIds;
    @NotNull
    private Map<Integer, Long> recomposedTablesTimestamps;
    @NotNull
    private final Set<Integer> pendingTableTracking;
    @Deprecated
    public static final long TABLE_RELOAD_EVENT_DELAY_MILLIS = 850L;
    @Deprecated
    public static final long RECENT_MEASUREMENT_MILLIS = 100L;

    public TableReloadHandler(@NotNull ScrollStatusProvider scrollStatusProvider2) {
        Intrinsics.checkNotNullParameter((Object)scrollStatusProvider2, (String)"scrollStatusProvider");
        this.scrollStatusProvider = scrollStatusProvider2;
        this.tableIds = new LinkedHashSet();
        this.recomposedTablesTimestamps = new LinkedHashMap();
        this.pendingTableTracking = new LinkedHashSet();
    }

    public final void onAttach(@NotNull LayoutInfo layoutInfo) {
        block7: {
            DTTableModifier dTTableModifier;
            Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
            if (this.scrollStatusProvider.isScrolling() || this.isTracking(layoutInfo) || this.tableIds.contains(layoutInfo.getSemanticsId())) {
                return;
            }
            LayoutInfo $this$getModifierOrNull$iv = layoutInfo;
            boolean $i$f$getModifierOrNull = false;
            try {
                Object v0;
                block6: {
                    for (Object t : (Iterable)$this$getModifierOrNull$iv.getModifierInfo()) {
                        ModifierInfo it$iv = (ModifierInfo)t;
                        boolean bl = false;
                        if (!(it$iv.getModifier() instanceof DTTableModifier)) continue;
                        v0 = t;
                        break block6;
                    }
                    v0 = null;
                }
                ModifierInfo modifierInfo = v0;
                Object object = modifierInfo != null ? modifierInfo.getModifier() : null;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.dynatrace.android.internal.api.compose15.model.DTTableModifier");
                }
                dTTableModifier = (DTTableModifier)((Object)object);
            }
            catch (Exception e$iv) {
                dTTableModifier = null;
            }
            DTTableModifier dTTableModifier2 = dTTableModifier;
            if (dTTableModifier2 == null) break block7;
            DTTableModifier dtTableModifier = dTTableModifier2;
            boolean bl = false;
            DTLayoutInfoNode dTLayoutInfoNode = dtTableModifier.getCurrentNode();
            if (dTLayoutInfoNode != null) {
                dTLayoutInfoNode.setLayoutInfo(layoutInfo);
            }
            this.tableIds.add(layoutInfo.getSemanticsId());
            this.pendingTableTracking.add(layoutInfo.getSemanticsId());
            this.launchWithDelay(850L, (Function0)new Function0<Unit>(this, layoutInfo){
                final /* synthetic */ TableReloadHandler this$0;
                final /* synthetic */ LayoutInfo $layoutInfo;
                {
                    this.this$0 = $receiver;
                    this.$layoutInfo = $layoutInfo;
                    super(0);
                }

                public final void invoke() {
                    block0: {
                        TableReloadHandler.access$getPendingTableTracking$p(this.this$0).remove(this.$layoutInfo.getSemanticsId());
                        ViewHolder viewHolder = InstrumentorComposeApi.INSTANCE.getComposeViewHolder();
                        if (viewHolder == null || (viewHolder = ComposeUtilsKt.toUIComposeView$default((ViewHolder)viewHolder, (LayoutInfo)this.$layoutInfo, null, (int)2, null)) == null) break block0;
                        ViewHolder uiComposeView = viewHolder;
                        boolean bl = false;
                        TrackingManager.INSTANCE.getTrackingApi().trackTableReload((UIContainer)uiComposeView);
                    }
                }
            });
        }
    }

    public final void onDetach(@NotNull LayoutInfo layoutInfo) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
            if (this.scrollStatusProvider.isScrolling()) {
                return;
            }
            LayoutInfo layoutInfo2 = layoutInfo.getParentInfo();
            if (layoutInfo2 == null) break block2;
            LayoutInfo parentInfo = layoutInfo2;
            boolean bl = false;
            boolean wasRemoved = this.tableIds.remove(parentInfo.getSemanticsId());
            if (!wasRemoved || this.isTracking(layoutInfo)) {
                return;
            }
            this.launchWithDelay(850L, (Function0)new Function0<Unit>(parentInfo){
                final /* synthetic */ LayoutInfo $parentInfo;
                {
                    this.$parentInfo = $parentInfo;
                    super(0);
                }

                public final void invoke() {
                    block0: {
                        ViewHolder viewHolder = InstrumentorComposeApi.INSTANCE.getComposeViewHolder();
                        if (viewHolder == null || (viewHolder = ComposeUtilsKt.toUIComposeView$default((ViewHolder)viewHolder, (LayoutInfo)this.$parentInfo, null, (int)2, null)) == null) break block0;
                        ViewHolder uiComposeView = viewHolder;
                        boolean bl = false;
                        TrackingManager.INSTANCE.getTrackingApi().trackTableReload((UIContainer)uiComposeView);
                    }
                }
            });
        }
    }

    public final void onRecomposedTable(@NotNull LayoutInfo layoutInfo) {
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        if (this.scrollStatusProvider.isScrolling()) {
            return;
        }
        if (this.tableIds.contains(layoutInfo.getSemanticsId())) {
            this.recomposedTablesTimestamps.put(layoutInfo.getSemanticsId(), System.currentTimeMillis());
        }
    }

    public final void dispatchOnPositionedCallbacks(@NotNull LayoutInfo layoutInfo) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
            if (this.scrollStatusProvider.isScrolling() || !this.tableIds.contains(layoutInfo.getSemanticsId())) {
                return;
            }
            this.recomposedTablesTimestamps = this.getRecentlyMeasuredTables();
            LayoutInfo layoutInfo2 = this.getRecomposedLayout(layoutInfo);
            if (layoutInfo2 == null) {
                return;
            }
            LayoutInfo recomposedLayout = layoutInfo2;
            ViewHolder viewHolder = InstrumentorComposeApi.INSTANCE.getComposeViewHolder();
            if (viewHolder == null || (viewHolder = ComposeUtilsKt.toUIComposeView$default((ViewHolder)viewHolder, (LayoutInfo)recomposedLayout, null, (int)2, null)) == null) break block2;
            ViewHolder uiComposeView = viewHolder;
            boolean bl = false;
            this.recomposedTablesTimestamps.clear();
            this.launchWithDelay(850L, (Function0)new Function0<Unit>((UIComposeView)uiComposeView){
                final /* synthetic */ UIComposeView $uiComposeView;
                {
                    this.$uiComposeView = $uiComposeView;
                    super(0);
                }

                public final void invoke() {
                    TrackingManager.INSTANCE.getTrackingApi().trackTableReload((UIContainer)this.$uiComposeView);
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTracking(LayoutInfo $this$isTracking) {
        if (this.pendingTableTracking.contains($this$isTracking.getSemanticsId())) return true;
        LayoutInfo layoutInfo = $this$isTracking.getParentInfo();
        if (layoutInfo == null) return false;
        boolean bl = this.isTracking(layoutInfo);
        if (!bl) return false;
        return true;
    }

    private final LayoutInfo getRecomposedLayout(LayoutInfo $this$getRecomposedLayout) {
        Object object;
        if (this.recomposedTablesTimestamps.keySet().contains($this$getRecomposedLayout.getSemanticsId())) {
            object = $this$getRecomposedLayout.getParentInfo();
        } else {
            LayoutInfo layoutInfo = $this$getRecomposedLayout.getParentInfo();
            object = layoutInfo != null ? this.getRecomposedLayout(layoutInfo) : null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, Long> getRecentlyMeasuredTables() {
        void $this$filterTo$iv$iv;
        long currentTimestamp = System.currentTimeMillis();
        Map<Integer, Long> $this$filter$iv = this.recomposedTablesTimestamps;
        boolean $i$f$filter = false;
        Map<Integer, Long> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            long timestamp = ((Number)entry.getValue()).longValue();
            if (!(currentTimestamp - timestamp < 100L)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map recentlyMeasuredMap = destination$iv$iv;
        return MapsKt.toMutableMap((Map)recentlyMeasuredMap);
    }

    public static final /* synthetic */ Set access$getPendingTableTracking$p(TableReloadHandler $this) {
        return $this.pendingTableTracking;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/dynatrace/android/internal/api/compose15/handler/TableReloadHandler$Companion;", "", "()V", "RECENT_MEASUREMENT_MILLIS", "", "TABLE_RELOAD_EVENT_DELAY_MILLIS", "api.compose15_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

