/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.data.mappers;

import android.content.ContentValues;
import com.dynatrace.android.sessionreplay.data.mappers.Mapper;
import com.dynatrace.android.sessionreplay.model.AlertViewEvent;
import com.dynatrace.android.sessionreplay.model.CompoundButtonEvent;
import com.dynatrace.android.sessionreplay.model.CustomEvent;
import com.dynatrace.android.sessionreplay.model.Event;
import com.dynatrace.android.sessionreplay.model.FragmentEvent;
import com.dynatrace.android.sessionreplay.model.InputEndEvent;
import com.dynatrace.android.sessionreplay.model.InputKeystrokeEvent;
import com.dynatrace.android.sessionreplay.model.InputStartEvent;
import com.dynatrace.android.sessionreplay.model.KeyboardShownEvent;
import com.dynatrace.android.sessionreplay.model.LifecycleEvent;
import com.dynatrace.android.sessionreplay.model.NavigationDrawerEvent;
import com.dynatrace.android.sessionreplay.model.NavigationEvent;
import com.dynatrace.android.sessionreplay.model.ResolutionEvent;
import com.dynatrace.android.sessionreplay.model.ScrollEvent;
import com.dynatrace.android.sessionreplay.model.TouchEvent;
import com.dynatrace.android.sessionreplay.model.UIMetadata;
import com.dynatrace.android.sessionreplay.model.WebViewLoadEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/dynatrace/android/sessionreplay/data/mappers/FromEventMapper;", "Lcom/dynatrace/android/sessionreplay/data/mappers/Mapper;", "Lcom/dynatrace/android/sessionreplay/model/Event;", "Landroid/content/ContentValues;", "()V", "map", "source", "datalayer_release"})
public final class FromEventMapper
implements Mapper<Event, ContentValues> {
    @Override
    @NotNull
    public ContentValues map(@NotNull Event source) {
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        ContentValues $this$map_u24lambda_u241 = contentValues = new ContentValues();
        boolean bl = false;
        $this$map_u24lambda_u241.put("_id", source.getId());
        $this$map_u24lambda_u241.put("type", source.getType().name());
        $this$map_u24lambda_u241.put("start_time", Long.valueOf(source.getStartTime().getTime()));
        $this$map_u24lambda_u241.put("screenshot_id", source.getScreenshotId());
        $this$map_u24lambda_u241.put("screenshot_size", Long.valueOf(source.getScreenshotSize()));
        UIMetadata uIMetadata = source.getUIMetadata();
        if (uIMetadata != null) {
            UIMetadata it = uIMetadata;
            boolean bl2 = false;
            $this$map_u24lambda_u241.put("view_height", Integer.valueOf(it.getHeight()));
            $this$map_u24lambda_u241.put("view_width", Integer.valueOf(it.getWidth()));
            $this$map_u24lambda_u241.put("view_position_x", Integer.valueOf(it.getPositionX()));
            $this$map_u24lambda_u241.put("view_position_y", Integer.valueOf(it.getPositionY()));
            $this$map_u24lambda_u241.put("view_is_masked", Integer.valueOf(it.isMasked() ? 1 : 0));
        }
        ContentValues values = contentValues;
        contentValues = source;
        if (contentValues instanceof CustomEvent) {
            values.put("name", ((CustomEvent)source).getName());
        } else if (contentValues instanceof InputStartEvent) {
            values.put("input_field", ((InputStartEvent)source).getField());
            values.put("name", ((InputStartEvent)source).getName());
            values.put("input_value", ((InputStartEvent)source).getValue());
            values.put("input_modification", ((InputStartEvent)source).getModificationId());
        } else if (contentValues instanceof InputEndEvent) {
            values.put("input_field", ((InputEndEvent)source).getField());
            values.put("name", ((InputEndEvent)source).getName());
            values.put("input_value", ((InputEndEvent)source).getValue());
            values.put("duration", Long.valueOf(((InputEndEvent)source).getDuration()));
            values.put("input_modification", ((InputEndEvent)source).getModificationId());
        } else if (contentValues instanceof InputKeystrokeEvent) {
            values.put("input_value", ((InputKeystrokeEvent)source).getKeystrokeValue());
            values.put("input_modification", ((InputKeystrokeEvent)source).getModificationId());
        } else if (contentValues instanceof LifecycleEvent) {
            values.put("event_subtype", ((LifecycleEvent)source).getAction().name());
        } else if (contentValues instanceof NavigationEvent) {
            values.put("event_subtype", ((NavigationEvent)source).getNavType().name());
        } else if (contentValues instanceof ResolutionEvent) {
            values.put("orientation", Integer.valueOf(((ResolutionEvent)source).getOrientation()));
            values.put("height", Integer.valueOf(((ResolutionEvent)source).getHeight()));
            values.put("width", Integer.valueOf(((ResolutionEvent)source).getWidth()));
        } else if (contentValues instanceof ScrollEvent) {
            values.put("x", Integer.valueOf(((ScrollEvent)source).getX()));
            values.put("y", Integer.valueOf(((ScrollEvent)source).getY()));
        } else if (contentValues instanceof TouchEvent) {
            values.put("x", Integer.valueOf(((TouchEvent)source).getX()));
            values.put("y", Integer.valueOf(((TouchEvent)source).getY()));
            values.put("duration", Long.valueOf(((TouchEvent)source).getDuration()));
            values.put("system_time", Long.valueOf(((TouchEvent)source).getSystemTime()));
            values.put("rage_tap", Integer.valueOf(((TouchEvent)source).isRageTap() ? 1 : 0));
        } else if (contentValues instanceof WebViewLoadEvent) {
            values.put("url", ((WebViewLoadEvent)source).getUrl());
        } else if (contentValues instanceof FragmentEvent) {
            values.put("name", ((FragmentEvent)source).getFragmentName());
        } else if (contentValues instanceof AlertViewEvent) {
            values.put("event_subtype", ((AlertViewEvent)source).getAction().name());
        } else if (contentValues instanceof KeyboardShownEvent) {
            values.put("keyboard_position_x", Integer.valueOf(((KeyboardShownEvent)source).getKeyboardPosition().getX()));
            values.put("keyboard_position_y", Integer.valueOf(((KeyboardShownEvent)source).getKeyboardPosition().getY()));
            values.put("keyboard_width", Integer.valueOf(((KeyboardShownEvent)source).getKeyboardPosition().getWidth()));
            values.put("keyboard_height", Integer.valueOf(((KeyboardShownEvent)source).getKeyboardPosition().getHeight()));
        } else if (contentValues instanceof CompoundButtonEvent) {
            values.put("event_subtype", ((CompoundButtonEvent)source).getAction().name());
        } else if (contentValues instanceof NavigationDrawerEvent) {
            values.put("event_subtype", ((NavigationDrawerEvent)source).getAction().name());
        }
        return values;
    }
}

