/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.data.daos.sql;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import com.dynatrace.android.sessionreplay.data.daos.DataJobDAO;
import com.dynatrace.android.sessionreplay.data.daos.sql.BaseSqlDAO;
import com.dynatrace.android.sessionreplay.data.mappers.Mapper;
import com.dynatrace.android.sessionreplay.model.DataError;
import com.dynatrace.android.sessionreplay.model.DataJob;
import com.dynatrace.android.sessionreplay.model.Result;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001cB!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\bH\u0014R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/dynatrace/android/sessionreplay/data/daos/sql/SQLDataJobDAO;", "Lcom/dynatrace/android/sessionreplay/data/daos/sql/BaseSqlDAO;", "Lcom/dynatrace/android/sessionreplay/model/DataJob;", "Lcom/dynatrace/android/sessionreplay/data/daos/DataJobDAO;", "db", "Landroid/database/sqlite/SQLiteDatabase;", "mapper", "Lcom/dynatrace/android/sessionreplay/data/mappers/Mapper;", "Landroid/database/Cursor;", "(Landroid/database/sqlite/SQLiteDatabase;Lcom/dynatrace/android/sessionreplay/data/mappers/Mapper;)V", "create", "Lcom/dynatrace/android/sessionreplay/model/Result;", "Lcom/dynatrace/android/sessionreplay/model/DataError;", "dataJob", "delete", "", "id", "", "deleteAll", "get", "getAll", "", "getByVisitId", "visitId", "getDataJobContentValues", "Landroid/content/ContentValues;", "map", "cursor", "Companion", "datalayer_release"})
public final class SQLDataJobDAO
extends BaseSqlDAO<DataJob>
implements DataJobDAO {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Mapper<Cursor, DataJob> mapper;
    @NotNull
    private static final String TABLE = "datajob";

    public SQLDataJobDAO(@NotNull SQLiteDatabase db2, @NotNull Mapper<Cursor, DataJob> mapper) {
        Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        super(db2, TABLE);
        this.mapper = mapper;
    }

    @Override
    @NotNull
    public Result<DataJob, DataError> get(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        DataJob dataJob = (DataJob)this.get("id", id);
        return dataJob != null ? (Result)new Result.Success((Object)dataJob) : (Result)new Result.Error((Object)DataError.NotFound.INSTANCE);
    }

    @Override
    @NotNull
    public List<DataJob> getByVisitId(@NotNull String visitId) {
        Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
        return BaseSqlDAO.getByAttribute$default(this, "visit_id", visitId, null, 4, null);
    }

    @Override
    @NotNull
    public List<DataJob> getAll() {
        return this.getAllRecords();
    }

    @Override
    @NotNull
    public Result<DataJob, DataError> create(@NotNull DataJob dataJob) {
        Result<DataJob, DataError> result;
        Intrinsics.checkNotNullParameter((Object)dataJob, (String)"dataJob");
        ContentValues values = this.getDataJobContentValues(dataJob);
        try {
            this.getDb().insertOrThrow(TABLE, null, values);
            result = this.get(dataJob.getId());
        }
        catch (SQLException e) {
            result = (Result<DataJob, DataError>)new Result.Error((Object)new DataError.SaveError((Throwable)e));
        }
        return result;
    }

    @Override
    public void delete(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.delete("id", id);
    }

    @Override
    public void deleteAll() {
        BaseSqlDAO.deleteAllRecords$default(this, null, null, 3, null);
    }

    @Override
    @NotNull
    protected DataJob map(@NotNull Cursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        return this.mapper.map(cursor);
    }

    private final ContentValues getDataJobContentValues(DataJob dataJob) {
        ContentValues contentValues;
        ContentValues $this$getDataJobContentValues_u24lambda_u240 = contentValues = new ContentValues();
        boolean bl = false;
        $this$getDataJobContentValues_u24lambda_u240.put("id", dataJob.getId());
        $this$getDataJobContentValues_u24lambda_u240.put("protocol_version", Integer.valueOf(dataJob.getProtocolVersion()));
        $this$getDataJobContentValues_u24lambda_u240.put("data", dataJob.getData());
        $this$getDataJobContentValues_u24lambda_u240.put("visit_id", dataJob.getVisitId());
        $this$getDataJobContentValues_u24lambda_u240.put("start_time", Long.valueOf(dataJob.getStartTime().getTime()));
        return contentValues;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/dynatrace/android/sessionreplay/data/daos/sql/SQLDataJobDAO$Companion;", "", "()V", "TABLE", "", "datalayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

