/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.data.db.sqlite.contracts;

import android.database.sqlite.SQLiteDatabase;
import android.provider.BaseColumns;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c0\u0002\u0018\u00002\u00020\u0001:\b\t\n\u000b\f\r\u000e\u000f\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0011"}, d2={"Lcom/dynatrace/android/sessionreplay/data/db/sqlite/contracts/Contract;", "", "<init>", "()V", "createTables", "", "db", "Landroid/database/sqlite/SQLiteDatabase;", "dropTables", "SessionEntry", "EventEntry", "CheckpointEntry", "LogEntry", "ScreenshotJobEntry", "SessionImageEntry", "DataJobEntry", "SelfMonitoringEntry", "datalayer_release"})
public final class Contract {
    @NotNull
    public static final Contract INSTANCE = new Contract();

    private Contract() {
    }

    public final void createTables(@NotNull SQLiteDatabase db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        db.execSQL("CREATE TABLE session (visit_id TEXT PRIMARY KEY,device_height INTEGER,device_width INTEGER,is_partially_sent BOOLEAN,did_crash BOOLEAN,last_event_timestamp INTEGER,state INTEGER)");
        db.execSQL("CREATE TABLE sessionimage (id TEXT PRIMARY KEY,visit_id TEXT,screenshot_id TEXT,FOREIGN KEY(visit_id) references session(visit_id) ON DELETE CASCADE ON UPDATE CASCADE)");
        db.execSQL("CREATE TABLE event (_id TEXT PRIMARY KEY,visit_id TEXT,type TEXT,start_time INTEGER,screenshot_id TEXT,screenshot_size INTEGER,input_field TEXT,input_value TEXT,input_modification TEXT,event_subtype TEXT,orientation INTEGER,height INTEGER,width INTEGER,x INTEGER,y INTEGER,duration INTEGER,url TEXT,view_height INTEGER,view_width INTEGER,view_position_x INTEGER,view_position_y INTEGER,view_is_masked BOOLEAN,name TEXT,keyboard_position_x INTEGER,keyboard_position_y INTEGER,keyboard_width INTEGER,keyboard_height INTEGER,system_time INTEGER,rage_tap INTEGER,FOREIGN KEY(visit_id) references session(visit_id) ON DELETE CASCADE ON UPDATE CASCADE)");
        db.execSQL("CREATE TABLE checkpoint (_id INTEGER PRIMARY KEY,elapsed_time INTEGER,x INTEGER,y INTEGER,event_id TEXT,FOREIGN KEY(event_id) references event(_id) ON DELETE CASCADE)");
        db.execSQL("CREATE TABLE log (_id INTEGER PRIMARY KEY,visit_id TEXT,time INTEGER,value TEXT,FOREIGN KEY(visit_id) references session(visit_id) ON DELETE CASCADE ON UPDATE CASCADE)");
        db.execSQL("CREATE TABLE datajob (id TEXT PRIMARY KEY,protocol_version INTEGER,data BLOB,visit_id TEXT,start_time INTEGER,FOREIGN KEY(visit_id) references session(visit_id) ON DELETE CASCADE ON UPDATE CASCADE)");
        db.execSQL("CREATE TABLE screenshotjob (id TEXT PRIMARY KEY,visit_id TEXT,time INTEGER,visitor_id TEXT,screenshot_id TEXT,FOREIGN KEY(visit_id) references session(visit_id) ON DELETE CASCADE ON UPDATE CASCADE)");
        db.execSQL("CREATE TABLE selfmonitoring (id INTEGER PRIMARY KEY AUTOINCREMENT,visit_id TEXT,creation_time INTEGER,serialization TEXT,type INTEGER)");
    }

    public final void dropTables(@NotNull SQLiteDatabase db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        db.execSQL("DROP TABLE IF EXISTS screenshotjob");
        db.execSQL("DROP TABLE IF EXISTS sessionimage");
        db.execSQL("DROP TABLE IF EXISTS datajob");
        db.execSQL("DROP TABLE IF EXISTS log");
        db.execSQL("DROP TABLE IF EXISTS checkpoint");
        db.execSQL("DROP TABLE IF EXISTS event");
        db.execSQL("DROP TABLE IF EXISTS session");
        db.execSQL("DROP TABLE IF EXISTS selfmonitoring");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/dynatrace/android/sessionreplay/data/db/sqlite/contracts/Contract$CheckpointEntry;", "Landroid/provider/BaseColumns;", "<init>", "()V", "TABLE_NAME", "", "COLUMN_CHECKPOINT_ID", "COLUMN_EVENT_ID", "COLUMN_ELAPSED_TIME", "COLUMN_X", "COLUMN_Y", "SQL_CREATE_TABLE", "SQL_DROP_TABLE", "datalayer_release"})
    public static final class CheckpointEntry
    implements BaseColumns {
        @NotNull
        public static final CheckpointEntry INSTANCE = new CheckpointEntry();
        @NotNull
        public static final String TABLE_NAME = "checkpoint";
        @NotNull
        public static final String COLUMN_CHECKPOINT_ID = "_id";
        @NotNull
        public static final String COLUMN_EVENT_ID = "event_id";
        @NotNull
        public static final String COLUMN_ELAPSED_TIME = "elapsed_time";
        @NotNull
        public static final String COLUMN_X = "x";
        @NotNull
        public static final String COLUMN_Y = "y";
        @NotNull
        public static final String SQL_CREATE_TABLE = "CREATE TABLE checkpoint (_id INTEGER PRIMARY KEY,elapsed_time INTEGER,x INTEGER,y INTEGER,event_id TEXT,FOREIGN KEY(event_id) references event(_id) ON DELETE CASCADE)";
        @NotNull
        public static final String SQL_DROP_TABLE = "DROP TABLE IF EXISTS checkpoint";

        private CheckpointEntry() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/dynatrace/android/sessionreplay/data/db/sqlite/contracts/Contract$DataJobEntry;", "Landroid/provider/BaseColumns;", "<init>", "()V", "TABLE_NAME", "", "COLUMN_ID", "COLUMN_PROTOCOL_VERSION", "COLUMN_DATA", "COLUMN_VISIT_ID", "COLUMN_START_TIME", "SQL_CREATE_TABLE", "SQL_DROP_TABLE", "datalayer_release"})
    public static final class DataJobEntry
    implements BaseColumns {
        @NotNull
        public static final DataJobEntry INSTANCE = new DataJobEntry();
        @NotNull
        public static final String TABLE_NAME = "datajob";
        @NotNull
        public static final String COLUMN_ID = "id";
        @NotNull
        public static final String COLUMN_PROTOCOL_VERSION = "protocol_version";
        @NotNull
        public static final String COLUMN_DATA = "data";
        @NotNull
        public static final String COLUMN_VISIT_ID = "visit_id";
        @NotNull
        public static final String COLUMN_START_TIME = "start_time";
        @NotNull
        public static final String SQL_CREATE_TABLE = "CREATE TABLE datajob (id TEXT PRIMARY KEY,protocol_version INTEGER,data BLOB,visit_id TEXT,start_time INTEGER,FOREIGN KEY(visit_id) references session(visit_id) ON DELETE CASCADE ON UPDATE CASCADE)";
        @NotNull
        public static final String SQL_DROP_TABLE = "DROP TABLE IF EXISTS datajob";

        private DataJobEntry() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b \b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/dynatrace/android/sessionreplay/data/db/sqlite/contracts/Contract$EventEntry;", "Landroid/provider/BaseColumns;", "<init>", "()V", "TABLE_NAME", "", "COLUMN_EVENT_ID", "COLUMN_VISIT_ID", "COLUMN_TYPE", "COLUMN_START_TIME", "COLUMN_SCREENSHOT_ID", "COLUMN_SCREENSHOT_SIZE", "COLUMN_INPUT_FIELD", "COLUMN_INPUT_VALUE", "COLUMN_INPUT_MODIFICATION", "COLUMN_EVENT_SUBTYPE", "COLUMN_RESOLUTION_ORIENTATION", "COLUMN_RESOLUTION_HEIGHT", "COLUMN_RESOLUTION_WIDTH", "COLUMN_X", "COLUMN_Y", "COLUMN_DURATION", "COLUMN_SYSTEM_TIMESTAMP", "COLUMN_RAGE_TAP", "COLUMN_WEBVIEW_URL", "COLUMN_KEYBOARD_POSITION_X", "COLUMN_KEYBOARD_POSITION_Y", "COLUMN_KEYBOARD_WIDTH", "COLUMN_KEYBOARD_HEIGHT", "COLUMN_VIEW_HEIGHT", "COLUMN_VIEW_WIDTH", "COLUMN_VIEW_POSITION_X", "COLUMN_VIEW_POSITION_Y", "COLUMN_VIEW_MASKED", "COLUMN_NAME", "SQL_CREATE_TABLE", "SQL_DROP_TABLE", "datalayer_release"})
    public static final class EventEntry
    implements BaseColumns {
        @NotNull
        public static final EventEntry INSTANCE = new EventEntry();
        @NotNull
        public static final String TABLE_NAME = "event";
        @NotNull
        public static final String COLUMN_EVENT_ID = "_id";
        @NotNull
        public static final String COLUMN_VISIT_ID = "visit_id";
        @NotNull
        public static final String COLUMN_TYPE = "type";
        @NotNull
        public static final String COLUMN_START_TIME = "start_time";
        @NotNull
        public static final String COLUMN_SCREENSHOT_ID = "screenshot_id";
        @NotNull
        public static final String COLUMN_SCREENSHOT_SIZE = "screenshot_size";
        @NotNull
        public static final String COLUMN_INPUT_FIELD = "input_field";
        @NotNull
        public static final String COLUMN_INPUT_VALUE = "input_value";
        @NotNull
        public static final String COLUMN_INPUT_MODIFICATION = "input_modification";
        @NotNull
        public static final String COLUMN_EVENT_SUBTYPE = "event_subtype";
        @NotNull
        public static final String COLUMN_RESOLUTION_ORIENTATION = "orientation";
        @NotNull
        public static final String COLUMN_RESOLUTION_HEIGHT = "height";
        @NotNull
        public static final String COLUMN_RESOLUTION_WIDTH = "width";
        @NotNull
        public static final String COLUMN_X = "x";
        @NotNull
        public static final String COLUMN_Y = "y";
        @NotNull
        public static final String COLUMN_DURATION = "duration";
        @NotNull
        public static final String COLUMN_SYSTEM_TIMESTAMP = "system_time";
        @NotNull
        public static final String COLUMN_RAGE_TAP = "rage_tap";
        @NotNull
        public static final String COLUMN_WEBVIEW_URL = "url";
        @NotNull
        public static final String COLUMN_KEYBOARD_POSITION_X = "keyboard_position_x";
        @NotNull
        public static final String COLUMN_KEYBOARD_POSITION_Y = "keyboard_position_y";
        @NotNull
        public static final String COLUMN_KEYBOARD_WIDTH = "keyboard_width";
        @NotNull
        public static final String COLUMN_KEYBOARD_HEIGHT = "keyboard_height";
        @NotNull
        public static final String COLUMN_VIEW_HEIGHT = "view_height";
        @NotNull
        public static final String COLUMN_VIEW_WIDTH = "view_width";
        @NotNull
        public static final String COLUMN_VIEW_POSITION_X = "view_position_x";
        @NotNull
        public static final String COLUMN_VIEW_POSITION_Y = "view_position_y";
        @NotNull
        public static final String COLUMN_VIEW_MASKED = "view_is_masked";
        @NotNull
        public static final String COLUMN_NAME = "name";
        @NotNull
        public static final String SQL_CREATE_TABLE = "CREATE TABLE event (_id TEXT PRIMARY KEY,visit_id TEXT,type TEXT,start_time INTEGER,screenshot_id TEXT,screenshot_size INTEGER,input_field TEXT,input_value TEXT,input_modification TEXT,event_subtype TEXT,orientation INTEGER,height INTEGER,width INTEGER,x INTEGER,y INTEGER,duration INTEGER,url TEXT,view_height INTEGER,view_width INTEGER,view_position_x INTEGER,view_position_y INTEGER,view_is_masked BOOLEAN,name TEXT,keyboard_position_x INTEGER,keyboard_position_y INTEGER,keyboard_width INTEGER,keyboard_height INTEGER,system_time INTEGER,rage_tap INTEGER,FOREIGN KEY(visit_id) references session(visit_id) ON DELETE CASCADE ON UPDATE CASCADE)";
        @NotNull
        public static final String SQL_DROP_TABLE = "DROP TABLE IF EXISTS event";

        private EventEntry() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/dynatrace/android/sessionreplay/data/db/sqlite/contracts/Contract$LogEntry;", "Landroid/provider/BaseColumns;", "<init>", "()V", "TABLE_NAME", "", "COLUMN_LOG_ID", "COLUMN_VISIT_ID", "COLUMN_TIME", "COLUMN_VALUE", "SQL_CREATE_TABLE", "SQL_DROP_TABLE", "datalayer_release"})
    public static final class LogEntry
    implements BaseColumns {
        @NotNull
        public static final LogEntry INSTANCE = new LogEntry();
        @NotNull
        public static final String TABLE_NAME = "log";
        @NotNull
        public static final String COLUMN_LOG_ID = "_id";
        @NotNull
        public static final String COLUMN_VISIT_ID = "visit_id";
        @NotNull
        public static final String COLUMN_TIME = "time";
        @NotNull
        public static final String COLUMN_VALUE = "value";
        @NotNull
        public static final String SQL_CREATE_TABLE = "CREATE TABLE log (_id INTEGER PRIMARY KEY,visit_id TEXT,time INTEGER,value TEXT,FOREIGN KEY(visit_id) references session(visit_id) ON DELETE CASCADE ON UPDATE CASCADE)";
        @NotNull
        public static final String SQL_DROP_TABLE = "DROP TABLE IF EXISTS log";

        private LogEntry() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/dynatrace/android/sessionreplay/data/db/sqlite/contracts/Contract$ScreenshotJobEntry;", "Landroid/provider/BaseColumns;", "<init>", "()V", "TABLE_NAME", "", "COLUMN_ID", "COLUMN_TIME", "COLUMN_VISIT_ID", "COLUMN_VISITOR_ID", "COLUMN_SCREENSHOT_ID", "SQL_CREATE_TABLE", "SQL_DROP_TABLE", "datalayer_release"})
    public static final class ScreenshotJobEntry
    implements BaseColumns {
        @NotNull
        public static final ScreenshotJobEntry INSTANCE = new ScreenshotJobEntry();
        @NotNull
        public static final String TABLE_NAME = "screenshotjob";
        @NotNull
        public static final String COLUMN_ID = "id";
        @NotNull
        public static final String COLUMN_TIME = "time";
        @NotNull
        public static final String COLUMN_VISIT_ID = "visit_id";
        @NotNull
        public static final String COLUMN_VISITOR_ID = "visitor_id";
        @NotNull
        public static final String COLUMN_SCREENSHOT_ID = "screenshot_id";
        @NotNull
        public static final String SQL_CREATE_TABLE = "CREATE TABLE screenshotjob (id TEXT PRIMARY KEY,visit_id TEXT,time INTEGER,visitor_id TEXT,screenshot_id TEXT,FOREIGN KEY(visit_id) references session(visit_id) ON DELETE CASCADE ON UPDATE CASCADE)";
        @NotNull
        public static final String SQL_DROP_TABLE = "DROP TABLE IF EXISTS screenshotjob";

        private ScreenshotJobEntry() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/dynatrace/android/sessionreplay/data/db/sqlite/contracts/Contract$SelfMonitoringEntry;", "Landroid/provider/BaseColumns;", "<init>", "()V", "TABLE_NAME", "", "COLUMN_ID", "COLUMN_VISIT_ID", "COLUMN_CREATION_TIME", "COLUMN_SERIALIZATION", "COLUMN_TYPE", "SQL_CREATE_TABLE", "SQL_DROP_TABLE", "datalayer_release"})
    public static final class SelfMonitoringEntry
    implements BaseColumns {
        @NotNull
        public static final SelfMonitoringEntry INSTANCE = new SelfMonitoringEntry();
        @NotNull
        public static final String TABLE_NAME = "selfmonitoring";
        @NotNull
        public static final String COLUMN_ID = "id";
        @NotNull
        public static final String COLUMN_VISIT_ID = "visit_id";
        @NotNull
        public static final String COLUMN_CREATION_TIME = "creation_time";
        @NotNull
        public static final String COLUMN_SERIALIZATION = "serialization";
        @NotNull
        public static final String COLUMN_TYPE = "type";
        @NotNull
        public static final String SQL_CREATE_TABLE = "CREATE TABLE selfmonitoring (id INTEGER PRIMARY KEY AUTOINCREMENT,visit_id TEXT,creation_time INTEGER,serialization TEXT,type INTEGER)";
        @NotNull
        public static final String SQL_DROP_TABLE = "DROP TABLE IF EXISTS selfmonitoring";

        private SelfMonitoringEntry() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/dynatrace/android/sessionreplay/data/db/sqlite/contracts/Contract$SessionEntry;", "Landroid/provider/BaseColumns;", "<init>", "()V", "TABLE_NAME", "", "COLUMN_VISIT_ID", "COLUMN_DEVICE_HEIGHT", "COLUMN_DEVICE_WIDTH", "COLUMN_IS_PARTIALLY_SENT", "COLUMN_DID_CRASH", "COLUMN_LAST_EVENT_TIMESTAMP", "COLUMN_STATE", "SQL_CREATE_TABLE", "SQL_DROP_TABLE", "datalayer_release"})
    public static final class SessionEntry
    implements BaseColumns {
        @NotNull
        public static final SessionEntry INSTANCE = new SessionEntry();
        @NotNull
        public static final String TABLE_NAME = "session";
        @NotNull
        public static final String COLUMN_VISIT_ID = "visit_id";
        @NotNull
        public static final String COLUMN_DEVICE_HEIGHT = "device_height";
        @NotNull
        public static final String COLUMN_DEVICE_WIDTH = "device_width";
        @NotNull
        public static final String COLUMN_IS_PARTIALLY_SENT = "is_partially_sent";
        @NotNull
        public static final String COLUMN_DID_CRASH = "did_crash";
        @NotNull
        public static final String COLUMN_LAST_EVENT_TIMESTAMP = "last_event_timestamp";
        @NotNull
        public static final String COLUMN_STATE = "state";
        @NotNull
        public static final String SQL_CREATE_TABLE = "CREATE TABLE session (visit_id TEXT PRIMARY KEY,device_height INTEGER,device_width INTEGER,is_partially_sent BOOLEAN,did_crash BOOLEAN,last_event_timestamp INTEGER,state INTEGER)";
        @NotNull
        public static final String SQL_DROP_TABLE = "DROP TABLE IF EXISTS session";

        private SessionEntry() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/dynatrace/android/sessionreplay/data/db/sqlite/contracts/Contract$SessionImageEntry;", "Landroid/provider/BaseColumns;", "<init>", "()V", "TABLE_NAME", "", "COLUMN_ID", "COLUMN_VISIT_ID", "COLUMN_SCREENSHOT_ID", "SQL_CREATE_TABLE", "SQL_DROP_TABLE", "datalayer_release"})
    public static final class SessionImageEntry
    implements BaseColumns {
        @NotNull
        public static final SessionImageEntry INSTANCE = new SessionImageEntry();
        @NotNull
        public static final String TABLE_NAME = "sessionimage";
        @NotNull
        public static final String COLUMN_ID = "id";
        @NotNull
        public static final String COLUMN_VISIT_ID = "visit_id";
        @NotNull
        public static final String COLUMN_SCREENSHOT_ID = "screenshot_id";
        @NotNull
        public static final String SQL_CREATE_TABLE = "CREATE TABLE sessionimage (id TEXT PRIMARY KEY,visit_id TEXT,screenshot_id TEXT,FOREIGN KEY(visit_id) references session(visit_id) ON DELETE CASCADE ON UPDATE CASCADE)";
        @NotNull
        public static final String SQL_DROP_TABLE = "DROP TABLE IF EXISTS sessionimage";

        private SessionImageEntry() {
        }
    }
}

