/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.data.mappers;

import android.database.Cursor;
import com.dynatrace.android.sessionreplay.data.mappers.Mapper;
import com.dynatrace.android.sessionreplay.model.AlertViewAction;
import com.dynatrace.android.sessionreplay.model.AlertViewEvent;
import com.dynatrace.android.sessionreplay.model.CompoundButtonAction;
import com.dynatrace.android.sessionreplay.model.CompoundButtonEvent;
import com.dynatrace.android.sessionreplay.model.CustomEvent;
import com.dynatrace.android.sessionreplay.model.DisplayViewEvent;
import com.dynatrace.android.sessionreplay.model.Event;
import com.dynatrace.android.sessionreplay.model.EventType;
import com.dynatrace.android.sessionreplay.model.FragmentEvent;
import com.dynatrace.android.sessionreplay.model.GenericEvent;
import com.dynatrace.android.sessionreplay.model.GestureEvent;
import com.dynatrace.android.sessionreplay.model.InputEndEvent;
import com.dynatrace.android.sessionreplay.model.InputKeystrokeEvent;
import com.dynatrace.android.sessionreplay.model.InputStartEvent;
import com.dynatrace.android.sessionreplay.model.KeyboardHiddenEvent;
import com.dynatrace.android.sessionreplay.model.KeyboardPosition;
import com.dynatrace.android.sessionreplay.model.KeyboardShownEvent;
import com.dynatrace.android.sessionreplay.model.LifecycleAction;
import com.dynatrace.android.sessionreplay.model.LifecycleEvent;
import com.dynatrace.android.sessionreplay.model.NavigationDrawerAction;
import com.dynatrace.android.sessionreplay.model.NavigationDrawerEvent;
import com.dynatrace.android.sessionreplay.model.NavigationEvent;
import com.dynatrace.android.sessionreplay.model.NavigationType;
import com.dynatrace.android.sessionreplay.model.ResolutionEvent;
import com.dynatrace.android.sessionreplay.model.ScrollEvent;
import com.dynatrace.android.sessionreplay.model.TableReloadEvent;
import com.dynatrace.android.sessionreplay.model.TouchEvent;
import com.dynatrace.android.sessionreplay.model.UIMetadata;
import com.dynatrace.android.sessionreplay.model.WebViewLoadEvent;
import java.util.Date;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u00102\u001a\u0002032\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u00104\u001a\u0002052\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u00106\u001a\u0002072\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010:\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010\n\u001a\u00020\u0002H\u0002\u00a8\u0006="}, d2={"Lcom/dynatrace/android/sessionreplay/data/mappers/ToEventMapper;", "Lcom/dynatrace/android/sessionreplay/data/mappers/Mapper;", "Landroid/database/Cursor;", "Lcom/dynatrace/android/sessionreplay/model/Event;", "<init>", "()V", "map", "source", "getEventId", "", "cursor", "getStartTime", "Ljava/util/Date;", "getScreenshotId", "getScreenshotSize", "", "getEventType", "Lcom/dynatrace/android/sessionreplay/model/EventType;", "getInputModification", "getName", "getViewMetadata", "Lcom/dynatrace/android/sessionreplay/model/UIMetadata;", "createGenericEvent", "Lcom/dynatrace/android/sessionreplay/model/GenericEvent;", "createCustomEvent", "Lcom/dynatrace/android/sessionreplay/model/CustomEvent;", "createGestureEvent", "Lcom/dynatrace/android/sessionreplay/model/GestureEvent;", "createInputStartEvent", "Lcom/dynatrace/android/sessionreplay/model/InputStartEvent;", "createInputEndEvent", "Lcom/dynatrace/android/sessionreplay/model/InputEndEvent;", "createInputKeystrokeEvent", "Lcom/dynatrace/android/sessionreplay/model/InputKeystrokeEvent;", "createLifecycleEvent", "Lcom/dynatrace/android/sessionreplay/model/LifecycleEvent;", "createDisplayViewEvent", "Lcom/dynatrace/android/sessionreplay/model/DisplayViewEvent;", "createResolutionEvent", "Lcom/dynatrace/android/sessionreplay/model/ResolutionEvent;", "createScrollEvent", "Lcom/dynatrace/android/sessionreplay/model/ScrollEvent;", "createTouchEvent", "Lcom/dynatrace/android/sessionreplay/model/TouchEvent;", "createWebViewLoadEvent", "Lcom/dynatrace/android/sessionreplay/model/WebViewLoadEvent;", "createTableReloadEvent", "Lcom/dynatrace/android/sessionreplay/model/TableReloadEvent;", "createFragmentDisplayEvent", "Lcom/dynatrace/android/sessionreplay/model/FragmentEvent;", "createDialogDisplayEvent", "Lcom/dynatrace/android/sessionreplay/model/AlertViewEvent;", "createKeyboardShownEvent", "Lcom/dynatrace/android/sessionreplay/model/KeyboardShownEvent;", "createKeyboardHiddenEvent", "Lcom/dynatrace/android/sessionreplay/model/KeyboardHiddenEvent;", "createNavigationEvent", "Lcom/dynatrace/android/sessionreplay/model/NavigationEvent;", "createCompoundButtonEvent", "createNavigationDrawerEvent", "Lcom/dynatrace/android/sessionreplay/model/NavigationDrawerEvent;", "datalayer_release"})
public final class ToEventMapper
implements Mapper<Cursor, Event> {
    @Override
    @NotNull
    public Event map(@NotNull Cursor source) {
        Event event;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        switch (WhenMappings.$EnumSwitchMapping$0[this.getEventType(source).ordinal()]) {
            case 1: {
                event = (Event)this.createCustomEvent(source);
                break;
            }
            case 2: {
                event = (Event)this.createGestureEvent(source);
                break;
            }
            case 3: {
                event = (Event)this.createInputStartEvent(source);
                break;
            }
            case 4: {
                event = (Event)this.createInputEndEvent(source);
                break;
            }
            case 5: {
                event = (Event)this.createInputKeystrokeEvent(source);
                break;
            }
            case 6: {
                event = (Event)this.createLifecycleEvent(source);
                break;
            }
            case 7: {
                event = (Event)this.createDisplayViewEvent(source);
                break;
            }
            case 8: {
                event = (Event)this.createResolutionEvent(source);
                break;
            }
            case 9: {
                event = (Event)this.createScrollEvent(source);
                break;
            }
            case 10: {
                event = (Event)this.createTouchEvent(source);
                break;
            }
            case 11: {
                event = (Event)this.createWebViewLoadEvent(source);
                break;
            }
            case 12: {
                event = (Event)this.createTableReloadEvent(source);
                break;
            }
            case 13: {
                event = (Event)this.createGenericEvent(source);
                break;
            }
            case 14: {
                event = (Event)this.createNavigationEvent(source);
                break;
            }
            case 15: {
                event = (Event)this.createFragmentDisplayEvent(source);
                break;
            }
            case 16: {
                event = (Event)this.createDialogDisplayEvent(source);
                break;
            }
            case 17: {
                event = (Event)this.createKeyboardShownEvent(source);
                break;
            }
            case 18: {
                event = (Event)this.createKeyboardHiddenEvent(source);
                break;
            }
            case 19: {
                event = this.createCompoundButtonEvent(source);
                break;
            }
            case 20: {
                event = (Event)this.createNavigationDrawerEvent(source);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Event event2 = event;
        event2.setUIMetadata(this.getViewMetadata(source));
        return event2;
    }

    private final String getEventId(Cursor cursor) {
        String string = cursor.getString(cursor.getColumnIndexOrThrow("_id"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    private final Date getStartTime(Cursor cursor) {
        return new Date(cursor.getLong(cursor.getColumnIndexOrThrow("start_time")));
    }

    private final String getScreenshotId(Cursor cursor) {
        return cursor.getString(cursor.getColumnIndexOrThrow("screenshot_id"));
    }

    private final long getScreenshotSize(Cursor cursor) {
        return cursor.getLong(cursor.getColumnIndexOrThrow("screenshot_size"));
    }

    private final EventType getEventType(Cursor cursor) {
        String string = cursor.getString(cursor.getColumnIndexOrThrow("type"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return EventType.valueOf((String)string);
    }

    private final String getInputModification(Cursor cursor) {
        String string = cursor.getString(cursor.getColumnIndexOrThrow("input_modification"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    private final String getName(Cursor cursor) {
        String string = cursor.getString(cursor.getColumnIndexOrThrow("name"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    private final UIMetadata getViewMetadata(Cursor cursor) {
        int heightIndex = cursor.getColumnIndexOrThrow("view_height");
        int widthIndex = cursor.getColumnIndexOrThrow("view_width");
        int positionXIndex = cursor.getColumnIndexOrThrow("view_position_x");
        int positionYIndex = cursor.getColumnIndexOrThrow("view_position_y");
        int isMaskedIndex = cursor.getColumnIndexOrThrow("view_is_masked");
        if (cursor.isNull(heightIndex) || cursor.isNull(widthIndex) || cursor.isNull(positionXIndex) || cursor.isNull(positionYIndex) || cursor.isNull(isMaskedIndex)) {
            return null;
        }
        int height = cursor.getInt(heightIndex);
        int width = cursor.getInt(widthIndex);
        int positionX = cursor.getInt(positionXIndex);
        int positionY = cursor.getInt(positionYIndex);
        boolean isMasked = cursor.getInt(isMaskedIndex) == 1;
        return new UIMetadata(height, width, positionX, positionY, isMasked);
    }

    private final GenericEvent createGenericEvent(Cursor cursor) {
        return new GenericEvent(this.getEventType(cursor), this.getEventId(cursor), this.getStartTime(cursor), this.getScreenshotId(cursor), this.getScreenshotSize(cursor), null, 32, null);
    }

    private final CustomEvent createCustomEvent(Cursor cursor) {
        return new CustomEvent(this.getName(cursor), this.getEventId(cursor), this.getStartTime(cursor), this.getScreenshotId(cursor), this.getScreenshotSize(cursor), null, 32, null);
    }

    private final GestureEvent createGestureEvent(Cursor cursor) {
        return new GestureEvent(this.getEventId(cursor), this.getStartTime(cursor));
    }

    private final InputStartEvent createInputStartEvent(Cursor cursor) {
        String string = cursor.getString(cursor.getColumnIndexOrThrow("input_field"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String field = string;
        String string2 = cursor.getString(cursor.getColumnIndexOrThrow("input_value"));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String value = string2;
        return new InputStartEvent(field, value, this.getName(cursor), this.getInputModification(cursor), this.getEventId(cursor), this.getStartTime(cursor), this.getScreenshotId(cursor), this.getScreenshotSize(cursor), null, 256, null);
    }

    private final InputEndEvent createInputEndEvent(Cursor cursor) {
        String string = cursor.getString(cursor.getColumnIndexOrThrow("input_field"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String field = string;
        String string2 = cursor.getString(cursor.getColumnIndexOrThrow("input_value"));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String value = string2;
        long duration = cursor.getLong(cursor.getColumnIndexOrThrow("duration"));
        return new InputEndEvent(field, value, duration, this.getName(cursor), this.getInputModification(cursor), this.getEventId(cursor), this.getStartTime(cursor), this.getScreenshotId(cursor), this.getScreenshotSize(cursor), null, 512, null);
    }

    private final InputKeystrokeEvent createInputKeystrokeEvent(Cursor cursor) {
        String string = cursor.getString(cursor.getColumnIndexOrThrow("input_value"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String value = string;
        return new InputKeystrokeEvent(value, this.getInputModification(cursor), this.getEventId(cursor), this.getStartTime(cursor), this.getScreenshotId(cursor), this.getScreenshotSize(cursor), null, 64, null);
    }

    private final LifecycleEvent createLifecycleEvent(Cursor cursor) {
        String actionColumn = cursor.getString(cursor.getColumnIndexOrThrow("event_subtype"));
        Intrinsics.checkNotNull((Object)actionColumn);
        LifecycleAction action = LifecycleAction.valueOf((String)actionColumn);
        return new LifecycleEvent(action, this.getEventId(cursor), this.getStartTime(cursor));
    }

    private final DisplayViewEvent createDisplayViewEvent(Cursor cursor) {
        return new DisplayViewEvent(this.getEventId(cursor), this.getStartTime(cursor), this.getScreenshotId(cursor), this.getScreenshotSize(cursor), null, 16, null);
    }

    private final ResolutionEvent createResolutionEvent(Cursor cursor) {
        int orientation = cursor.getInt(cursor.getColumnIndexOrThrow("orientation"));
        int height = cursor.getInt(cursor.getColumnIndexOrThrow("height"));
        int width = cursor.getInt(cursor.getColumnIndexOrThrow("width"));
        return new ResolutionEvent(orientation, height, width, this.getEventId(cursor), this.getStartTime(cursor), this.getScreenshotId(cursor), this.getScreenshotSize(cursor), null, 128, null);
    }

    private final ScrollEvent createScrollEvent(Cursor cursor) {
        int x = cursor.getInt(cursor.getColumnIndexOrThrow("x"));
        int y = cursor.getInt(cursor.getColumnIndexOrThrow("y"));
        return new ScrollEvent(x, y, this.getEventId(cursor), this.getStartTime(cursor), this.getScreenshotId(cursor), this.getScreenshotSize(cursor), null, 64, null);
    }

    private final TouchEvent createTouchEvent(Cursor cursor) {
        int x = cursor.getInt(cursor.getColumnIndexOrThrow("x"));
        int y = cursor.getInt(cursor.getColumnIndexOrThrow("y"));
        long duration = cursor.getLong(cursor.getColumnIndexOrThrow("duration"));
        long systemTimestamp = cursor.getLong(cursor.getColumnIndexOrThrow("system_time"));
        int isRageTap = cursor.getInt(cursor.getColumnIndexOrThrow("rage_tap"));
        TouchEvent touchEvent = new TouchEvent(duration, x, y, systemTimestamp, this.getEventId(cursor), this.getStartTime(cursor));
        touchEvent.setRageTap(isRageTap == 1);
        return touchEvent;
    }

    private final WebViewLoadEvent createWebViewLoadEvent(Cursor cursor) {
        String string = cursor.getString(cursor.getColumnIndexOrThrow("url"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String url = string;
        return new WebViewLoadEvent(url, this.getEventId(cursor), this.getStartTime(cursor), this.getScreenshotId(cursor), this.getScreenshotSize(cursor), null, 32, null);
    }

    private final TableReloadEvent createTableReloadEvent(Cursor cursor) {
        return new TableReloadEvent(this.getEventId(cursor), this.getStartTime(cursor), this.getScreenshotId(cursor), this.getScreenshotSize(cursor), null, 16, null);
    }

    private final FragmentEvent createFragmentDisplayEvent(Cursor cursor) {
        return new FragmentEvent(this.getEventId(cursor), this.getStartTime(cursor), this.getScreenshotId(cursor), this.getScreenshotSize(cursor), null, this.getName(cursor), 16, null);
    }

    private final AlertViewEvent createDialogDisplayEvent(Cursor cursor) {
        String string = cursor.getString(cursor.getColumnIndexOrThrow("event_subtype"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        AlertViewAction action = AlertViewAction.valueOf((String)string);
        return new AlertViewEvent(action, this.getEventId(cursor), this.getStartTime(cursor), this.getScreenshotId(cursor), this.getScreenshotSize(cursor), null, 32, null);
    }

    private final KeyboardShownEvent createKeyboardShownEvent(Cursor cursor) {
        KeyboardPosition position = new KeyboardPosition(cursor.getInt(cursor.getColumnIndexOrThrow("keyboard_position_x")), cursor.getInt(cursor.getColumnIndexOrThrow("keyboard_position_y")), cursor.getInt(cursor.getColumnIndexOrThrow("keyboard_width")), cursor.getInt(cursor.getColumnIndexOrThrow("keyboard_height")));
        return new KeyboardShownEvent(position, this.getEventId(cursor), this.getStartTime(cursor), this.getScreenshotId(cursor), this.getScreenshotSize(cursor), null, 32, null);
    }

    private final KeyboardHiddenEvent createKeyboardHiddenEvent(Cursor cursor) {
        return new KeyboardHiddenEvent(this.getEventId(cursor), this.getStartTime(cursor), this.getScreenshotId(cursor), this.getScreenshotSize(cursor), null, 16, null);
    }

    private final NavigationEvent createNavigationEvent(Cursor cursor) {
        String string = cursor.getString(cursor.getColumnIndexOrThrow("event_subtype"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        NavigationType type = NavigationType.valueOf((String)string);
        return new NavigationEvent(type, this.getEventId(cursor), this.getStartTime(cursor));
    }

    private final Event createCompoundButtonEvent(Cursor cursor) {
        String string = cursor.getString(cursor.getColumnIndexOrThrow("event_subtype"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        CompoundButtonAction action = CompoundButtonAction.valueOf((String)string);
        return (Event)new CompoundButtonEvent(action, this.getEventId(cursor), this.getStartTime(cursor), this.getScreenshotId(cursor), this.getScreenshotSize(cursor), null, 32, null);
    }

    private final NavigationDrawerEvent createNavigationDrawerEvent(Cursor cursor) {
        String string = cursor.getString(cursor.getColumnIndexOrThrow("event_subtype"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        NavigationDrawerAction action = NavigationDrawerAction.valueOf((String)string);
        return new NavigationDrawerEvent(action, this.getEventId(cursor), this.getStartTime(cursor), this.getScreenshotId(cursor), this.getScreenshotSize(cursor), null, 32, null);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EventType.values().length];
            try {
                nArray[EventType.CUSTOM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.GESTURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.INPUT_START.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.INPUT_END.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.INPUT_KEYSTROKE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.LIFECYCLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.DISPLAY_VIEW.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.RESOLUTION.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.SCROLL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.TOUCH.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.WEBVIEW_LOAD.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.TABLE_RELOAD.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.GENERIC_START_SESSION.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.NAVIGATION.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.FRAGMENT.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.ALERTVIEW.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.KEYBOARD_SHOWN.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.KEYBOARD_HIDDEN.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.COMPOUND_BUTTON.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.NAVIGATION_DRAWER.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

