/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.data.daos.sql;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0006\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH$\u00a2\u0006\u0002\u0010\u000eJ\u001f\u0010\u000f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0004\u00a2\u0006\u0002\u0010\u0012J2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0004J*\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0004J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0004J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0004J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0004J+\u0010!\u001a\u00020\u001d2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00062\u0010\b\u0002\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010$H\u0004\u00a2\u0006\u0002\u0010%J9\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\b\u0010'\u001a\u0004\u0018\u00010\u00062\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010$2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0004\u00a2\u0006\u0002\u0010)R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/dynatrace/android/sessionreplay/data/daos/sql/BaseSqlDAO;", "T", "", "db", "Landroid/database/sqlite/SQLiteDatabase;", "tableName", "", "<init>", "(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;)V", "getDb", "()Landroid/database/sqlite/SQLiteDatabase;", "map", "cursor", "Landroid/database/Cursor;", "(Landroid/database/Cursor;)Ljava/lang/Object;", "get", "idColumn", "id", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", "getByRange", "", "attributeKey", "attributeRangeStartValue", "attributeRangeEndValue", "orderBy", "getByAttribute", "attributeValue", "getAllRecords", "update", "", "values", "Landroid/content/ContentValues;", "delete", "deleteAllRecords", "whereClause", "whereArgs", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "getResults", "selection", "selectionArgs", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)Ljava/util/List;", "datalayer_release"})
public abstract class BaseSqlDAO<T> {
    @NotNull
    private final SQLiteDatabase db;
    @NotNull
    private final String tableName;

    public BaseSqlDAO(@NotNull SQLiteDatabase db, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        this.db = db;
        this.tableName = tableName;
    }

    @NotNull
    protected final SQLiteDatabase getDb() {
        return this.db;
    }

    protected abstract T map(@NotNull Cursor var1);

    @Nullable
    protected final T get(@NotNull String idColumn, @NotNull String id) {
        T t;
        Intrinsics.checkNotNullParameter((Object)idColumn, (String)"idColumn");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        List results = BaseSqlDAO.getByAttribute$default(this, idColumn, id, null, 4, null);
        boolean bl = results.isEmpty();
        if (bl) {
            t = null;
        } else if (!bl) {
            t = (T)results.get(0);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return t;
    }

    @NotNull
    protected final List<T> getByRange(@NotNull String attributeKey, @NotNull String attributeRangeStartValue, @NotNull String attributeRangeEndValue, @Nullable String orderBy) {
        Intrinsics.checkNotNullParameter((Object)attributeKey, (String)"attributeKey");
        Intrinsics.checkNotNullParameter((Object)attributeRangeStartValue, (String)"attributeRangeStartValue");
        Intrinsics.checkNotNullParameter((Object)attributeRangeEndValue, (String)"attributeRangeEndValue");
        String selection = attributeKey + " >= ? AND " + attributeKey + " <= ?";
        String[] stringArray = new String[]{attributeRangeStartValue, attributeRangeEndValue};
        String[] selectionArgs = stringArray;
        return this.getResults(selection, selectionArgs, orderBy);
    }

    public static /* synthetic */ List getByRange$default(BaseSqlDAO baseSqlDAO, String string, String string2, String string3, String string4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getByRange");
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        return baseSqlDAO.getByRange(string, string2, string3, string4);
    }

    @NotNull
    protected final List<T> getByAttribute(@NotNull String attributeKey, @NotNull String attributeValue, @Nullable String orderBy) {
        Intrinsics.checkNotNullParameter((Object)attributeKey, (String)"attributeKey");
        Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
        String selection = attributeKey + " = ?";
        String[] stringArray = new String[]{attributeValue};
        String[] selectionArgs = stringArray;
        return this.getResults(selection, selectionArgs, orderBy);
    }

    public static /* synthetic */ List getByAttribute$default(BaseSqlDAO baseSqlDAO, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getByAttribute");
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        return baseSqlDAO.getByAttribute(string, string2, string3);
    }

    @NotNull
    protected final List<T> getAllRecords() {
        return BaseSqlDAO.getResults$default(this, null, null, null, 4, null);
    }

    protected final void update(@NotNull String attributeKey, @NotNull String attributeValue, @NotNull ContentValues values) {
        Intrinsics.checkNotNullParameter((Object)attributeKey, (String)"attributeKey");
        Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        String selection = attributeKey + " = ?";
        String[] stringArray = new String[]{attributeValue};
        String[] selectionArgs = stringArray;
        this.db.update(this.tableName, values, selection, selectionArgs);
    }

    protected final void delete(@NotNull String attributeKey, @NotNull String attributeValue) {
        Intrinsics.checkNotNullParameter((Object)attributeKey, (String)"attributeKey");
        Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
        String selection = attributeKey + " = ?";
        String[] stringArray = new String[]{attributeValue};
        String[] selectionArgs = stringArray;
        this.db.delete(this.tableName, selection, selectionArgs);
    }

    protected final void deleteAllRecords(@Nullable String whereClause, @Nullable String[] whereArgs) {
        this.db.delete(this.tableName, whereClause, whereArgs);
    }

    public static /* synthetic */ void deleteAllRecords$default(BaseSqlDAO baseSqlDAO, String string, String[] stringArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deleteAllRecords");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            stringArray = null;
        }
        baseSqlDAO.deleteAllRecords(string, stringArray);
    }

    @NotNull
    protected final List<T> getResults(@Nullable String selection, @Nullable String[] selectionArgs, @Nullable String orderBy) {
        Cursor cursor = this.db.query(this.tableName, null, selection, selectionArgs, null, null, orderBy);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"query(...)");
        Cursor cursor2 = cursor;
        List results = new ArrayList();
        while (cursor2.moveToNext()) {
            results.add(this.map(cursor2));
        }
        cursor2.close();
        return results;
    }

    public static /* synthetic */ List getResults$default(BaseSqlDAO baseSqlDAO, String string, String[] stringArray, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getResults");
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return baseSqlDAO.getResults(string, stringArray, string2);
    }
}

