/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.data.daos.sql;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import com.dynatrace.android.sessionreplay.data.daos.SessionDAO;
import com.dynatrace.android.sessionreplay.data.daos.sql.BaseSqlDAO;
import com.dynatrace.android.sessionreplay.data.mappers.Mapper;
import com.dynatrace.android.sessionreplay.model.DataError;
import com.dynatrace.android.sessionreplay.model.Result;
import com.dynatrace.android.sessionreplay.model.Session;
import com.dynatrace.android.sessionreplay.model.SessionState;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001*B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0011\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J$\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J$\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001cH\u0016J$\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0016J$\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\bH\u0014J$\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/dynatrace/android/sessionreplay/data/daos/sql/SQLSessionDAO;", "Lcom/dynatrace/android/sessionreplay/data/daos/sql/BaseSqlDAO;", "Lcom/dynatrace/android/sessionreplay/model/Session;", "Lcom/dynatrace/android/sessionreplay/data/daos/SessionDAO;", "db", "Landroid/database/sqlite/SQLiteDatabase;", "mapper", "Lcom/dynatrace/android/sessionreplay/data/mappers/Mapper;", "Landroid/database/Cursor;", "<init>", "(Landroid/database/sqlite/SQLiteDatabase;Lcom/dynatrace/android/sessionreplay/data/mappers/Mapper;)V", "get", "Lcom/dynatrace/android/sessionreplay/model/Result;", "Lcom/dynatrace/android/sessionreplay/model/DataError;", "id", "", "getAll", "", "create", "session", "delete", "", "deleteAll", "updateVisitId", "oldId", "newId", "updateIsPartiallySent", "isPartiallySent", "", "updateDidCrash", "didCrash", "updateLastEventTimestamp", "lastEventTimestamp", "", "updateState", "state", "Lcom/dynatrace/android/sessionreplay/model/SessionState;", "map", "cursor", "updateValues", "values", "Landroid/content/ContentValues;", "Companion", "datalayer_release"})
public final class SQLSessionDAO
extends BaseSqlDAO<Session>
implements SessionDAO {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Mapper<Cursor, Session> mapper;
    @NotNull
    private static final String TABLE = "session";

    public SQLSessionDAO(@NotNull SQLiteDatabase db, @NotNull Mapper<Cursor, Session> mapper) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        super(db, TABLE);
        this.mapper = mapper;
    }

    @Override
    @NotNull
    public Result<Session, DataError> get(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Session session = (Session)this.get("visit_id", id);
        return session != null ? (Result)new Result.Success((Object)session) : (Result)new Result.Error((Object)DataError.NotFound.INSTANCE);
    }

    @Override
    @NotNull
    public Result<List<Session>, DataError> getAll() {
        return (Result)new Result.Success(this.getAllRecords());
    }

    @Override
    @NotNull
    public Result<Session, DataError> create(@NotNull Session session) {
        Result<Session, DataError> result;
        Intrinsics.checkNotNullParameter((Object)session, (String)TABLE);
        Result<Session, DataError> $this$create_u24lambda_u240 = result = new Result<Session, DataError>();
        boolean bl = false;
        $this$create_u24lambda_u240.put("visit_id", session.getVisitId());
        $this$create_u24lambda_u240.put("device_height", Integer.valueOf(session.getDeviceHeight()));
        $this$create_u24lambda_u240.put("device_width", Integer.valueOf(session.getDeviceWidth()));
        $this$create_u24lambda_u240.put("is_partially_sent", Boolean.valueOf(session.isPartiallySent()));
        $this$create_u24lambda_u240.put("did_crash", Boolean.valueOf(session.getDidCrash()));
        $this$create_u24lambda_u240.put("last_event_timestamp", session.getLastEventTimestamp());
        $this$create_u24lambda_u240.put("state", Integer.valueOf(session.getSessionState().getState()));
        Result<Session, DataError> values = result;
        try {
            this.getDb().insertOrThrow(TABLE, null, (ContentValues)values);
            result = this.get(session.getVisitId());
        }
        catch (SQLException e) {
            result = (Result)new Result.Error((Object)new DataError.SaveError((Throwable)e));
        }
        return result;
    }

    @Override
    public void delete(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.delete("visit_id", id);
    }

    @Override
    public void deleteAll() {
        BaseSqlDAO.deleteAllRecords$default(this, null, null, 3, null);
    }

    @Override
    @NotNull
    public Result<String, DataError> updateVisitId(@NotNull String oldId, @NotNull String newId) {
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)oldId, (String)"oldId");
        Intrinsics.checkNotNullParameter((Object)newId, (String)"newId");
        ContentValues $this$updateVisitId_u24lambda_u241 = contentValues = new ContentValues();
        boolean bl = false;
        $this$updateVisitId_u24lambda_u241.put("visit_id", newId);
        ContentValues values = contentValues;
        return this.updateValues(values, oldId);
    }

    @Override
    @NotNull
    public Result<String, DataError> updateIsPartiallySent(@NotNull String id, boolean isPartiallySent) {
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ContentValues $this$updateIsPartiallySent_u24lambda_u242 = contentValues = new ContentValues();
        boolean bl = false;
        $this$updateIsPartiallySent_u24lambda_u242.put("is_partially_sent", Boolean.valueOf(isPartiallySent));
        ContentValues values = contentValues;
        return this.updateValues(values, id);
    }

    @Override
    @NotNull
    public Result<String, DataError> updateDidCrash(@NotNull String id, boolean didCrash) {
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ContentValues $this$updateDidCrash_u24lambda_u243 = contentValues = new ContentValues();
        boolean bl = false;
        $this$updateDidCrash_u24lambda_u243.put("did_crash", Boolean.valueOf(didCrash));
        ContentValues values = contentValues;
        return this.updateValues(values, id);
    }

    @Override
    @NotNull
    public Result<String, DataError> updateLastEventTimestamp(@NotNull String id, long lastEventTimestamp) {
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ContentValues $this$updateLastEventTimestamp_u24lambda_u244 = contentValues = new ContentValues();
        boolean bl = false;
        $this$updateLastEventTimestamp_u24lambda_u244.put("last_event_timestamp", Long.valueOf(lastEventTimestamp));
        ContentValues values = contentValues;
        return this.updateValues(values, id);
    }

    @Override
    @NotNull
    public Result<String, DataError> updateState(@NotNull String id, @NotNull SessionState state) {
        Result result;
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ContentValues $this$updateState_u24lambda_u245 = contentValues = new ContentValues();
        boolean bl = false;
        $this$updateState_u24lambda_u245.put("state", Integer.valueOf(state.getState()));
        ContentValues values = contentValues;
        String whereClause = "visit_id = ?";
        try {
            result = new Result[]{id};
            result = this.getDb().update(TABLE, values, whereClause, (String[])result) > 0 ? (Result)new Result.Success((Object)id) : (Result)new Result.Error((Object)DataError.NotFound.INSTANCE);
        }
        catch (SQLException e) {
            result = (Result)new Result.Error((Object)new DataError.UpdateError((Throwable)e));
        }
        return result;
    }

    @Override
    @NotNull
    protected Session map(@NotNull Cursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        Session session = this.mapper.map(cursor);
        return session;
    }

    private final Result<String, DataError> updateValues(ContentValues values, String id) {
        Result result;
        String whereClause = "visit_id = ?";
        try {
            result = new Result[]{id};
            result = this.getDb().update(TABLE, values, whereClause, (String[])result) > 0 ? (Result)new Result.Success((Object)id) : (Result)new Result.Error((Object)DataError.NotFound.INSTANCE);
        }
        catch (SQLException e) {
            result = (Result)new Result.Error((Object)new DataError.UpdateError((Throwable)e));
        }
        return result;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/dynatrace/android/sessionreplay/data/daos/sql/SQLSessionDAO$Companion;", "", "<init>", "()V", "TABLE", "", "datalayer_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

